using System.IO;
using System.Threading.Tasks;
using Libplanet.Stun.Messages;
using Xunit;

namespace Libplanet.Stun.Tests.Messages
{
    public class AllocateErrorResponseTest
    {
        [Fact]
        public async Task ParseBytes()
        {
            var bytes = new byte[]
            {
                0x01, 0x13, 0x00, 0x48, 0x21, 0x12, 0xa4, 0x42, 0xee, 0x29,
                0xdd, 0x2d, 0x7a, 0xe9, 0x9c, 0xf4, 0x00, 0x82, 0xf2, 0x5e,
                0x00, 0x09, 0x00, 0x10, 0x00, 0x00, 0x04, 0x01, 0x55, 0x6e,
                0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
                0x00, 0x15, 0x00, 0x10, 0x37, 0x35, 0x64, 0x34, 0x35, 0x34,
                0x31, 0x39, 0x63, 0x33, 0x39, 0x33, 0x34, 0x33, 0x66, 0x65,
                0x00, 0x14, 0x00, 0x0a, 0x74, 0x77, 0x69, 0x6c, 0x69, 0x6f,
                0x2e, 0x63, 0x6f, 0x6d, 0x03, 0x6d, 0x80, 0x22, 0x00, 0x04,
                0x4e, 0x6f, 0x6e, 0x65, 0x80, 0x28, 0x00, 0x04, 0x6e, 0x1e,
                0x55, 0x49,
            };

            using (var stream = new MemoryStream(bytes))
            {
                var response =
                    (AllocateErrorResponse)await StunMessage.ParseAsync(stream);
                Assert.Equal(
                    new byte[]
                    {
                        0xee, 0x29, 0xdd, 0x2d, 0x7a, 0xe9, 0x9c, 0xf4, 0x00, 0x82,
                        0xf2, 0x5e,
                    },
                    response.TransactionId);
                Assert.Equal(401, response.ErrorCode);
                Assert.Equal("twilio.com", response.Realm);
                Assert.Equal(
                    new byte[]
                    {
                    0x37, 0x35, 0x64, 0x34, 0x35, 0x34,
                    0x31, 0x39, 0x63, 0x33, 0x39, 0x33,
                    0x34, 0x33, 0x66, 0x65,
                    },
                    response.Nonce
                );
            }
        }
    }
}
