Libplanet changelog
===================

Version 3.9.6
-------------

Released on January 26, 2024.

 -  (Libplanet.Store) Optimized `TrieStateStore.CopyStates()` to greatly
    reduce the amount of memory used.  [[#3634]]

[#3634]: https://github.com/planetarium/libplanet/pull/3634


Version 3.9.5
-------------

Released on January 18, 2024.

 -  (Libplanet.Store) Changed `IStateStore.Commit()` to return an `ITrie`
    with either its `Root` as `null` or a `HashNode`.  [[#3610]]
 -  (Libplanet.Store) Removed `IStateStore.PruneStates()` method.
    [[#3613], [#3614]]

[#3610]: https://github.com/planetarium/libplanet/pull/3610
[#3613]: https://github.com/planetarium/libplanet/issues/3613
[#3614]: https://github.com/planetarium/libplanet/pull/3614


Version 3.9.4
-------------

Released on January 11, 2024.

 -  (Libplanet.Explorer) Rolled back some changes to the API to be
    more compatible with pre-3.9.3 API.  [[#3600]]
     -  Changed the name `BencodexValueType` to `IValueType`.
     -  Changed the name `LegacyBencodexValueType` to `BencodexValueType`.
     -  Changed `AddressType.Name` from `address` to `Address`.
     -  Changed `BlockHashType.Name` from `blockHash` to `BlockHash`.
     -  Changed `PublicKeyType.Name` from `publicKey` to `PublicKey`.
     -  Changed `TxIdType.Name` from `txId` to `TxId`.

[#3600]: https://github.com/planetarium/libplanet/pull/3600


Version 3.9.3
-------------

Released on January 4, 2024.

Due to changes in [#3567], a network ran with a prior version may not
be compatible with this version,  specifically, those that ran with
[Libplanet 2.0.0] and onwards prior to this release that have included
`Transaction`s that aren't compatible with the updated specification in [#3567].

 -  (Libplanet.Explorer) Added `BlockHashType` and `TxIdType`.  [[#3559]]
 -  (Libplanet.Explorer) Changed `HashDigestSHA256Type` to `HashDigestType<T>`.
    [[#3559]]
 -  (Libplanet.Explorer) Changed `BencodexValueType` to inherit
    `ObjectGraphType<IValue>` instead of `StringGraphType`.  Instead of
    simply being a hexadecimal representation of `byte[]` encoded `IValue`,
    now one can choose its representation format.  [[#3560]]
 -  (Libplanet.Explorer) Added `HelperQuery`, a collection of utility like
    queries.  [[#3561]]
 -  (Libplanet.Explorer) Removed `IRichStore.StoreUpdatedAddressReferences()`
    and `IterateUpdatedAddressReferences()` interface methods.  [[#3562]]
 -  (Libplanet.Explorer) Removed `involvedAddress` argument from all
    `TransactionQuery` query methods.  [[#3562]]
 -  (Libplanet.Explorer) Removed `IRichStore` interface.  [[#3564]]
 -  (Libplanet.Explorer) Removed parameters `mysql-server`, `mysql-port`,
    `mysql-username`, `mysql-password`, and `mysql-database` from
    `Libplanet.Explorer.Executable`.  [[#3564]]
 -  Changed `TxInvoice` to no longer allow negative values for
    `MaxGasPrice` and `GasLimit`.  [[#3567]]
 -  (Libplanet.Explorer) Added `AccountStateType` class.  [[#3570]]
 -  (Libplanet.Explorer) Added `account` and `accounts` query to `StateQuery`.
    [[#3570]]
 -  (Libplanet.Store) Changed `ShortNode` to no longer inherit `BaseNode`.
    `ShortNode.Value` is no longer nullable.  [[#3572]]
 -  (Libplanet.Store) Removed `FullNode()` and added `FullNode.Empty`.
    [[#3573]]
 -  (Libplanet.Store) Slightly optimized `ITrie` performance.  [[#3573]]
 -  (Libplanet.Store) Changed `FullNode` to no longer inherit `BaseNode`.
    [[#3574]]
 -  (Libplanet.Store) Removed `BaseNode`.  [[#3574]]
 -  (Libplanet.Store) Added `ITrie.Remove()` interface method.  [[#3576]]
 -  (Libplanet.Store) Added `FullNode.RemoveChild()` method.  [[#3576]]
 -  (Libplanet.Action) Added `IAccount.RemoveState()` interface method.
    [[#3577]]
 -  (Libplanet.Explorer) Added `LegacyBencodexValueType` class that is
    a copy of an old `BencodexValueType` with its name changed
    for backwards compatibility.  Changed old `states` query
    to use `LegacyBencodexValueType` instead of `BencodexValueType`.  [[#3579]]

[#3559]: https://github.com/planetarium/libplanet/pull/3559
[#3560]: https://github.com/planetarium/libplanet/pull/3560
[#3561]: https://github.com/planetarium/libplanet/pull/3561
[#3562]: https://github.com/planetarium/libplanet/pull/3562
[#3564]: https://github.com/planetarium/libplanet/pull/3564
[#3567]: https://github.com/planetarium/libplanet/pull/3567
[#3570]: https://github.com/planetarium/libplanet/pull/3570
[#3572]: https://github.com/planetarium/libplanet/pull/3572
[#3573]: https://github.com/planetarium/libplanet/pull/3573
[#3574]: https://github.com/planetarium/libplanet/pull/3574
[#3576]: https://github.com/planetarium/libplanet/pull/3576
[#3577]: https://github.com/planetarium/libplanet/pull/3577
[#3579]: https://github.com/planetarium/libplanet/pull/3579


Version 3.9.2
-------------

Released on December 15, 2023.

 -  (Libplanet.RocksDBStore) Added `DBOptions` type parameter to
    `RocksDBKeyValueStore()`.  [[#3553]]

[#3553]: https://github.com/planetarium/libplanet/pull/3553


Version 3.9.1
-------------

Released on December 8, 2023.

 -  (Libplanet.Explorer) Added `INCLUDED` to `TxStatus` enum.  [[#3542]]

[#3542]: https://github.com/planetarium/libplanet/pull/3542


Version 3.9.0
-------------

Released on December 5, 2023.

Due to changes in [#3529], a network ran with a prior version may not
be compatible with this version,  specifically, those that ran with
[Libplanet 2.0.0] and onwards prior to this release that have included
`Transaction`s that aren't compatible with the updated specification in [#3529].

### Backward-incompatible API changes

 -  (Libplanet.Action) Removed unnecessary extension methods:  [[#3520]]
     -  `IReadOnlyList<IActionEvaluation>.GetRawTotalDelta()`
     -  `IReadOnlyList<IAccountDelta>.OrderedSum()`
     -  `IAccountDelta.ToRawDelta()`
     -  `IAccount.GetUpdatedStates()`
     -  `IAccount.GetUpdatedBalances()`
     -  `IAccount.GetUpdatedTotalSupplies()`
 -  (Libplanet.Action) Changed `IAccount` to no longer track `IAccountDelta`.
    [[#3520]]
 -  (Libplanet.Action) Removed `IAccountDelta` as parameter for constructors
    of `Account` class.  [[#3520]]
 -  (Libplanet.Action) Removed `hashedSignature` of type `byte[]` parameter
    from `ActionEvaluator.GenerateRandomSeed()`.  [[#3523]]
 -  Changed `TxInvoice` to no longer allow having the null-ness of
    `MaxGasPrice` and `GasLimit` to be different, i.e. either both should be
    null or both should not be null at the same time.  [[#3529]]
 -  (Libplanet.Action) Removed `IAccountDelta` interface.  [[#3535]]
 -  (Libplanet.Action) Removed `IAccount.Delta` interface property.  [[#3535]]
 -  (Libplanet.Action) Changed constructor `IAccount(IAccountState,
    IImmutableDictionary<(Address, Currency), BigInteger>)` to
    `IAccount(IAccountState, IImmutableHashSet<(Address, Currency)>)`.
    [[#3537]]

[#3520]: https://github.com/planetarium/libplanet/pull/3520
[#3523]: https://github.com/planetarium/libplanet/pull/3523
[#3529]: https://github.com/planetarium/libplanet/pull/3529
[#3535]: https://github.com/planetarium/libplanet/pull/3535
[#3537]: https://github.com/planetarium/libplanet/pull/3537
[Libplanet 2.0.0]: https://www.nuget.org/packages/Libplanet/2.0.0


Version 3.8.1
-------------

Released on November 27, 2023.

 -  (Libplanet.Net) Fixed a bug where `GossipConsensusMessageCommunicator`
    does not clear `_peerCatchupRounds` on `OnStartHeight()`.  [[#3519]]
 -  (Libplanet.Net) `GossipConsensusMessageCommunicator` now filters
    `ConsensusVoteMsg` which height is different from latest `Context`.
    [[#3519]]
 -  (Libplanet.Action) Fixed a bug where initialization of `AccountMetrics`
    is absent.  [[#3521]]

[#3519]: https://github.com/planetarium/libplanet/pull/3519
[#3521]: https://github.com/planetarium/libplanet/pull/3521


Version 3.8.0
-------------

Released on November 24, 2023.

### Backward-incompatible API changes

 -  Removed `updatedAddresses` parameter from `BlockChain.MakeTransaction()`
    [[#3480]]
 -  Removed `updatedAddresses` parameter from `Transaction.Create()`.  [[#3480]]
 -  Removed `updatedAddresses` parameter from all `TxInvoice()`.  [[#3480]]
 -  Removed `Rehearsal` property from `IActionContext` and
    `ICommittedActionContext`.  [[#3485]]
 -  (Libplanet.Crypto) Removed `ToAddress()` extension method for
    `PrivateKey` and `PublicKey`.  [[#3486]]
 -  (Libplanet.Crypto) Added `Address` property to `PrivateKey` and `PublicKey`.
    [[#3486]]

### Backward-incompatible storage format changes

  -  (Libplanet.Store) Changed `Libplanet.RocksDBStore` to use
     [`RocksDb`] instead of [`RocksDBSharp`].
     *Note* Cannot read new version of `Libplanet.RocksDBStore`
     storage from under `Libplanet.RocksDBStore` version 3.6.1.
     [[#1848], [#3487]]

### Added APIs

 -  (Libplanet.RocksDBStore) Added `RocksDBInstanceType` enum.  [[#3488]]
 -  (Libplanet.RocksDBStore) Changed `RocksDBStore` and `RocksDBKeyValueStore`
    to accept `RocksDBInstanceType` type `instanceType` parameter instead of
    `@readonly` parameter in their constructor.
    [[#3488], [RocksDb Instance Types]]

[#1848]: https://github.com/planetarium/libplanet/issues/1848
[#3480]: https://github.com/planetarium/libplanet/pull/3480
[#3485]: https://github.com/planetarium/libplanet/pull/3485
[#3486]: https://github.com/planetarium/libplanet/pull/3486
[#3487]: https://github.com/planetarium/libplanet/pull/3487
[#3488]: https://github.com/planetarium/libplanet/pull/3488
[`RocksDb`]: https://www.nuget.org/packages/RocksDB
[`RocksDBSharp`]: https://www.nuget.org/packages/Planetarium.RocksDbSharp
[RocksDb Instance Types]: https://github.com/facebook/rocksdb/wiki/Read-only-and-Secondary-instances


Version 3.7.1
-------------

Released on November 21, 2023.

 -  Ported changes from [Libplanet 3.6.1] release.  [[#3500]]
 -  Ported changes from [Libplanet 3.6.2] release.  [[#3509]]

[#3500]: https://github.com/planetarium/libplanet/pull/3500
[#3509]: https://github.com/planetarium/libplanet/pull/3509
[Libplanet 3.6.1]: https://www.nuget.org/packages/Libplanet/3.6.1
[Libplanet 3.6.2]: https://www.nuget.org/packages/Libplanet/3.6.2

Version 3.7.0
-------------

Released on October 27, 2023.

### Backward-incompatible API changes

 -  Added `IBencodable` interface to `HashDigest<T>`.  [[#3455]]

### Behavioral changes

 -  Slightly optimized `BlockMarshaler`.  [[#3454]]

### Dependencies

 -  Upgrade *Bencodex* from [0.14.0][Bencodex 0.14.0] to
    [0.16.0][Bencodex 0.16.0].  [[#3461]]
 -  Upgrade *Bencodex.Json* from [0.11.0][Bencodex.Json 0.11.0] to
    [0.16.0][Bencodex.Json 0.16.0].  [[#3461]]

[#3454]: https://github.com/planetarium/libplanet/pull/3454
[#3455]: https://github.com/planetarium/libplanet/pull/3455
[#3461]: https://github.com/planetarium/libplanet/pull/3461
[Bencodex 0.16.0]: https://www.nuget.org/packages/Bencodex/0.16.0
[Bencodex.Json 0.11.0]: https://www.nuget.org/packages/Bencodex.json/0.11.0
[Bencodex.Json 0.16.0]: https://www.nuget.org/packages/Bencodex.json/0.16.0


Version 3.6.2
-------------

Released on November 21, 2023.

 -  (Libplanet.Net) Changed default `ContextTimeoutOption` values for
    more consistent and stable consensus.  [[#3506]]

[#3506]: https://github.com/planetarium/libplanet/pull/3506


Version 3.6.1
-------------

Released on November 20, 2023.

 -  (Libplanet.Store) Added optional `cache` parameter of type `HashNodeCache`
    to `MerkleTrie()` constructors.  [[#3495]]
 -  (Libplanet.Store) Added `HashNodeCache` class.  [[#3495]]
 -  (Libplanet.Store) Changed internal caching strategy of `TrieStateStore` for
    read/write optimization.  [[#3495]]

[#3495]: https://github.com/planetarium/libplanet/pull/3495


Version 3.6.0
-------------

Released on October 6, 2023.

### Backward-incompatible API changes

 -  Changed `IActionEvaluator.Evaluate()`'s return type to
    `IReadOnlyList<ICommittedActionEvaluation>` from
    `IReadOnlyList<IActionEvaluation>`.  [[#3445]]
 -  Changed `BlockChain.DetermineStateRootHash(IActionEvaluator,
    IPreEvaluationBlock, out IReadOnlyList<IActionEvaluation>)` to
    `BlockChain.DetermineStateRootHash(IActionEvaluator,
    IPreEvaluationBlock, out IReadOnlyList<ICommittedActionEvaluation>)`.
    [[#3445]]
 -  Changed `BlockChain.EvaluateGenesis()`'s return type to
    `IReadOnlyList<ICommittedActionEvaluation>` from
    `IReadOnlyList<IActionEvaluation>`.  [[#3445]]
 -  Changed `BlockChain.EvaluateBlock()`'s return type to
    `IReadOnlyList<ICommittedActionEvaluation>` from
    `IReadOnlyList<IActionEvaluation>`.  [[#3445]]
 -  Removed `StateStoreExtensions` class.  [[#3323], [#3450]]

### Added APIs

 -  (Libplanet.Explorer) Added `TxResult.InputState` of type
    `HashDigest<SHA256>?`.  [[#3446], [#3447]]
 -  (Libplanet.Explorer) Added `TxResult.OutputState` of type
    `HashDigest<SHA256>?`.  [[#3446], [#3447]]
 -  (Libplanet.Explorer) Added `offsetStateRootHash` of type
    `HashDigest<SHA256>?` argument for `StateQuery.states` field.
    [[#3448], [#3449]]
 -  (Libplanet.Explorer) Added `offsetStateRootHash` of type
    `HashDigest<SHA256>?` argument for `StateQuery.balance` field.
    [[#3448], [#3449]]
 -  (Libplanet.Explorer) Added `offsetStateRootHash` of type
    `HashDigest<SHA256>?` argument for `StateQuery.totalSupply` field.
    [[#3448], [#3449]]
 -  (Libplanet.Explorer) Added `offsetStateRootHash` of type
    `HashDigest<SHA256>?` argument for `StateQuery.validators` field.
    [[#3448], [#3449]]

### Behavioral changes

 -  `IActionEvaluator.Evaluate()`, `BlockChain.EvaluateGenesis()`,
    and `BlockChain.EvaluateBlock()` have a side-effect of storing
    data to `IStateStore` when called.  [[#3445]]

[#3323]: https://github.com/planetarium/libplanet/issues/3323
[#3445]: https://github.com/planetarium/libplanet/pull/3445
[#3446]: https://github.com/planetarium/libplanet/issues/3446
[#3447]: https://github.com/planetarium/libplanet/pull/3447
[#3448]: https://github.com/planetarium/libplanet/issues/3448
[#3449]: https://github.com/planetarium/libplanet/pull/3449
[#3450]: https://github.com/planetarium/libplanet/pull/3450


Version 3.5.0
-------------

Released on October 4, 2023.

### Backward-incompatible API changes

 -  Removed `IActionContext.Random` property.  Use `IActionContext.GetRandom()`
    instead.  [[#3437]]
 -  Added `IActionContext.RandomSeed` property.  [[#3437]]
 -  Added `IActionContext.GetRandom()` method.  [[#3437]]
 -  Changed `IActionEvaluator.Evaluate(IPreEvaluationBlock)` to
    `IActionEvaluator.Evaluate(IPreEvaluationBlock, HashDigest<SHA256>)`.
    [[#3438]]
 -  Changed `ActionEvaluator` to accept `IStateStore` instead of
    `IBlockChainStates`  [[#3439]]

[#3437]: https://github.com/planetarium/libplanet/pull/3437
[#3438]: https://github.com/planetarium/libplanet/pull/3438
[#3439]: https://github.com/planetarium/libplanet/pull/3439


Version 3.4.0
-------------

Released on September 25, 2023.

### Backward-incompatible API changes

 -  Added `IBlockChainStates.GetAccountState(HashDigest<SHA256>?)`
    interface method.  [[#3425]]
 -  Removed `TxFailure.ExceptionMetadata` property.  [[#3428]]
 -  Removed `ISerializable` interface from `TxExecution`, `TxSuccess`,
    and `TxFailure`.  [[#3428]]
 -  Removed `TxSuccess` and `TxFailure` class.  [[#3429]]
 -  Changed `TxExecution` class as `sealed` from `abstract.`  [[#3429]]
 -  All properties of `TxExecution` except `BlockHash` and `TxId` were
    overhauled.  [[#3429]]
 -  (Libplanet.Store) Removed `IStore.PutTxExecution(TxSuccess)` and
    `IStore.PutTxExecution(TxFailure)`;
    added `IStore.PutTxExecution(TxExecution)`.  [[#3429]]
 -  (Libplanet.Explorer) Removed `TxResult.ExceptionName` of type `string?`
    and added `TxResult.ExceptionNames` of type `List<string?>?`.  [[#3429]]
 -  (Libplanet.Explorer) Removed `TxResult.UpdatedStates` and
    `TxResult.UpdatedFungibleAssets`.  [[#3429]]
 -  Changed `IActionRenderer.RenderAction(IValue, IActionContext, IAccount)`
    to `IActionRenderer.RenderAction(IValue, ICommittedActionContext,
    HashDigest<SHA256>)`.  [[#3431]]
 -  Changed `IActionRenderer.RenderActionError(IValue, IActionContext,
    Exception)` to `IActionRenderer.RenderActionError(IValue,
    ICommittedActionContext, Exception)`.  [[#3431]]

### Added APIs

 -  Added `AccountDiff` class.  [[#3424]]
 -  Added `ICommittedActionContext` interface.  [[#3431]]
 -  Added `ICommittedActionEvaluation` interface.  [[#3431]]

[#3424]: https://github.com/planetarium/libplanet/pull/3424
[#3425]: https://github.com/planetarium/libplanet/pull/3425
[#3428]: https://github.com/planetarium/libplanet/pull/3428
[#3429]: https://github.com/planetarium/libplanet/pull/3429
[#3431]: https://github.com/planetarium/libplanet/pull/3431


Version 3.3.1
-------------

Released on September 8, 2023.

-  (Libplanet.Store) Fixed a bug where `ITrie.Get()` could wrongly retrieve
   an `IValue` from a non-existent path.  [[#3420]]

[#3420]: https://github.com/planetarium/libplanet/pull/3420


Version 3.3.0
-------------

Released on September 7, 2023.

### Backward-incompatible API changes

 -  (Libplanet.Store) Removed `ITrie.Commit()` method.  [[#3392]]
 -  (Libplanet.Store) Added `IStateStore.Commit()` method.  [[#3398]]
 -  (Libplanet.Store) Removed `IKeyValueStore.Get(IEnumerable<KeyBytes> keys)`
    method.  [[#3362], [#3400]]
 -  (Libplanet.Store) Added `PathCursor` struct.  [[#3399]]
 -  (Libplanet.Store) Added `Nibbles` struct.  [[#3399]]
 -  (Libplanet.Store) Changed `KeyBytes` to no longer implement
    `IEquatable<byte[]>` and `IEquatable<ImmutableArray<byte>>`.  [[#3402]]
 -  (Libplanet.Store) Added `ITrie.GetNode()` method.  [[#3401]]
 -  (Libplanet.Store) Added `ITrie.IterateValues()` method.  [[#3405]]
 -  (Libplanet.Store) Added `ITrie.IterateNodes()` method.  [[#3405]]
 -  (Libplanet.Store) Removed `Secure` option from `TrieStateStore`.  [[#3407]]
     -  Removed `secure` parameter from `TrieStateStore()`.
     -  Removed `ITrie.Secure` property.
     -  Removed `secure` parameter from `MerkleTrie()`.
     -  Removed `secure` parameter from `PathCursor()`.
 -  (Libplanet.Store) Added `ITrie.Diff()` method.  [[#3410]]
 -  (Libplanet.Store) Removed `MerkleTrieExtensions.DifferentNodes()`
    static method.  [[#3410]]
 -  Removed `IBlockState` interface.  [[#3413]]
 -  Removed `IBlockChainState.GetBlockState()` interface method.  [[#3413]]
 -  Added `IBlockChainState.GetAccountState()` interface method.  [[#3413]]
 -  Added `IAccountState` interface.  [[#3416]]
 -  Added `AccountState` class.  [[#3416]]

### Added APIs

 -  (Libplanet.RocksDBStore) `RocksDBStore` and `RocksDBKeyValueStore` became to
    receive `@readonly` parameter in their constructor. If it is true, it opens
    rocksdb as read-only mode.  [[#3354], [#3356], [RocksDB Read Only]]

### Behavioral changes

 -  (Libplanet.Store) Changed `ShortNode` to no longer accept empty `byte`
    arrays.  [[#3390]]

### Bug fixes

 -  (Libplanet.Store) Fixed `Equals()` for `FullNode` and `ShortNode`.
    [[#3377]]
 -  (Libplanet.Store) Fixed a bug where adding two `byte` arrays as keys
    with one being a subsequence of the other would break `MerkleTrie`
    and lose data.  [[#3390]]
 -  (Libplanet.Store) Fixed a bug where when trying to add a value to
    an existing `FullNode` would throw an `Exception`.  [[#3390]]
 -  (Libplanet.Store) Fixed a bug where committing an `ITrie` may return
    an `ITrie` with a different path security scheme.  [[#3401]]

[#3354]: https://github.com/planetarium/libplanet/issues/3354
[#3356]: https://github.com/planetarium/libplanet/pull/3356
[#3362]: https://github.com/planetarium/libplanet/issues/3362
[#3377]: https://github.com/planetarium/libplanet/pull/3377
[#3390]: https://github.com/planetarium/libplanet/pull/3390
[#3392]: https://github.com/planetarium/libplanet/pull/3392
[#3398]: https://github.com/planetarium/libplanet/pull/3398
[#3399]: https://github.com/planetarium/libplanet/pull/3399
[#3400]: https://github.com/planetarium/libplanet/pull/3400
[#3401]: https://github.com/planetarium/libplanet/pull/3401
[#3402]: https://github.com/planetarium/libplanet/pull/3402
[#3405]: https://github.com/planetarium/libplanet/pull/3405
[#3407]: https://github.com/planetarium/libplanet/pull/3407
[#3410]: https://github.com/planetarium/libplanet/pull/3410
[#3413]: https://github.com/planetarium/libplanet/pull/3413
[#3416]: https://github.com/planetarium/libplanet/pull/3416
[RocksDB Read Only]: https://github.com/facebook/rocksdb/wiki/Read-only-and-Secondary-instances


Version 3.2.0
-------------

Released on August 10, 2023.

### Backward-incompatible API changes

 -  (Libplanet.Action) Renamed `IAccountStateDelta` as `IAccount`.
    [[#3337]]
 -  (Libplanet.Store) Optimized `MerkleTrie.Get()`.  [[#3347]]
 -  (Libplanet.Types) Removed `TxSuccess.FungibleAssetsDelta`  [[#3357]]
 -  (Libplanet.Explorer) Removed `TxResult.ExceptionMetadata` and
    `TxResult.FungibleAssetsDelta`.  [[#3357]]
 -  (Libplanet.Store) Added `ITrie.Get(KeyBytes)` interface method.  [[#3359]]
 -  (Libplanet.Store) Optimized `MerkleTrie.Get()` by allowing parallel
    processing when more than 4 `KeyBytes` keys are given.  [[#3359]]

[#3337]: https://github.com/planetarium/libplanet/pull/3337
[#3347]: https://github.com/planetarium/libplanet/pull/3347
[#3357]: https://github.com/planetarium/libplanet/pull/3357
[#3359]: https://github.com/planetarium/libplanet/pull/3359


Version 3.1.2
-------------

Released on August 10, 2023.

 -  Upgrade *Bencodex* from [0.12.0][Bencodex 0.12.0] to
    [0.14.0][Bencodex 0.14.0].  [[#3367]]

[#3367]: https://github.com/planetarium/libplanet/pull/3367
[Bencodex 0.14.0]: https://www.nuget.org/packages/Bencodex/0.14.0


Version 3.1.1
-------------

Released on August 9, 2023.

 -  Fixed a bug where `Swarm` checks block existent when preloading.
    [[#3253], [#3353], [#3360]]

[#3253]: https://github.com/planetarium/libplanet/issues/3253
[#3353]: https://github.com/planetarium/libplanet/pull/3353
[#3360]: https://github.com/planetarium/libplanet/pull/3360


Version 3.1.0
-------------

Released on July 27, 2023.

### Backward-incompatible API changes

 -  Changed `StateStoreExtensions.Commit()` to accept
    `IImmutableDictionary<KeyBytes, IValue>` instead of
    `IImmutableDictionary<string, IValue>`.  [[#3321]]
 -  Changed `AccountDeltaExtensions.ToRawDelta()` to return
    `IImmutableDictionary<KeyBytes, IValue>` instead of
    `IImmutableDictionary<string, IValue>`.  [[#3321]]
 -  Changed `ActionEvaluatorExtensions.GetRawTotalDelta()` to return
    `IImmutableDictionary<KeyBytes, IValue>` instead of
    `IImmutableDictionary<string, IValue>`.  [[#3321]]
 -  Removed `EnumerableMeasurement` class.  [[#3325]]
 -  Removed `KeyValueExtensions` class.  [[#3325]]
 -  Removed `StateStoreExtensions.EncodeKey()` and
    `StateStoreExtensions.DecodeKey()` methods.  [[#3328]]
 -  Removed `StateStoreExtensions.GetStates(IStateStore, HashDigest<SHA256>?,
    IReadOnlyList<string>)` method.  [[#3328]]
 -  Removed `TrieExtensions.Set(ITrie,
    IEnumerable<KeyValuePair<string, IValue?>)` method.  [[#3328]]
 -  Removed `KeyBytes(string, Encoding)` constructor.  [[#3328]]

### Added APIs

 -  Added `StateStoreExtensions.GetStates(IStateStore, HashDigest<SHA256>,
    IReadOnlyList<KeyBytes>)` method.  [[#3321]]
 -  Added `KeyBytes.Encoding` static property.  [[#3328]]
 -  Added `KeyBytes(string)` constructor.  [[#3328]]

### Behavioral changes

 -  Optimized read and write access to `IStateStore` both for memory and speed.
    [[#3321]]

### Dependencies

 -  Upgrade *Bencodex* from [0.11.0][Bencodex 0.11.0] to
    [0.12.0][Bencodex 0.12.0].  [[#3335]]

[#3321]: https://github.com/planetarium/libplanet/pull/3321
[#3325]: https://github.com/planetarium/libplanet/pull/3325
[#3328]: https://github.com/planetarium/libplanet/pull/3328
[#3335]: https://github.com/planetarium/libplanet/pull/3335
[Bencodex 0.12.0]: https://www.nuget.org/packages/Bencodex/0.12.0


Version 3.0.1
-------------

Released on July 21, 2023.

 -  Fixed builds and tests.  [[#3326]]

[#3326]: https://github.com/planetarium/libplanet/pull/3326


Version 3.0.0
-------------

Released on July 19, 2023.

### Backward-incompatible API changes

 -  (Libplanet.Common) Moved packages from `Libplanet`.  [[#3300]]
     -  `Libplanet.Serialization`
     -  `Libplanet.JsonConverters`
 -  (Libplanet.Common) Moved packages from `Libplanet`.  [[#3314]]
     -  `Libplanet.Misc`
 -  (Libplanet.Crypto) Moved packages from `Libplanet`.  [[#3314]]
     -  `Libplanet.Crypto`
 -  (Libplanet.Types) Moved packages from `Libplanet`.  [[#3314]]
     -  `Libplanet.Assets`
     -  `Libplanet.Blocks`
     -  `Libplanet.Consensus`
     -  `Libplanet.Tx`
 -  (Libplanet.Store) Moved packages from `Libplanet`.  [[#3303]]
     -  `Libplanet.Store`
 -  (Libplanet.Action) Moved packages from `Libplanet`.  [[#3310]]
     -  `Libplanet.Action`
 -  Removed `IExtractableException` and `ExtractableException`.  [[#3304]]

### Added APIs

 -  (Libplanet.Net) Added `Gossip.DeniedPeers` property.  [[#3313]]

### Behavioral changes

 -  `TxFailure` no longer tracks `ExceptionMetadata` and is always
    set to `null` even for already stored `TxFailure`.  [[#3304]]

[#3300]: https://github.com/planetarium/libplanet/pull/3300
[#3303]: https://github.com/planetarium/libplanet/pull/3303
[#3304]: https://github.com/planetarium/libplanet/pull/3304
[#3310]: https://github.com/planetarium/libplanet/pull/3310
[#3313]: https://github.com/planetarium/libplanet/pull/3313
[#3314]: https://github.com/planetarium/libplanet/pull/3314
