Libplanet changelog
===================

Version 2.5.0
-------------

Released on July 12, 2023.

Due to changes in [[#3272]], a network ran with a prior version may not
be compatible with this version.

### Backward-incompatible API changes

 -  (Libplanet.Net) Added
    `Gossip.PublishMessage(MessageContent, IEnumerable<BoundPeer>)` method.
    [[#3206]]
 -  (Libplanet.Net) Added `Context.AddMaj23()` method.  [[#3206]]
 -  (Libplanet.Net) Added `Context.GetVoteSetBits()` method.  [[#3206]]
 -  (Libplanet.Net) Added `Context.GetVoteSetBitsResponse()` method.  [[#3206]]
 -  (Libplanet.Net) Added `ConsensusContext.HandleMaj23()` method.
    [[#3206]]
 -  (Libplanet.Net) Added `ConsensusContext.HandleVoteSetBits()` method.
    [[#3206]]
 -  (Libplanet.Net) Added `ConsensusContext.HandleProposalClaim()` method.
    [[#3206]]
 -  Removed `ActionTypeAttribute.ValueOf()` method.  [[#3267]]
 -  Added `Action<Message> validateMessageToReceive` parameter
    to `Gossip`'s constructor.  [[#3273]]
 -  Added `Action<MessageContent> validateMessageToSend` parameter
    to `Gossip`'s constructor.  [[#3273]]
 -  Removed `Action<Message> validateMessage` parameter
    from `Gossip`'s constructor.  [[#3273]]
 -  Removed `AccountStateGetter`, `AccountBalanceGetter`, `TotalSupplyGetter`,
    and `ValidatorSetGetter` delegates.  [[#3282]]
 -  Removed `IFeeCalculator` interface.  [[#3283]]
 -  Removed `IBlockPolicy.FeeCalculator` interface property.  [[#3283]]
 -  Removed `TxExecution.ActionsLogsList`, `TxFailure.ActionsLogsList`,
    and `TxSuccess.ActionsLogsList` properties.  [[#3291]]
 -  (Libplanet.Explorer) Removed `TxResult.ActionsLogsList` property.  [[#3291]]
 -  Removed `IActionContext.Logs` property and `IActionContext.PutLog()` method.
    [[#3292]]
 -  Removed `IActionEvaluation.Logs` property. [[#3292]]

### Added APIs

 -  Added `VoteSetBits` and its related classes.  [[#3206]]
     -  Added `VoteSetBits` class.
     -  Added `VoteSetBitsMetadata` class.
     -  (Libplanet.Net) Added `ConsensusVoteSetBitsMsg` class.
 -  Added `ProposalClaim` and its related class.  [[#3206]]
     -  Added `ProposalClaim` class.
     -  Added `ProposalClaimMetadata` class.
     -  (Libplanet.Net) Added `ConsensusProposalClaimMsg` class.
 -  (Libplanet.Net) Added `ConsensusMaj23Msg` class.  [[#3206]]
 -  (Libplanet.Net) Added enumeration items to `MessageType` enum.  [[#3206]]
     -  Added `ConsensusMaj23Msg` of value `0x53`.
     -  Added `ConsensusVoteSetBitsMsg` of value `0x54`.
     -  Added `ConsensusProposalClaimMsg` of value `0x55`.
 -  Added `IActionContext.Logs` interface property.  [[#3274]]
 -  Changed the type for `IActionEvaluation.Logs` to
    `IReadOnlyList<string>` from `List<string>`.  [[#3274]]
 -  Changed the type for `TxExecution.ActionsLogList` to
    `List<IReadOnlyList<string>>?` from `List<List<string>>?`.  [[#3274]]
 -  (Libplanet.Explorer) Changed the type for `TxResult.ActionsLogList` to
    `List<IReadOnlyList<string>>?` from `List<List<string>>?`.  [[#3274]]
 -  (Libplanet.Explorer) Added `BlockType.PreEvaluationHash` field.
    [[#3280], [#3281]]
 -  (Libplanet.Net) Added `VoteSet.GetAllVotes()` method.  [[#3288]]

### Behavioral changes

 -  (Libplanet.Net) `Context` became to remove its proposal
    when +2/3 valid votes were collected.  [[#3206]]
 -  Changed `ActionEvaluator` to evaluate all `IAction`s in a `Transaction`
    without early termination even if an `IAction` throws an `Exception`.
    [[#3272]]
 -  `Gossip.HandleMessageAsync()` now executes `_validateMessageToReceive`
    on given message received.  [[#3273]]
 -  `Gossip.SendWantAsync()` now executes `_validateMessageToReceive`
    on replies of `WantMessage`.  [[#3273]]
 -  `Gossip.HandleWantAsync()` now executes `_validateMessageToSend`
    on given message to send as a reply of `WantMessage`.  [[#3273]]
 -  `GossipConsensusMessageCommunicator` now prevents sending a message
    with a round other than its own as a reply to a `WantMessage`.  [[#3273]]
 -  `GossipConsensusMessageCommunicator` now executes anti-spam logic
    when messages are received.  [[#3273]]

### Bug fixes

 -  Fixed a broken backwards compatibility of Currency  [[#3268], [#3284]]

[#3206]: https://github.com/planetarium/libplanet/pull/3206
[#3267]: https://github.com/planetarium/libplanet/pull/3267
[#3268]: https://github.com/planetarium/libplanet/issues/3268
[#3272]: https://github.com/planetarium/libplanet/pull/3272
[#3273]: https://github.com/planetarium/libplanet/pull/3273
[#3274]: https://github.com/planetarium/libplanet/pull/3274
[#3280]: https://github.com/planetarium/libplanet/issues/3280
[#3281]: https://github.com/planetarium/libplanet/pull/3281
[#3282]: https://github.com/planetarium/libplanet/pull/3282
[#3283]: https://github.com/planetarium/libplanet/pull/3283
[#3284]: https://github.com/planetarium/libplanet/pull/3284
[#3288]: https://github.com/planetarium/libplanet/pull/3288
[#3291]: https://github.com/planetarium/libplanet/pull/3291
[#3292]: https://github.com/planetarium/libplanet/pull/3292


Version 2.4.1
-------------

Released on July 14, 2023.

 -  Slight speed and memory optimization for `ByteUtil.Hex()`.  [[#3297]]
 -  (Libplanet.RocksDBStore) Slight improvement for speed and memory usage.
    [[#3298]]
 -  Upgrade *Bencodex* from [0.10.0][Bencodex 0.10.0] to
    [0.11.0][Bencodex 0.11.0].  [[#3302]]

[#3297]: https://github.com/planetarium/libplanet/pull/3297
[#3298]: https://github.com/planetarium/libplanet/pull/3298
[#3302]: https://github.com/planetarium/libplanet/pull/3302
[Bencodex 0.11.0]: https://www.nuget.org/packages/Bencodex/0.11.0


Version 2.4.0
-------------

Released on July 3, 2023.

### Deprecated APIs

 -  (Libplanet.Net) Removed `ConsensusContext.BroadcastMessage` property.
    [[#3260]]

### Backward-incompatible API changes

 -  `Vote.BlockHash` property became `BlockHash` type. (was `BlockHash?`)
    [[#3249]]
 -  `VoteMetadata(long, int, BlockHash?, DateTimeOffset, PublicKey, VoteFlag)`
    constructor became
    `VoteMetadata(long, int, BlockHash, DateTimeOffset, PublicKey, VoteFlag)`
    [[#3249]]
 -  (Libplanet.Net) Renamed `Step` enum to `ConsensusStep`
    to remove ambiguity.  [[#3249]]
 -  (Libplanet.Net) `ConsensusProposalMsg`, `ConsensusPreVoteMsg` and
    `ConsensusPreCommitMsg` became to inherit `ConsensusVoteMsg`.  [[#3249]]
 -  (Libplanet.Net) Removed `ConsensusMsg.BlockHash` property.  [[#3249]]
 -  (Libplanet.Net) Some enumeration items to `MessageType` enum has modified.
    [[#3249]]
     -  `ConsensusProposal` changed to `0x50` (was `0x40`).
     -  `ConsensusVote` changed to `0x51` (was `0x41`).
     -  `ConsensusCommit` changed to `0x52` (was `0x42`).
 -  (Libplanet.Net) Added `Flag` property to `ConsensusVoteMsg` abstract class.
    [[#3260]]
 -  (Libplanet.Net) `ConsensusProposalMsg` no longer inherits
    `ConsensusVoteMsg`. Instead, inherits `ConsensusMsg`.  [[#3260]]
 -  (Libplanet.Net) Added parameter
    `IConsensusMessageCommunicator consensusMessageCommunicator` to
    `ConsensusContext`.  [[#3260]]
 -  (Libplanet.Net) Removed parameter
    `DelegateBroadcastMessage broadcastMessage` from `ConsensusContext`.
    [[#3260]]
 -  (Libplanet.Net) Added parameter
    `IConsensusMessageCommunicator consensusMessageCommunicator` to
    `Context`.  [[#3260]]
 -  (Libplanet.Net) Renamed `Context.BroadcastMessage(ConsensusMsg)`
    as `Context.PublishMessage(ConsensusMsg)`.  [[#3260]]
 -  (Libplanet.Net) Removed constructor of `MessageCache` class.  [[#3260]]
 -  (Libplanet.Explorer) Changed `TxResult.UpdatedStates`'s type to
    `IImmutableDictionary<Address, IValue>` from
    `IImmutableDictionary<Address, IValue?>`.  [[#3262]]

### Added APIs

 -  Added `Maj23` and its related classes.  [[#3249]]
     -  Added `Maj23` class.
     -  Added `Maj23Metadata` class.
 -  (Libplanet.Net) Added `VoteSet` class.  [[#3249]]
 -  (Libplanet.Net) Added `HeightVoteSet` class.  [[#3249]]
 -  (Libplanet.Net) Added `ConsensusVoteMsg` abstract class.  [[#3249]]
 -  (Libplanet.Net) Added `InvalidProposalException` class.  [[#3249]]
 -  (Libplanet.Net) Added `InvalidVoteException` class.  [[#3249]]
 -  (Libplanet.Net) Added `InvalidMaj23Exception` class.  [[#3249]]
 -  Added `IAccountDelta.OrderedSum()` extension method.  [[#3256]]
 -  Added `IAccountDelta.ToRawDelta()` extension method.  [[#3256]]
 -  Removed several properties from `IAccountStateDelta` pertaining to
    the delta part of `IAccountStateDelta`.  Access the equivalent data
    through `IAccountStateDelta.Delta` instead.  [[#3257]]
     -  Removed `IAccountStateDelta.UpdatedAddresses` property.
     -  Removed `IAccountStateDelta.StateUpdatedAddresses` property.
     -  Removed `IAccountStateDelta.UpdatedFungibleAssets` property.
     -  Removed `IAccountStateDelta.UpdatedTotalSupplyCurrencies` property.
 -  Changed `IBlockStates` to `IBlockState`.  [[#3259]]
 -  Changed `IBlockChainStates.GetBlockStates()` to
    `IBlockChainStates.GetBlockState()`.  [[#3259]]
 -  Changes `IActionContext.PreviousStates` to `IActionContext.PreviousState`.
 -  Changed `IActionEvaluation.OutputStates` to `IActionEvaluation.OutputState`.
    [[#3259]]
 -  (Libplanet.Net) Added `IConsensusMessageCommunicator` interface
    and its related classes.  [[#3260]]
     -  (Libplanet.Net) Added `GossipConsensusMessageCommunicator` class.
        [[#3260]]
 -  (Libplanet.Net) Added `Gossip.DenyPeer(BoundPeer)` method.  [[#3260]]
 -  (Libplanet.Net) Added `Gossip.AllowPeer(BoundPeer)` method.  [[#3260]]
 -  (Libplanet.Net) Added `Gossip.ClearCache()` method.  [[#3260]]
 -  (Libplanet.Net) Added `Gossip.ClearDenySet(BoundPeer)` method.  [[#3260]]

### Behavioral changes

 -  (Libplanet.Net) `Gossip` now maintains single message cache,
    and contents of this cache does not decayed by time or new messages.
    This cache is cleared only by `Gossip.ClearCache()` method.  [[#3260]]
 -  (Libplanet.Net) There are no mechanism for bootstrapping consensus
    any more. Instead, logic change on `Gossip` solves bootstrapping
    problem.  [[#3260]]
 -  (Libplanet.Net) `Context.Start()` now triggers
    `IConsensusMessageCommunicator.OnStartHeight()`.  [[#3260]]
 -  (Libplanet.Net) `Context.StartRound()` now triggers
    `IConsensusMessageCommunicator.OnStartRound()`.  [[#3260]]

[#3249]: https://github.com/planetarium/libplanet/pull/3249
[#3256]: https://github.com/planetarium/libplanet/pull/3256
[#3257]: https://github.com/planetarium/libplanet/pull/3257
[#3259]: https://github.com/planetarium/libplanet/pull/3259
[#3260]: https://github.com/planetarium/libplanet/pull/3260
[#3262]: https://github.com/planetarium/libplanet/pull/3262


Version 2.3.0
-------------

Released on June 28, 2023.

### Backward-incompatible API changes

 -  (@planetarium/tx) Removed some types and functions related to actions
    because the concept of `SystemAction` and `CustomAction` was removed
    since 1.1.0 and some system actions were removed since 1.2.0.  [[#3230]]
     -  Removed `encodeUnsignedTxWithCustomActions()` function.
     -  Removed `encodeUnsignedTxWithSystemAction()` function.
     -  Removed `UnsignedTxWithCustomActions` type.
     -  Removed `UnsignedTxWithSystemAction` type.
     -  Removed `encodeMint()` function.
     -  Removed `encodeTransfer()` function.
     -  Removed `encodeSystemAction()` function.
     -  Removed `CustomAction` type.
     -  Removed `SystemAction` type.
     -  Removed `Mint` type.
     -  Removed `Transfer` type.
     -  Added `encodeUnsignedTx()` function.
     -  Added `UnsignedTx` type.
     -  `signTx(UnsignedTxWithCustomActions | UnsignedTxWithSystemAction)`
        function's signature became `signTx(UnsignedTx)`.
     -  `SignedTx<T extends UnsignedTxWithCustomActions |
         UnsignedTxWithSystemAction>`'s signature became
         `SignedTx<T extends UnsignedTx>`.
 -  Changed the type for `IAccountStateDelta.UpdatedFungibleAssets`
    to `IImmutableSet<(Address, Currency)>`
    from `IImmutableDictionary<Address, IImmutableSet<Currency>>`.  [[#3244]]
 -  Changed the type for `IAccountStateDelta.TotalUpdatedFungibleAssets`
    to `IImmutableSet<(Address, Currency)>`
    from `IImmutableDictionary<Address, IImmutableSet<Currency>>`.  [[#3244]]
 -  Added `IAccountStateDelta.Delta` property.  [[#3245]]
 -  Removed `IValidatorSupportStateDelta` interface.  [[#3247]]
 -  Added `IAccountStateDeltaView.GetValidatorSet()` interface method.
    [[#3247]]
 -  Added `IAccountStateDelta.SetValidator()` interface method.  [[#3247]]
 -  Changed the name `IAccountStateDelta.TotalSupplyUpdatedCurrencies` to
    `IAccountStateDelta.UpdatedTotalSupplyCurrencies`.  [[#3248]]
 -  Changed `TxSuccess.UpdatedStates`'s type to
    `IImmutableDictionary<Address, IValue>` from
    `IImmutableDictionary<Address, IValue?>`.  [[#3248]]
 -  Added `IBlockChainStates.GetState()` interface method.  [[#3250]]
 -  Added `IBlockStates.GetState()` interface method.  [[#3250]]
 -  Changed `IBlockStates` to inherit `IAccountState` interface.  [[#3251]]

### Added APIs

 -  Added `IAccountDelta` interface and its default implementation
    `AccountDelta` class.  [[#3245]]

[#3230]: https://github.com/planetarium/libplanet/pull/3230
[#3244]: https://github.com/planetarium/libplanet/pull/3244
[#3245]: https://github.com/planetarium/libplanet/pull/3245
[#3247]: https://github.com/planetarium/libplanet/pull/3247
[#3248]: https://github.com/planetarium/libplanet/pull/3248
[#3250]: https://github.com/planetarium/libplanet/pull/3250
[#3251]: https://github.com/planetarium/libplanet/pull/3251


Version 2.2.0
-------------

Released on June 23, 2023.

### Backward-incompatible API changes

 -  Added `BlockProtocolVersion` property to `IActionContext`.  [[#3228]]
 -  Changed `IAccountStateDelta.TransferAsset()` to require additional
    `IActionContext` parameter.  [[#3229]]
 -  Changed `IAccountStateDelta.MintAsset()` and
    `IAccountStateDelta.BurnAsset()` to each require an additional
    `IActionContext` parameter.  [[#3231]]

### Bug fixes

 -  Fixed a bug where `IActionContext.BlockProtocolVersion` was not being set
    properly in [#3228].

[#3228]: https://github.com/planetarium/libplanet/pull/3228
[#3229]: https://github.com/planetarium/libplanet/pull/3229
[#3231]: https://github.com/planetarium/libplanet/pull/3231


Version 2.1.1
-------------

Released on June 22, 2023.

 -  Ported changes from [Libplanet 2.0.1] release.  [[#3234]]

[Libplanet 2.0.1]: https://www.nuget.org/packages/Libplanet/2.0.1
[#3234]: https://github.com/planetarium/libplanet/3234


Version 2.1.0
-------------

Released on June 20, 2023.

### Backward-incompatible API changes

 -  All `IBlockChainStates` methods now take nullable `BlockHash?`
    instead of `BlockHash` as `offset` parameter.  [[#3214]]
 -  Removed `IncompleteBlockStatesException` class.  [[#3214]]
 -  Changed `BlockChain`'s implementation of `IBlockChainStates` to match
    interface description.  [[#3214]]
 -  Added `IBlockChainStates.GetBlockStates()` interface method.  [[#3216]]

### Added APIs

 -  Added `IBlockStates` interface and its default implementation
    `BlockStates`.  [[#3216]]

### Behavioral changes

 -  Improved performance of fungible asset APIs on default
    `IAccountStateDelta` implementation.  [[#3218]]

### Bug fixes

 -  Fixed a bug where `BlockAction` could have unintended
    `AccountStateDeltaImpl.Signer` during its execution.  [[#3215]]

[#3214]: https://github.com/planetarium/libplanet/pull/3214
[#3215]: https://github.com/planetarium/libplanet/pull/3215
[#3216]: https://github.com/planetarium/libplanet/pull/3216
[#3218]: https://github.com/planetarium/libplanet/pull/3218

Version 2.0.1
-------------

Released on June 22, 2023.

 -  (@planetarium/tx) Fixed a bug where an `encodeCurrency` serialized
    `Currency` in an incompatible way with Libplanet.  [[#3225]]

[#3225]: https://github.com/planetarium/libplanet/pull/3225


Version 2.0.0
-------------

Released on June 14, 2023.

### Backward-incompatible API changes

 -  Added `IAccountStateDelta.TotalUpdatedFungibleAssets` interface property.
    [[#3208]]
 -  Removed `blockAction` parameter from `ActionContext()`.
    [[#3209]]
 -  Added `ITransaction.MaxGasPrice` property.  [[#3201]]
 -  Added `ITransaction.GasLimit` property.  [[#3201]]
 -  `Currency.Serialize()`'s behavioral is changed.
    the serialize field is replaced.  [[#3201]]

### Added APIs

 -  Added `FungibleAssetValue.Serialize()` method.  [[#3201]]

### Behavioral changes

 -  Improved performance of `StateStoreExtensions.Commit()` extension method
    and `MerkleTrie.Commit()` method.  [[#3165]]
 -  Improved performance of `HashDigest<T>.DeriveFrom()` static method on
    .NET Standard 2.1+.  [[#3165]]

[#3165]: https://github.com/planetarium/libplanet/pull/3165
[#3201]: https://github.com/planetarium/libplanet/pull/3201
[#3208]: https://github.com/planetarium/libplanet/pull/3208
[#3209]: https://github.com/planetarium/libplanet/pull/3209
