Libplanet changelog
===================

Version 1.4.0
-------------

Released on June 7, 2023.

### Backward-incompatible API changes

 -  Removed `IBlockChainStates.GetTrie()` interface method.  [[#3168]]
 -  Removed `PolymorphicAction<T>` class.  [[#3193]]
 -  Changed `BlockChain.Create()` to accept `IActionEvaluator` interface
    instead of `ActionEvaluator` object.  [[#3195]]
 -  Removed `blockAction` parameter from `BlockChain.EvaluateGenesis()`,
    `BlockChain.DetermineGenesisStateRootHash()`,
    and `BlockChain.ProposeGenesisBlock()` methods.  [[#3195]]

[#3168]: https://github.com/planetarium/libplanet/pull/3168
[#3193]: https://github.com/planetarium/libplanet/pull/3193
[#3195]: https://github.com/planetarium/libplanet/pull/3195


Version 1.3.0
-------------

Released on May 19, 2023.

### Backward-incompatible API changes

 -  Renamed `PreloadState` as `BlockSyncState`.  [[#3154]]
 -  Replaced `Swarm<T>.PreloadAsync`'s parameter
    `IProgress<PreloadState> progress`
    as `IProgress<BlockSyncState> progress`.  [[#3154]]
 -  Moved `IAccountStateDelta` and relations interface to
    `Libplanet.State` namespace (from `Libplanet.Action` namespace).
    [[#3173]]
 -  Changed `BlockChain<T>()` constructors to explicitly require an
    `IBlockChainStates` and an `IActionEvaluator`.  [[#3172]]
 -  Changed `BlockChain<T>.DetermineGenesisStateRootHash()`,
    `BlockChain<T>.EvaluateGenesis()`, and `BlockChain<T>.ProposeGenesisBlock()`
    to explicitly require `IActionEvaluator`.  [[#3172]]
 -  Removed type parameter `T` from `BlockChain<T>` class.  [[#3182]]
 -  Removed type parameter `T` from `IBlockPolicy<T>` interface.  [[#3182]]
 -  Removed type parameter `T` from `IStagePolicy<T>` interface.  [[#3182]]
 -  Removed type parameter `T` from `Context<T>` class.  [[#3183]]
 -  Removed type parameter `T` from `ConsensusContext<T>` class.  [[#3183]]
 -  Removed type parameter `T` from `ConsensusReactor<T>` class.  [[#3183]]
 -  Removed type parameter `T` from `BlockCandidateTable<T>` class.  [[#3184]]
 -  Removed type parameter `T` from `TxCompletion<T>` class.  [[#3184]]
 -  Removed type parameter `T` from `Swarm<T>` class.  [[#3184]]
 -  (Libplanet.Explorer) Removed type parameter `T` requiring `T` as
    `IAction` from all classes.  [[#3185]]

### Behavioral changes

 -  `Gossip` became to store the `MessageId`s received through the
    `HaveMessage` instead of immediately replying to them, and send the
    `WantMessage` requests all at once during each `HeartbeatTask`.
    [#3152]
 -  `Swarm<T>.PreloadAsync()` use `PullBlocksAsync()` and
    `ConsumeBlockCandidates()`.  [[#3154]]
 -  `Swarm<T>.PreloadAsync()` uses `BlockCandidateTable<T>` to cache
    downloaded `Block`s, instead of storing them on forked `BlockChain<T>`.
    [[#3154]]
 -  `Swarm<T>.PullBlocksAsync()` and `Swarm<T>.GetDemandBlockHashes()` iterates
    using new parameter `chunkSize`.  [[#3154]]
 -  `Swarm<T>.ConsumeBlockCandidates()` repeats iff new parameter
    `checkInterval` is not null.  [[#3154]]
 -  `Swarm<T>.ConsumeBlockCandidates()` does not renders if new parameter
    `render` is `false`.  [[#3154]]
 -  `Swarm<T>.PullBlocksAsync()` and `Swarm<T>.GetDemandBlockHashes()`
    receives new parameter `IProgress<BlockSyncState> progress` and will
    report progress to it, if it's given.  [[#3154]]
 -  Moved creation of `BlockDemandTable` and `BlockCandidateTable`
    to constructor of `Swarm<T>` from `Swarm<T>.StartAsync()`.  [[#3154]]

[#3152]: https://github.com/planetarium/libplanet/pull/3152
[#3154]: https://github.com/planetarium/libplanet/pull/3154
[#3172]: https://github.com/planetarium/libplanet/pull/3172
[#3173]: https://github.com/planetarium/libplanet/pull/3173
[#3182]: https://github.com/planetarium/libplanet/pull/3182
[#3183]: https://github.com/planetarium/libplanet/pull/3183
[#3184]: https://github.com/planetarium/libplanet/pull/3184
[#3185]: https://github.com/planetarium/libplanet/pull/3185


Version 1.2.1
-------------

Released on May 17, 2023.

 -  (Libplanet.Explorer) Fixed a bug where a `TransactionQuery` could not
    properly retrieve actions.  [[#3174]]

[#3174]: https://github.com/planetarium/libplanet/pull/3174


Version 1.2.0
-------------

Released on May 16, 2023.

### Deprecated APIs

 -  Removed `StaticActionLoader` class.  Use `SingleActionLoader` instead.
    [[#3148]]
 -  Removed `Mint` and `Transfer` class.  [[#3159]]

### Backward-incompatible API changes

 -  Removed type parameter `T` from `Transaction.Create<T>()` and
    `PreEvaluationBlock.Evaluate<T>()`.  [[#3122]]
 -  Signatures of `IActionRenderer<T>`'s methods was changed.  [[#3117]]
     -  The signature of
        `RenderAction(IAction, IActionContext, IAccountStateDelta)`
        method was changed to
        `RenderAction(IValue, IActionContext, IAccountStateDelta)`.
     -  The signature of
       `RenderActionError(IAction, IActionContext, Exception)`
        method was changed to
        `RenderActionError(IValue, IActionContext, Exception)`.
 -  Added `SingleActionLoader`, `TypedActionLoader`, and `IndexedActionLoader`
    classes.  [[#3148]]
 -  Removed `trieGetter` parameter from `ActionEvaluator` constructor.
    [[#3149]]
 -  Added `IBlockChainStates.GetTrie()` interface method.  [[#3149]]
 -  `BlockChain<T>.Create()` static method now requires `actionEvaluator`
    parameter explicitly.  [[#3149]]
 -  Removed `IBlockPolicy.NativeTokens` property.  [[#3153]]
     - Removed `NonNativeTokenException` class.
     - Removed `IActionContext.IsNativeToken()` method.
     - Removed `nativeTokenPredicate` parameter from `ActionEvaluator()`
     - Removed `nativeTokenPredicate` parameter from all `BlockChain<T>`'s
       methods.
     - (Libplanet.Explorer) Removed `BlockPolicyType<T>` class.
 -  Removed generic type parameter `T` from `IRenderer<T>` and all its
    implementations.  [[#3163]]
 -  Removed `IActionContext.GenesisHash` property.  [[#3164]]
 -  Removed `genesisHash` parameter from `ActionEvaluator()`.  [[#3164]]

### Added APIs

 -  Added `IActionContext.GasUsed()` method.
    [[#3144]]
 -  Added `IActionContext.GasLimit()` method.
    [[#3144]]
 -  Added `PolymorphicAction<T>.ReloadLoader()` static method.  [[#3158]]

### Behavioral changes

 -  `Transaction.Create()` method no more fills `Transaction.UpdatedAddresses`
    automatically.  [[#368], [#3122]]
 -  `Mint` and `Transfer` `IAction`s no longer check for native tokens.
    [[#3153]]

[#3117]: https://github.com/planetarium/libplanet/pull/3117
[#3122]: https://github.com/planetarium/libplanet/pull/3122
[#3144]: https://github.com/planetarium/libplanet/pull/3144
[#3148]: https://github.com/planetarium/libplanet/pull/3148
[#3149]: https://github.com/planetarium/libplanet/pull/3149
[#3153]: https://github.com/planetarium/libplanet/pull/3153
[#3158]: https://github.com/planetarium/libplanet/pull/3158
[#3159]: https://github.com/planetarium/libplanet/pull/3159
[#3163]: https://github.com/planetarium/libplanet/pull/3163
[#3164]: https://github.com/planetarium/libplanet/pull/3164


Version 1.1.1
-------------

Released on May 15, 2023.

 -  (@planetarium/cli) Fixed the installer bug that it had failed on Linux and
    macOS since version 1.0.2.  [[#3107], [#3160], [#3161]]

[#3161]: https://github.com/planetarium/libplanet/pull/3161


Version 1.1.0
-------------

Released on May 9, 2023.

### Backward-incompatible API changes

 -  Changed the encoding scheme and related methods for `TxActionList`.
    [[#3083]]
     -  Removed `TxActionList.FromBencodex<T>()` method.
     -  Changed the return type for `TxActionList.ToBencodex()` from
        `Dictionary` to `IValue`.
 -  Removed `IRenderer<T>.RenderReorg()`, `IRenderer<T>.RenderReorgEnd()`,
    `IActionRenderer<T>.UnrenderAction()`, and
    `IActionRenderer<T>.UnrenderActionError()`.  [[#3092]]
 -  Removed `NonblockRenderer`, `NonblockActionRenderer`, `DelayedRenderer`,
    and `DelayedActionRenderer` classes.  [[#3098]]
 -  (Libplanet.Net) Removed optional `render` parameter from
    all `Swarm<T>.PreloadAsync()` overload methods.  No rendering is done
    during the preloading phase.  [[#3108]]
 -  `TxActionList` now implements `IBencodable` interface.  [[#3110]]
     -  Removed `FromBencodex()` static method; use `TxActionList(IValue)`
        constructor instead.
     -  Removed `ToBencodex()` method; use `TxActionList.Bencoded` instead.
 -  `TxActionList` now implements `IEnumerable<IValue>` instead of
    `IEnumerable<IAction>`.  [[#3110]]
     -  Changed `TxSystemAction.SystemAction` to return an `IValue`.
     -  Changed `TxCustomActions.CustomActions` to return an
        `IImmutableList<IValue>`.
 -  `TxActionList`'s JSON representation has changed.  It no longer has
    `"type"` field.  [[#3110]]
 -  Changed the type for `ActionTypeAttribute.TypeIdentifier`
    from `string` to `IValue`.  [[#3111]]
 -  Changed the return type for `ActionTypeAttribute.ValueOf()` from
    `string?` to `IValue?`.  [[#3111]]
 -  Changed the return type for `IActionTypeLoader.Load()` from
    `IDictionary<string, Type>` to `IDictionary<IValue, Type>`.  [[#3111]]
 -  Changed return types and parameter types of several methods from
    `IReadOnlyList<ActionEvaluation>` to `IReadOnlyList<IActionEvaluation>`.
    [[#3089]]
     -  `BlockChain<T>.DetermineGenesisStateRootHash()`
        method's `evaluations` parameter type.
     -  `BlockChain<T>.DetermineBlockStateRootHash()`
        method's `evaluations` parameter type.
     -  `BlockChain<T>.EvaluateBlock()` method's return type.
     -  `BlockChain<T>.EvaluateGenesis()` method's return type.
 -  Removed `BlockChain<T>.MakeTransaction(PrivateKey, IAction,
    IImmutableSet<Address>, DateTimeOffset?)`.  [[#3116]]
 -  Removed `Transaction<T>.Create(long, PrivateKey, BlockHash?, IAction,
    IImmutableSet<Address>?, DateTimeOffset?)`.  [[#3116]]
 -  Added `Transaction<T>.Create(long, PrivateKey, BlockHash?,
    IEnumerable<IValue>, IImmutableSet<Address>?, DateTimeOffset?)`.  [[#3116]]
 -  Removed `ITransaction.SystemAction` and `ITransaction.CustomActions`.
    Use `ITxInvoice.Actions` instead.  [[#3116]]
 -  Overhauled `TxActionList` class.  [[#3116]]
     -  Changed `TxActionList` class to be `sealed` from `abstract`.
        `TxActionList` is pretty much the old `TxCustomActionsList`.
     -  Changed the JSON representation of `TxActionList` to be more simple.
     -  Removed `TxSystemActionList` and `TxCustomActionsList`
 -  Changed `Transaction<T>` to `Transaction` to be non-generic.  [[#3121]]
 -  Changed `Block<T>` to `Block` to be non-generic.  [[#3123]]
     -  Removed `IBlockContent<T>` interface.  Use `IBlockContent` instead.
        Also changed `IBlockContent.IImmutableSet<ITransaction>` to
        `IBlockContent.ReadOnlyList<ITransaction>`.
     -  Changed `BlockContent<T>` to `BlockContent`.
     -  Removed `IPreEvaluationBlock<T>` interface.  Use `IPreEvaluationBlock`
        instead.
     -  Changed `PreEvaluationBlock<T>` to `PreEvaluationBlock`.
         -  `PreEvaluationBlock.Evaluate<T>()` now requires type parameter `T`.
 -  Removed `PreEvaluationBlock.Evaluate<T>()` method.  [[#3127]]
 -  Renamed `IActionTypeLoader` to `IActionLoader`.  [[#3135]]
     -  Added `IActionLoader.Load(long, IValue)` interface method.
     -  Removed `ActionTypeLoaderContext` class.  Use `long` instead.
     -  Renamed `StaticActionTypeLoader` to `StaticActionLoader`.
 -  Added `IActionEvaluator.IActionLoader` property.  [[#3136]]
 -  Changed `IActionLoader.LoadAction()` to throw `InvalidActionException`
    instead of `ArgumentException` when an action cannot be instantiated.
    [[#3140]]

### Added APIs

 -  Added `IActionEvaluator` interface.  [[#3082]]
 -  Added `SwarmOptions.TaskRegulationOptions` property.  [[#3109]]
 -  Added `TaskRegulationOptions` class.  [[#3109]]
 -  Added `ActionTypeAttribute(int)` constructor.  [[#3111]]
 -  Added `IActionEvaluation` interface.  [[#3089]]
 -  Added parameterless constructor to `Mint`, `Transfer`, and `Initialize`.
    [[#3112]]
 -  Added `InvalidActionException` class.  [[#3140]]

### Behavioral changes

 -  Changed `BlockChain<T>` to ignore `IRenderer<T>.RenderReorg()`,
    `IRenderer<T>.RenderReorgEnd()`, `IActionRenderer<T>.UnrenderAction()`,
    and `IActionRenderer<T>.UnrenderActionError()`, i.e., these interface
    methods are no longer invoked by a `BlockChain<T>`.  [[#3087]]
 -  Changed `Context<T>.ConsumeMutation()` to iteratively call
    `Context<T>.ProcessGenericUponRules()` itself, instead of producing
    submutations of it.  [[#3137]]
 -  (Libplanet.Explorer) The `CurrencyInputType`'s `totalSupplyTrackable` field
    became nullable with `false` as its default value.  [[#3151]]

### Bug fixes

 -  Fixes a bug where `BlockChain<T>` could not propose if a certain type of
    invalid `Transaction` was staged.  [[#3136]]
 -  Fixes a bug where `Context<T>` would completely halt if a `Block`
    with an `IValue` as one of its action that cannot be instantiated via
    its `IActionLoader`.  [[#3140]]

### Dependencies

 -  Upgrade *Bencodex* from [0.8.0][Bencodex 0.8.0] to
    [0.10.0][Bencodex 0.10.0].  [[#3106]]
 -  Upgrade *Bencodex.Json* from [0.8.0][Bencodex.Json 0.8.0] to
    [0.10.0][Bencodex.Json 0.10.0].  [[#3106]]

[#3082]: https://github.com/planetarium/libplanet/pull/3082
[#3083]: https://github.com/planetarium/libplanet/pull/3083
[#3087]: https://github.com/planetarium/libplanet/pull/3087
[#3089]: https://github.com/planetarium/libplanet/pull/3089
[#3092]: https://github.com/planetarium/libplanet/pull/3092
[#3098]: https://github.com/planetarium/libplanet/pull/3098
[#3106]: https://github.com/planetarium/libplanet/pull/3106
[#3108]: https://github.com/planetarium/libplanet/pull/3108
[#3110]: https://github.com/planetarium/libplanet/pull/3110
[#3111]: https://github.com/planetarium/libplanet/pull/3111
[#3112]: https://github.com/planetarium/libplanet/pull/3112
[#3116]: https://github.com/planetarium/libplanet/pull/3116
[#3121]: https://github.com/planetarium/libplanet/pull/3121
[#3123]: https://github.com/planetarium/libplanet/pull/3123
[#3127]: https://github.com/planetarium/libplanet/pull/3127
[#3135]: https://github.com/planetarium/libplanet/pull/3135
[#3136]: https://github.com/planetarium/libplanet/pull/3136
[#3137]: https://github.com/planetarium/libplanet/pull/3137
[#3140]: https://github.com/planetarium/libplanet/pull/3140
[#3151]: https://github.com/planetarium/libplanet/pull/3151
[Bencodex 0.10.0]: https://www.nuget.org/packages/Bencodex/0.10.0
[Bencodex.Json 0.10.0]: https://www.nuget.org/packages/Bencodex.Json/0.10.0


Version 1.0.3
-------------

Released on May 15, 2023.

 -  (@planetarium/cli) Fixed the installer bug that it had failed on Linux and
    macOS since version 1.0.2.  [[#3107], [#3160]]

[#3160]: https://github.com/planetarium/libplanet/pull/3160


Version 1.0.2
-------------

Released on May 4, 2023.

 -  (Libplanet.Tools) The `planet` command now falls back to the default
    cryptography backend instead of crash when it fails to load *libsecp256k1*
    at runtime.  [[#3138]]
 -  (@planetarium/cli) Fixed the installer bug that it had failed with some
    recent Node.js versions on Windows.   [[#3107], [#3138]]

[#3107]: https://github.com/planetarium/libplanet/issues/3107
[#3138]: https://github.com/planetarium/libplanet/pull/3138


Version 1.0.1
-------------

Released on May 3, 2023.

 -  Fixed a bug where `BlockChain<T>.Append()` hadn't update tx executions
    even `evaluateActions` set to `true` when `actionEvaluations` are given.
    [[#3125]]
 -  (Libplanet.Explorer) Fixed a bug where `BlockQuery.blocks` field had thrown
    `KeyNotFoundException` when appending block simultaneously.
    [[#3126], [#3130]]

[#3125]: https://github.com/planetarium/libplanet/pull/3125
[#3126]: https://github.com/planetarium/libplanet/issues/3126
[#3130]: https://github.com/planetarium/libplanet/pull/3130


Version 1.0.0
-------------

Released on April 18, 2023.

### Deprecated APIs

 -  (@planerarium/account)  Deprecated `RawPrivateKey.publicKey` property in
    favour of `RawPrivateKey.getPublicKey()` async method.  [[#3061]]
 -  (@planetarium/account-aws-kms)  Deprecated `AwsKmsAccount.publicKey` in
    favour of `AwsKmsAccount.getPublicKey()` async method.  [[#3061]]

### Backward-incompatible API changes

 -  Removed `TxMetadata` class.  [[#1164], [#2986]]
     -  Removed `Transaction<T>(TxMetadata, IAction, byte[])` constructor.
     -  Removed `Transaction<T>(TxMetadata, IEnumerable<T>, byte[])`
        constructor.
 -  Reorganized `ITransaction` interface in general.  [[#1164], [#2986]]
     -  `ITransaction` now inherits `IUnsignedTx` interface instead of having
        properties such as `GenesisHash`, `UpdatedAddresses`, `Timestamp`,
        `Nonce`, `Signer`, and `PublicKey`.
     -  `SystemAction` property is replaced by `Actions` property which is
        inherited from `IUnsignedTx` interface.
     -  `CustomActions` property is replaced by `Actions` property which is
        inherited from `IUnsignedTx` interface.
 -  `Transaction<T>` no more accept empty `Signature` as a valid state.
    Instead, you should use `UnsignedTx` class to represent an unsigned
    transaction.  [[#1164], [#2986]]
     -  Removed `Transaction<T>(long, Address, PublicKey, BlockHash?,
        IImmutableSet<Address>, DateTimeOffset, IEnumerable<T>, byte[])`
        constructor.
     -  Removed `Transaction<T>.CreateUnsigned()` static method.
     -  Removed `Transaction<T>.Validate()` method.
     -  Removed `sign` parameter from `Transaction<T>.Serialize()` method.
     -  Removed `validate` parameter from `Transaction<T>.Deserialize()`
        method.
 -  `Transaction<T>` now has `Actions` in a uniform way regardless they
    are custom actions or system actions, through `TxActionList` abstract
    class.  [[#1164], [#2986]]
     -  Changed the type of `Transaction<T>.Actions` property from
        `IImmutableList<IAction>` to `TxActionList`, which is also an
        `IReadOnlyList<IAction>`.  The property once was deprecated
        in favour of `Transaction<T>.CustomActions` and
        `Transaction<T>.SystemAction`, but now it replaces them both.
     -  Removed `Transaction<T>.CustomActions` property.
     -  Removed `Transaction<T>.SystemAction` property.
 -  `Transaction<T>(Bencodex.Types.Dictionary)` constructor is removed.
    Use `TxMarshaler.UnmarshalTransaction<T>()` method instead.  [[#2986]]
 -  Removed `PreEvaluationBlock<T>.Evaluate(PrivateKey, IAction?,
    Predicate<Currency>, IStateStore)`,
    `PreEvaluationBlock<T>.DetermineStateRootHash(IAction?, Predicate<Currency>,
    IStateStore)`, `PreEvaluationBlock<T>.DetermineStateRootHash(IAction?,
    Predicate<Currency>, IStateStore,
    out IImmutableDictionary<string, IValue>)`,
    `PreEvaluationBlock<T>.DetermineStateRootHash(BlockChain<T>)`,
    and `PreEvaluationBlock<T>.DetermineStateRootHash(BlockChain<T>,
    out IImmutableDictionary<string, IValue>)`,
    `BlockChain<T>.ExecuteActions(Block<T>)`.  [[#3037]]
 -  (Libplanet.Extensions.Cocona) Changed signature of
    `ApvCommand.Verify(string?, string[]?, bool)` method to
    `ApvCommand.Verify(string?, PublicKey[]?, bool)`.  [[#3044]]
 -  Removed `PreEvaluationBlock<T>.Mine()` and `BlockMetadata.MineNonce()`
    methods.  [[#3067]]
 -  Removed `HashCash` class.  [[#3067]]
 -  (@planetarium/account) Replaced `Account.publicKey` property with
    `Account.getPublicKey()` async method.  [[#3061]]
 -  (@planetarium/account) Added `Account.getAddress()` async method.  [[#3084]]
 -  (@planetarium/account) `Address.deriveFrom()` method now returns
    `Promise<Address>` when an `Account` is given.  However, it still returns
    `Address` when a `PublicKey` is given.  [[#3061]]
 -  (@planetarium/account-web3-secret-storage) `Web3KeyStore` no more implements
    `ImportableKeyStore<KeyId, RawPrivateKey>`.  Instead, it now implements
    `ImportableKeyStore<KeyId, Web3Account, Web3KeyMetadata>`.
    [[#3061], [#3084]]
 -  (Libplanet.Explorer) Added `Index` field to `IBlockChainContext` interface.
    [[#2613]]
 -  Removed `BlockChain<T>.ProposeBlock(PrivateKey, DateTimeOffset, long, int,
    int, IComparer<Transaction<T>>, BlockCommit)` method.  [[#3072]]
 -  Changed `BlockChain<T>.ProposeBlock(PrivateKey, DateTimeOffset,
    BlockCommit, IComparer<Transaction<T>>)` method to
    `BlockChain<T>.ProposeBlock(PrivateKey, BlockCommit,
    IComparer<Transaction<T>>)`.  [[#3077]]
 -  Changed `BlockChain<T>.ProposeGenesisBlock(IEnumerable<T>,
    IEnumerable<IAction>, PrivateKey, DateTimeOffset?, IAction,
    Predicate<Currency>)` to `BlockChain<T>.ProposeGenesisBlock(
    PrivateKey, ImmutableList<Transaction<T>>, DateTimeOffset?, IAction,
    Predicate<Currency>)`.  [[#3079]]
 -  (Libplanet.Explorer) `Currency.decimalPlaces`' type became `Byte`
    from `UInt`.  [[#3085]]
 -  (Libplanet.Explorer) `currencyHash` parameter was removed from
    `balance` and `totalSupply` in `StateQuery` type.  [[#3085]]

### Added APIs

 -  Added `ITxInvoice` interface.  [[#1164], [#2986]]
 -  Added `ITxSigningMetadata` interface.  [[#1164], [#2986]]
 -  Added `IUnsignedTx` interface.  [[#1164], [#2986]]
 -  Added `TxInvoice` class.  [[#1164], [#2986]]
 -  Added `TxSigningMetadata` class.  [[#1164], [#2986]]
 -  Added `UnsignedTx` class.  [[#1164], [#2986]]
 -  Added `Transaction<T>(IUnsignedTx, ImmutableArray<byte>)`.
    [[#1164], [#2986]]
 -  Added `BlockChain<T>.DetermineGenesisStateRootHash()`,
    `BlockChain<T>.EvaluateGenesis()`,
    `BlockChain<T>.DetermineBlockStateRootHash()`,
    and `BlockChain<T>.EvaluateBlock()`.  [[#3037]]
 -  Added `PublicKey.FromHex()` static method.  [[#2709], [#3044]]
 -  Added `PublicKey.ToHex()` method.  [[#2709], [#3044]]
 -  (Libplanet.Net) Added `Gossip.PublishMessage()` method.  [[#3054], [#3060]]
 -  (@planetarium/account) Added `Account.getPublicKey()` async method.
    [[#3061]]
 -  (@planetarium/account) Added `Account.getAddress()` async method.  [[#3084]]
 -  (@planetarium/account) Added `RawPrivateKey.getPublicKey()` async method.
    [[#3061]]
 -  (@planetarium/account) Added `RawPrivateKey.getAddress()` async method.
    [[#3084]]
 -  (@planetarium/account-aws-kms) Added `AwsKmsAccount.getPublicKey()` async
    method.  [[#3061]]
 -  (@planetarium/account-aws-kms) Added `AwsKmsAccount.getAddress()` async
    method.  [[#3084]]
 -  (@planetarium/account-web3-secret-storage) Added `Web3Account` class.
    [[#3061], [#3084]]
 -  (@planetarium/account-web3-secret-storage) Added `Web3KeyObject` interface.
    [[#3061]]
 -  (Libplanet.Explorer) Added several interfaces and classes that pertain to
    blockchain indexing.  [[#2613]]
     -  Added `IBlockChainIndex` interface.
     -  Added `IIndexingContext` interface.
     -  Added `BlockChainIndexBase` abstract class.
     -  Added `RocksDbBlockChainIndex` class.
     -  Added `RocksDbIndexingContext` class.
     -  Added `IndexingService` class.
     -  Added `IndexMismatchException` class.
 -  (Libplanet.Explorer.Cocona) New project was added to provide Cocona
    commands related to *Libplanet.Explorer* project.  [[#2613]]
     -  Added `IndexCommand` Cocona command class.
 -  (Libplanet.Explorer) Added `states` query in `StateQuery`.  [[#3080]]
 -  (@planetarium/account) Added `Address.equals()` method.  [[#3071]]
 -  (@planetarium/account) Added `Address.isAddressOf()` method.  [[#3071]]
 -  (@planetarium/account) Added `PublicKey.equals()` method.  [[#3071]]
 -  (@planetarium/account-web3-secret-storage) Added `DecryptionOptions`
    interface.  [[#3071]]
     -  Added `Web3KeyStoreOptions.decryptionOptions` attribute.
 -  (@planetarium/account-web3-secret-storage) Added `WeakPrivateKeyError`
    class.  [[#3071]]
 -  (@planetarium/account-web3-secret-storage) Added `Web3KeyMetadata`
    interface.  [[#3084]]
 -  (Libplanet.Tools) Added `-v`/`--validator-key` option to
    `planet block generate-genesis` command.  [[#3088]]
 -  (Libplanet.Explorer) Added `CurrencyInput` type.  [[#3085]]
 -  (Libplanet.Explorer) Added `CurrencyInput`-typed `currency` parameter to
    `balance` and `totalSupply` in `StateQuery` type.  [[#3085]]

### Behavioral changes

 -  Added `TypeConverter` to commonly-used types.  [[#2711], [#3044]]

     -  `Address` now can be converted from and to `string` through
        `TypeConverter`.
     -  `HashDigest<T>` now can be converted from and to `string` through
        `TypeConverter`.
     -  `PublicKey` now can be converted from and to `string` through
        `TypeConverter`.

 -  `Transaction<T>` no more supports deserialization from JSON when it contains
    custom actions.  However, it still can be deserialized from JSON when it
    contains a system action.  [[#2986]]

 -  `Transaction<T>.UpdatedAddresses` now preserves the order of `Address`es
    so that it is no more reordered during deserialization.  [[#3074]]

 -  The JSON representation of `Transaction<T>` now includes the `"actions"`
    field, which includes a system action or a list of custom actions and
    a `"type"` field denoting one of `"system"` or `"custom"`.

    For example:

    ~~~~
    {
       // ... other fields
       "actions": {
         "type": "system",
         "systemAction": {
           // system action details
         }
       }
    }
    ~~~~

    Instead of:

    ~~~~
    {
       // ... other fields
      "systemAction": {
         // system action details
      }
    }
    ~~~~

 -  (@planetarium/account-web3-secret-storage) `Web3KeyStore.get()` method now
    defers `PassphraseEntry.authenticate()` call and account unlocking so that
    `AccountRetrieval` instance can be gathered without unlocking the account.
    Instead, `PassphraseEntry.authenticate()` is called when operations that
    require unlocking `Web3Account` are called, such as `sign()` or
    `getPublicKey()`.  [[#3061]]
 -  (Libplanet.Explorer) Now, when an `IBlockChainIndex` instance is available
    in the optional `Index` property of the injected `IBlockChainContext`
    instance, GraphQL queries can benefit from the improved lookup performance
    of the index.  Applications willing to take advantage of the index should
    provide an instance of `IBlockChainIndex` to the `IBlockChainContext`
    implementation and add the `IndexingService` hosted service to sync the
    index in the background.  Note that the synchronization may take a long
    time if you have a lot of blocks (over 24 hours for ~5M blocks).  [[#2613]]
     -  `BlockRef` property of `TransactionType` now uses `IBlockChainIndex`
        if available.
     -  `transactionResult` query in `TransactionQuery` now uses
        `IBlockChainIndex` if available.

 -  (@planetarium/account-web3-secret-storage) `Web3KeyStore` now supports
    Scrypt as one of KDF functions besides PBKDF2.  [[#3071]]

### Bug fixes

 -  In `PreVote` block validation, `Context<T>.IsValid()`, validate the block
    header and also the block content (e.g., Tx nonces, Policy defined
    validation rules, or state root hash.)  [[#2973], [#2996]]
 -  (@planetarium/account-web3-secret-storage) Fixed a bug where
    `Web3KeyStore.import()` and `Web3KeyStore.generate()` methods had written
    JSON field `"Crypto"` instead of `"crypto"` in the key file.  [[#3071]]

### Dependencies

 -  *@planetarium/account-aws-kms* now has *@planetarium/account* as a peer
    dependency instead of a normal dependency.  [[#3069]]
 -  *@planetarium/account-web3-secret-storage* now has *@planetarium/account*
    as a peer dependency instead of a normal dependency.  [[#3069]]
 -  *@planetarium/tx* now has *@planetarium/account* as a peer dependency
    instead of a normal dependency.  [[#3069]]

### CLI tools

 -  (Libplanet.Explorer.Executable) Project is now deprecated. It is currently
    nonfunctional.  [[#2243], [#2588]]
 -  (Libplanet.Tools) Now `planet` uses *libsecp256k1* (which is the same
    library used in Bitcoin and written in C) instead of
    *BouncyCastle.Cryptography* (which is written in C#).  [[#3074]]

[#2243]: https://github.com/planetarium/libplanet/discussions/2243
[#2588]: https://github.com/planetarium/libplanet/discussions/2588
[#2613]: https://github.com/planetarium/libplanet/pull/2613
[#2709]: https://github.com/planetarium/libplanet/issues/2709
[#2711]: https://github.com/planetarium/libplanet/issues/2711
[#2986]: https://github.com/planetarium/libplanet/pull/2986
[#2973]: https://github.com/planetarium/libplanet/issues/2973
[#2996]: https://github.com/planetarium/libplanet/pull/2995
[#3037]: https://github.com/planetarium/libplanet/pull/3037
[#3044]: https://github.com/planetarium/libplanet/pull/3044
[#3054]: https://github.com/planetarium/libplanet/issues/3054
[#3060]: https://github.com/planetarium/libplanet/pull/3060
[#3061]: https://github.com/planetarium/libplanet/pull/3061
[#3067]: https://github.com/planetarium/libplanet/pull/3067
[#3069]: https://github.com/planetarium/libplanet/pull/3069
[#3071]: https://github.com/planetarium/libplanet/pull/3071
[#3072]: https://github.com/planetarium/libplanet/pull/3072
[#3074]: https://github.com/planetarium/libplanet/pull/3074
[#3077]: https://github.com/planetarium/libplanet/pull/3077
[#3079]: https://github.com/planetarium/libplanet/pull/3079
[#3080]: https://github.com/planetarium/libplanet/pull/3080
[#3084]: https://github.com/planetarium/libplanet/pull/3084
[#3085]: https://github.com/planetarium/libplanet/pull/3085
[#3088]: https://github.com/planetarium/libplanet/pull/3088
