import { parseSubjectPublicKeyInfo } from "../src/asn1";
import { expect, test } from "vitest";

test("parseSubjectPublicKeyInfo()", () => {
  const input = new Uint8Array([
    0x30, 0x56, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x0a, 0x03, 0x42, 0x00, 0x04,
    0x25, 0xfd, 0xe7, 0x9e, 0x8c, 0x8b, 0x6a, 0x91, 0xf3, 0xd2, 0x3d, 0x99,
    0xe8, 0xe6, 0x8e, 0xed, 0xc4, 0x32, 0x33, 0x0b, 0x5a, 0x99, 0x54, 0x14,
    0x30, 0xd0, 0x62, 0xaf, 0x26, 0xe5, 0xb4, 0x51, 0x57, 0xfe, 0x64, 0x2b,
    0xb5, 0x3d, 0xcd, 0x0d, 0x17, 0x92, 0x50, 0x48, 0x86, 0xc5, 0xfa, 0x2c,
    0x29, 0xcd, 0xa3, 0x6b, 0xbd, 0x8c, 0x88, 0xea, 0xd4, 0x34, 0x5a, 0x54,
    0x27, 0x44, 0x8d, 0xd2,
  ]);
  const expected = new Uint8Array([
    0x04, 0x25, 0xfd, 0xe7, 0x9e, 0x8c, 0x8b, 0x6a, 0x91, 0xf3, 0xd2, 0x3d,
    0x99, 0xe8, 0xe6, 0x8e, 0xed, 0xc4, 0x32, 0x33, 0x0b, 0x5a, 0x99, 0x54,
    0x14, 0x30, 0xd0, 0x62, 0xaf, 0x26, 0xe5, 0xb4, 0x51, 0x57, 0xfe, 0x64,
    0x2b, 0xb5, 0x3d, 0xcd, 0x0d, 0x17, 0x92, 0x50, 0x48, 0x86, 0xc5, 0xfa,
    0x2c, 0x29, 0xcd, 0xa3, 0x6b, 0xbd, 0x8c, 0x88, 0xea, 0xd4, 0x34, 0x5a,
    0x54, 0x27, 0x44, 0x8d, 0xd2,
  ]);
  expect(parseSubjectPublicKeyInfo(input)).toStrictEqual(expected);

  const invalid = new Uint8Array([
    0x30, 0x56, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
    0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x0a, 0x03, 0x42,
  ]);
  expect(() => parseSubjectPublicKeyInfo(invalid)).toThrowError(RangeError);
});
