# xtrix design
## syscalls
 - triggered with int (10h + syscall number)
 - sysv: rdi is sysno; rsi, rdx, rcx is args; rax is return
 - minimal syscall set:
     - (00) sys_dbglog(len, str*)
     - (01) sys_mmap(addr, len)
     - (02) sys_phymap(phy, virt, len)
       - phymaps are discarded on fork
     - (13) sys_phyread(phy, virt, len)
       - special value `0x6b7a0db87ad4d3c1` specifies to read the stivale2 structure.
     - IPC stuff
        - (03) sys_open_pipe(side: 0=client 1=server, chan) -> xid
        - (04) sys_close(xid)
        - (05) sys_send_region(xid, addr, len)
        - (06) sys_recv_region(xid, addr, len) -> 0=success 1=fail
        - (07) sys_send_data(xid, dataptr, len)
        - (08) sys_send_vectored(xid, dataptr*, len*, rcount)
        - (09) sys_recv_data(xid, dataptr, len)
        - (0c) sys_clean_exit()
     - FastIPC
        - (0d) sys_sendmsg(pid, rid, len, data)
        - (0e) sys_recvmsg(*msg, *arena, maxlen)
             - struct message:
                - ulong spid
                - ulong rid
                - ulong len
     - Process stuff
        - (17) sys_getpid() -> pid
        - (0f) sys_getuid() -> uid
        - (10) sys_fork() -> 0=child cpid=parent
        - (11) sys_exec(elfptr, elfsz, argc, argv)
        - (12) sys_setuid(sub-uid)
        - (14) sys_exit(code)
        - (15) sys_wait(pid) -> pid, resulting code
        - (16) sys_waitfor(pid) -> resulting code
	 - IO port shit
	 	- (0a) sys_inb(port) -> byte
		- (0b) sys_outb(port, byte)

free syscall numbers: 0d