# 6 常见问题

## 镜像问题

### Q:无法拉取(pull)镜象怎么办?
A: 我们提供[多种环境](https://pinguo.gitbooks.io/php-msf-docs/chapter-3/3.3-docker.html)的镜象.如果仍然无法拉取,可以尝试使用代理方式:在Docker 配置文件中添加 `export http_proxy="http://<PROXY_HOST>:<PROXY_PORT>"`.

### Q:挂载的共享目录,在容器内进行操作没有权限(Permission Denied)?
A: 这种情况很大原因可能是[启用了SElinux导致](https://stackoverflow.com/questions/24288616/permission-denied-on-accessing-host-directory-in-docker)的(如果`ls -l` 可以看到`-rwxr-xr-x.`最后的点,那么就是启用了SELinux),解决方案至少有两种方式:
+ Docker启用过程使用`--privileged`指定更高权限运行容器。
+ 关闭SElinux,你可以使用:
	- set "setenforce 0" 临时关闭
	- 修改/etc/sysconfig/selinux文件，将SELINUX的值设置为disabled

## 代码问题
### Q:Windows下server无法启动
A: 可以参见[这里](https://github.com/pinguo/php-msf-demo/issues/10)

### Q: 代码变更之后worker没有自动reload
A: 请确保配置文件已经开启自动重启: `$config['auto_reload_enable'] = true;` 文件监听使用的是Inotify,但目前[Docker-for-windows无法正常工作](https://docs.docker.com/docker-for-windows/troubleshoot/#docker-knowledge-hub).这种情况下,可以使用docker镜像内配置的[nodemon](https://github.com/remy/nodemon)来达到同样的效果.

# links
  * [目录](../README.md)
  * 上一节: [第五章小结](../chapter-5/5.12-小结.md)
  * 下一节: [附录](../chapter-7/7.0-附录.md)
