# 5.9 RESTful
MSF 原生支持RESTful风格api，提供GET/POST/PUT/PATCH/HEAD/OPTIONS/DELETE动作的支持。

### RESTful参考
  * [理解 RESTful 架构](http://www.ruanyifeng.com/blog/2011/09/restful.html)
  * [RESTful API 设计指南](http://www.ruanyifeng.com/blog/2014/05/restful_api.html?from=timeline&isappinstalled=0)
  * [从消费者的角度评估 REST 的价值](http://hippoom.github.io/blogs/value-of-hypermedia-from-client-perspective.html)

### verb 介绍
```
'GET',      // 从服务器取出资源（一项或多项）
'POST',     // 在服务器新建一个资源
'PUT',      // 在服务器更新资源（客户端提供改变后的完整资源）
'PATCH',    // 在服务器更新资源（客户端提供改变的属性）
'DELETE',   // 从服务器删除资源
'HEAD',     // 获取 head 元数据
'OPTIONS',  // 获取信息，关于资源的哪些属性是客户端可以改变的
```

### MSF实现RESTful程序
```
Rest |- Controller.php 控制器
     |- Route.php 路由器
```

### 使用方式
  1. 在配置文件中配置路由器为： `$config['server']['route_tool'] = '\\PG\\MSF\\Route\\RestRoute'`
  1. 配置URL路由规则
  1. 控制器继承 `PG\MSF\Rest\Controller`
  
### 推荐控制器接收不同动作映射
```
'PUT,PATCH {id}' => 'update', // 更新资源，如：/users/<id>
'DELETE {id}' => 'delete',    // 删除资源，如：/users/<id>
'GET,HEAD {id}' => 'view',    // 查看资源单条数据，如：/users/<id>
'POST' => 'create',           // 新建资源，如：/users
'GET,HEAD' => 'index',        // 查看资源列表数据（可分页），如：/users
'{id}' => 'options',          // 查看资源所支持的HTTP动词，如：/users/<id> | /users
'' => 'options',
```
### URL路由配置
通过请求url中的path和动作类型即可路由到对应控制器下的某个方法（method）。URL路由配置支持正则方式，在url的path中可携带参数。例如：
```
$config['rest']['route']['rules'] = [
    'GET,POST /groups' => '/account/profile',
    'GET /users/ask' => 'user/apply',
    'GET /users' => 'user/index',
    'GET /users/<uid:\d+>' => 'user/view',
    'PUT /users/<method:\w+>' => 'user/<method>',
    'DELETE /users/<uid:\d+>' => 'user/delete',
]
```

### 响应
在控制器中使用 `$this->output(<params>,); `即可;

### 状态码
状态码只能是标准的http状态码，所有状态码见 `\PG\MSF\Base\Output::$codes`

# links
  * [目录](../README.md)
  * 上一节: [公共库](5.8-公共库.md)
  * 下一节: [小结](5.10-多语言.md)
