# 5.10 多语言

MSF通过插件支持多语言(i18n)，国际化（I18N）是指在设计软件时，
使它可以无需做大的改变就能够适应不同的语言和地区的需要。对于 Web 应用程序， 
这有着特别重要的意义，因为潜在的用户可能会在全球范围内。 
MSF 提供的国际化功能支持全方位信息翻译， 视图翻译，日期和数字格式化。

## 区域和语言

区域设置是一组参数以定义用户希望能在他们的用户界面所看到用户的语言，国家和任何特殊的偏好。 
它通常是由语言 ID 和区域 ID 组成。 例如，ID “en-US” 代表英语和美国的语言环境。
为了保持一致性， 在 MSF 应用程序中使用的所有区域 ID 应该规范化为 `ll-CC`。 
例如 zh_CN(简体中文)、en_US(美国英语)、zh_TW(繁体中文) ...

## 项目支持配置

```php
$config['params']['i18n'] = [
    'demo' => [ // 消息类别名称
        'sourceLanguage' => 'en_us', //源语言
        'basePath' => ROOT_PATH . '/languages', //翻译语言配置文件路径
        'fileMap' => [
            'common' => 'common.php', //翻译配置文件
            'error' => 'error.php', //随意自定义即可
            ...
        ]
    ],
    ...
];
```
## 翻译语言文件示例
```php
// languages/zh_CN/common.php
return [
    'sayHi' => '你好,{name}' // {name}为变量占位符
];

// languages/zh_CN/error.php
return [
    '200' => '正常'
];

// languages/en_US/common.php
return [
    'sayHi' => 'Hello，{name}'
];

// languages/en_US/error.php
return [
    '200' => 'Ok'
];
```

## 在业务中使用

首先需要在业务中初始化I18N：
```php
I18N::getInstance(getInstance()->config->get('params.i18n', []));
// params.i18n 就是上面的配置段，可以自定义，但是要和上面的配置名对应好。
// 这行最好在自己的AppServer里初始化或者在业务控制器基类里的构造方法初始化。
```

```php
public function actionI18n()
{
    // 这行最好在自己的AppServer里初始化或者在业务控制器基类里的构造方法初始化，这里只作为演示方便
    I18N::getInstance(getInstance()->config->get('params.i18n', []));
    $sayHi = [
        'zh_cn' => I18N::t('demo.common', 'sayHi', ['name' => '品果微服务框架'], 'zh_CN'),
        'en_us' => I18N::t('demo.common', 'sayHi', ['name' => 'msf'], 'en_US'),
    ];

    $this->outputJson(['data' => $sayHi, 'status' => 200, 'msg' => I18N::t('demo.error', 200, [], 'zh_CN')]);
}
```

# links
  * [目录](../README.md)
  * 上一节: [RESTful](5.9-RESTful.md)
  * 下一节: [杂项](5.11-杂项.md)