# 4.6 配置

配置是框架的重要组成部分,MSF框架的配置组件采用了第三方的[hassankhan/config](https://github.com/hassankhan/config),它支持多种配置书写的文件格式如:PHP,INI,XML,JSON,YAML,可以满足大部分的配置需求。但是建议采用PHP数组文件来配置我们的服务。

## PHP配置数组文件

配置采用PHP数组的形式进行书写,每个配置文件的最后一行都需要返回,即`return $config`,如:

```php
<?php
/**
 * MongoDb配置文件
 *
 * @author camera360_server@camera360.com
 * @copyright Chengdu pinguo Technology Co.,Ltd.
 */

$config['mongodb']['test']['server'] = 'mongodb://192.168.1.106:27017';
$config['mongodb']['test']['options'] = ['connect' => true];
$config['mongodb']['test']['driverOptions'] = [];

return $config;
````

## 配置目录

在应用程序的主目录中有`config`目录,是用来存放所有配置文件,配置目录的参考结构:

```
├── config // 配置目录
│   ├── check.php // 代码检查配置
│   ├── server.php // 主配置文件（server服务相关）
│   ├── constant.php // 业务常量定义文件
│   ├── log.php // 全局日志配置
│   ├── http.php // HTTP服务配置
│   ├── params.php // 全局业务配置（和运行环境无关）
│   ├── dev // 研发联调环境特殊配置目录
│   ├── docker // docker环境特殊配置目录
│   ├── product // 生产环境特殊配置目录
│   ├── qa // QA环境特殊配置目录
```

对于各个环境的差异配置,单独存在在不同的目录中,如:


`config/docker` 存放Docker环境配置

`config/dev`    存放研发联调环境配置

`config/qa`     存放QA环境配置

`product`       存放生产环境配置


## 主配置文件

是配置服务实例的大部分配置,包括Http Server的参数配置,服务器进程pid文件目录,服务进程名称,服务器worker、Task、reactor数量等等。

### 主配置重要选项说明

#### $config['server']

- $config['server']['process_title']

server服务进程标题前缀

- $config['server']['runtime_path']

server服务运行时目录

- $config['server']['pid_path']

server服务运行时pid目录

- $config['server']['route_tool']

server服务路由分发请求的类名,首先查找app\Route目录,再查到php-msf\src\Route目录,默认为`NormalRoute`

#### $config['server']['set']

- $config['server']['set']['reactor_num']

swoole server的reactor数量,更多请参考[reactor_num](https://wiki.swoole.com/wiki/page/281.html)

- $config['server']['set']['worker_num']

swoole server的worker数量,更多请参考[worker_num](https://wiki.swoole.com/wiki/page/275.html)

- $config['server']['set']['backlog']

swoole server的backlog队列长度,更多请参考[backlog](https://wiki.swoole.com/wiki/page/279.html)

- $config['server']['set']['dispatch_mode']

swoole server的数据包分发策略,对于http服务器推荐设置为1,更多请参考[dispatch_mode](https://wiki.swoole.com/wiki/page/277.html)

- $config['server']['set']['task_worker_num']

swoole server的task worker数量,更多请参考[task_worker_num](https://wiki.swoole.com/wiki/page/276.html)

swoole server的其他配置项,具体参考:[配置选项](https://wiki.swoole.com/wiki/page/274.html)

#### $config['config_manage_enable']

是否启动配置进程,设置为true或者false

#### $config['auto_reload_enable']

是否开启自动检测文件更新,并重启服务,在开发环境建议设置为true,生产环境设置为false

#### $config['user_timer_enable']

是否开启自定义业务Timer进程，为业务需求而定，主要用于一些定时业务，设置为true或者false

#### $config['http_server']

Http服务器相关配置,主要有以下几个重要子配置项

- $config['http_server']['port']

Http服务器监听的端口

- $config['http_server']['socket']

Http服务器监听的地址

#### $config['http']

- $config['http']['domain']

使用Http服务器时,绑定的域名列表

- $config['http']['domain']['localhost']

使用Http服务器时,绑定一个localhost的域名

- $config['http']['domain']['localhost']['root']

使用Http服务器时,绑定了一个localhost的域名,并且域名对应的根目录为此配置项的值，需要特别注意的是，一旦配置了root，那该目录下所有文件就可以被用户访问到

- $config['http']['domain']['localhost']['index']

使用Http服务器时,绑定了一个localhost的域名,并且域名对应的索引文件此配置项的值

- $config['http']['default_method']

使用Http服务器时,Controller的默认方法名,在路由请求时使用


## 日志配置

```php
<?php
/**
 * 日志配置文件
 *
 * @author camera360_server@camera360.com
 * @copyright Chengdu pinguo Technology Co.,Ltd.
 */

$config['server']['log'] = [
    'handlers' => [
        'application' => [
            'levelList' => [
                \PG\Log\PGLog::EMERGENCY,
                \PG\Log\PGLog::ALERT,
                \PG\Log\PGLog::CRITICAL,
                \PG\Log\PGLog::ERROR,
                \PG\Log\PGLog::WARNING
            ],
            'dateFormat' => "Y/m/d H:i:s",
            'format' => "%datetime% [%level_name%] [%channel%] [logid:%logId%] %message%\n",
            'stream' => RUNTIME_DIR . '/application.log',
            'buffer' => 0,
        ],
        'notice' => [
            'levelList' => [
                \PG\Log\PGLog::NOTICE,
                \PG\Log\PGLog::INFO,
                \PG\Log\PGLog::DEBUG
            ],
            'dateFormat' => "Y/m/d H:i:s",
            'format' => "%datetime% [%level_name%] [%channel%] [logid:%logId%] %message%\n",
            'stream' => RUNTIME_DIR . '/notice.log',
            'buffer' => 0,
        ]
    ]
];

return $config;
```

更新配置示例请参考示例项目[php-msf-demo/config](https://github.com/pinguo/php-msf-demo/blob/master/config/log.php)

## 使用配置

在任何地方都可以通过`getInstance()->config`来访问读取配置,另外在继承`\PG\MSF\Base\Core`类的子类（比如Controller/Model等等）都可以通过`$this->getConfig()`来获取配置对象,访问配置项的代码如:

[php-msf/config/params.php](https://github.com/pinguo/php-msf/pinguo/config/params.php)

```php
<?php
/**
 * 业务参数
 *
 * @author camera360_server@camera360.com
 * @copyright Chengdu pinguo Technology Co.,Ltd.
 */

$config['params']['mock_ids'] = [
    '581af00d4b58d59d22e8d7a6',
    '581198754b58d54465ef4cad',
    '580c7fa44b58d53f43e21c43',
    '57ef6aec4b58d50d24e21a2a',
    '57ee28ed4b58d52f24e21969',
    '57eb6a484b58d50e3d078076',
    '57e23b444b58d52f1e6689fc',
    '57dfc9fc4b58d5581e668918',
    '57de06b74b58d5471e66882f',
    '57d8b78f4b58d5311e6686d5',
];
return $config;
```

```php
getInstance()->config->get('params.mock_ids', [])
```

get()方法的第一个参数为key名称,对于多维数组的配置,采用点分隔;第二个参数为配置选项默认值,即没有读取到配置时的默认配置。

# links
  * [目录](../README.md)
  * 上一节: [同步任务](4.5-同步任务.md)
  * 下一节: [路由](4.7-路由.md)
