# 4.1 结构概述

## app分支(示例业务代码)

示例项目，使用msf构建业务应用的推荐方式，主要目录结构为

```
.
├── README.md
├── app // PHP业务代码
│   ├── AppServer.php // 应用server类，可根据需求自定义
│   ├── Controllers // 控制器类目录
│   ├── Lib // 特殊逻辑处理类目录
│   ├── Models // Model类目录
│   ├── Route // 特殊路由规则类目录
│   ├── Tasks // Task类目录
│   └── Views // 视图文件目录
├── build.sh // 构建脚本（拉取docker镜像，启动容器）
├── checkstyle.sh // 代码检查脚本
├── composer.json // composer包依赖配置文件
├── config // 配置目录
│   ├── check.php // 代码检查配置
│   ├── server.php // 主配置文件（server服务相关）
│   ├── constant.php // 业务常量定义文件
│   ├── log.php // 全局日志配置
│   ├── http.php // HTTP服务配置
│   ├── params.php // 全局业务配置（和运行环境无关）
│   ├── dev // 研发联调环境特殊配置目录
│   ├── docker // docker环境特殊配置目录
│   ├── product // 生产环境特殊配置目录
│   ├── qa // QA环境特殊配置目录
├── server.php // server启动脚本
├── console.php // 命令行脚本
├── test // 单元测试目录
└── www  // server根目录
    └── index.html // 索引文件
```

## master分支(框架源代码)

框架源码，支持composer安装，具有composer包管理的所有特性，仅为框架代码，不包含任何业务逻辑，主要目录结构为

```
.
├── Base // 核心
│   ├── AOPFactory.php //切片类工厂
│   ├── Child.php // 基类
│   ├── Core.php // 内核基类
│   ├── Input.php // 用户输入对象
│   └── Output.php // 用户输出对象
│   └── Pool.php // 通用对象池类
├── Client // 客户端
│   ├── ConcurrentClient.php // flex风格的并行请求
│   ├── Http // HTTP客户端
│   │   └── Client.php // HTTP客户端实现
│   └── RpcClient.php // RPC Client
├── Console // 命令行
│   ├── Controller.php // 命令行控制器基类
│   └── Request.php // 命令行请求对象
├── Controllers // Web控制器
│   ├── Controller.php // web请求控制器基类
│   ├── Monitor.php // 内存服务器运行状态控制器
│   ├── Rest.php  // Restful风格的API控制器示例
│   └── Rpc.php  // 处理RPC请求控制器
├── Coroutine // 协程
│   ├── Base.php // IO协程基类
│   ├── CException.php // 协程异常
│   ├── CNull.php // 协程NULL值
│   ├── CTask.php // Task协程
│   ├── Dns.php // DNS协程
│   ├── Http.php // HTTP请求协程
│   ├── IBase.php // IO协程接口类
│   ├── MySql.php // MySQL协程
│   ├── Redis.php // Redis协程
│   ├── Scheduler.php // 协程调度器
│   └── Task.php // 协程类
├── Helpers // 辅助工具
│   ├── Common.php // 全局函数
│   └── Context.php // 请求上下文
├── HttpServer.php // Http Sever类
├── Marco.php // 全局类常量
├── Models // 模型
│   └── Model.php // 模型基类
├── MSFCli.php // Cli命令行
├── MSFServer.php // MSFServer服务类
├── Pack // 打包
│   ├── IPack.php // 打包基类
│   ├── JsonPack.php // Json
│   ├── MsgPack.php // MsgPack
│   └── SerializePack.php // Serialize
├── Pools // 连接池
│   ├── AsynPoolManager.php // 连接池管理器
│   ├── AsynPool.php // 连接池
│   ├── CoroutineRedisProxy.php // Redis连接池的协程辅助类
│   ├── IAsynPool.php // 连接池接口类
│   ├── Miner.php // MySQL Query Builder
│   ├── MysqlAsynPool.php // 异步MySQL连接池
│   └── RedisAsynPool.php // 异步Redis连接池
├── Process // 用户自定义进程
│   ├── Config.php // 配置管理进程
│   ├── Inotify.php // 文件监控进程
│   ├── ProcessBase.php // 自定义进程基类
│   └── Timer.php // 用户自定义定时器进程
├── Proxy // 代理
│   ├── IProxy.php // 代理接口
│   ├── RedisProxyCluster.php // Redis分布式代理类
│   ├── RedisProxyFactory.php // Redis代理工厂类
│   └── RedisProxyMasterSlave.php // Redis主从代理类
├── Rest // Restful
│   ├── Controller.php // Restful风格的API控制器基类
│   └── Serializer.php // Restful相关分页、序列化类
├── Route // 路由
│   ├── IRoute.php // 路由接口类
│   ├── NormalRoute.php // 通用路由类
│   └── RestRoute.php // Rest路由类
├── Server.php // Server基类
├── Tasks // Task
│   ├── MongoDbTask.php // MongoDB Task
│   ├── Task.php // Task基类
│   └── TaskProxy.php // Task Proxy
└── Views // 视图
    ├── error_404.php 
    └── test.html
```

# links
  * [目录](../README.md)
  * 上一节: [框架结构](4.0-框架结构.md)
  * 下一节: [控制器](4.2-控制器.md)