# 3.2 运行代码

这里以运行示例项目代码为例

## 克隆

```bash
$>git clone git@github.com:pinguo/php-msf-demo.git php-msf-demo
$>cd php-msf-demo
$>ll
drwxr-xr-x 10 worker worker   340 Sep  4 14:40 app
-rwxr-xr-x  1 worker worker  9984 Sep  4 14:40 build.sh
-rwxr-xr-x  1 worker worker    61 Sep  4 14:40 checkstyle.sh
-rw-r--r--  1 worker worker   650 Sep  4 15:12 composer.json
-rw-r--r--  1 worker worker 22582 Sep  4 14:40 composer.lock
drwxr-xr-x 13 worker worker   442 Sep  4 14:40 config
-rwxr-xr-x  1 worker worker   586 Sep  4 14:40 console.php
-rw-r--r--  1 worker worker 18093 Sep  4 14:40 LICENSE
-rw-r--r--  1 worker worker   233 Sep  4 14:40 README.md
-rwxr-xr-x  1 worker worker   617 Sep  4 14:40 server.php
drwxr-xr-x  3 worker worker   102 Sep  4 14:40 test
drwxr-xr-x  3 worker worker   102 Sep  4 14:40 www
```

## 运行

### build.sh(Docker环境)

```bash
$>cd php-msf-demo
$>./build.sh
```

### 登入Docker容器
```
$> ssh -p 2202 worker@127.0.0.1
密码："worker"(无双引号)
```

其中`2202`端口是根据映射`-p 2202:22`来的，如果有修改请调整为修改后的值。

### composer

```bash
$>cd /home/worker/data/www/php-msf-demo
$>composer install -vvv
```

如果出现下面的情况：

```
Reading ./composer.json
Loading config file /home/worker/.composer/config.json
Loading config file /home/worker/.composer/auth.json
Loading config file ./composer.json


  [UnexpectedValueException]
  Your github oauth token for github.com contains invalid characters: "your auth token"


Exception trace:
 () at phar:///home/worker/php/bin/composer/src/Composer/IO/BaseIO.php:104
 Composer\IO\BaseIO->loadConfiguration() at phar:///home/worker/php/bin/composer/src/Composer/Factory.php:325
 Composer\Factory->createComposer() at phar:///home/worker/php/bin/composer/src/Composer/Factory.php:576
 Composer\Factory::create() at phar:///home/worker/php/bin/composer/src/Composer/Console/Application.php:332
 Composer\Console\Application->getComposer() at phar:///home/worker/php/bin/composer/src/Composer/Console/Application.php:444
 Composer\Console\Application->getPluginCommands() at phar:///home/worker/php/bin/composer/src/Composer/Console/Application.php:149
 Composer\Console\Application->doRun() at phar:///home/worker/php/bin/composer/vendor/symfony/console/Application.php:127
 Symfony\Component\Console\Application->run() at phar:///home/worker/php/bin/composer/src/Composer/Console/Application.php:100
 Composer\Console\Application->run() at phar:///home/worker/php/bin/composer/bin/composer:54
 require() at /home/worker/php/bin/composer:24
```

请在[Github Personal Setting](https://github.com/settings/tokens)添加Personal access tokens，然后将token复制下来保存到：

```bash
$>vi /home/worker/.composer/auth.json
{
    "github-oauth": {
        "github.com": "your auth token"
    }
}
```

### supervisor

```bash
$>supervisorctl
supervisor> update
php-msf-demo: added process group
supervisor> status
msf:php-msf-demo            RUNNING   pid 26958, uptime 0:00:31
//...
```

### 访问服务

Demo示例项目配置了HTTP索引页，直接浏览器访问[http://127.0.0.1:8000](http://127.0.0.1:8000)，可以看到如下界面：

![HTTP索引页](../images/http-index.png)

### 查看服务日志

```bash
$>cat ~/data/msf-php-msf-demo/server.log
      _______                               ____
________  / /_  ____        ____ ___  _____/ __/
___/ __ \/ __ \/ __ \______/ __ `__ \/ ___/ /_
__/ /_/ / / / / /_/ /_____/ / / / / (__  ) __/
_/ .___/_/ /_/ .___/     /_/ /_/ /_/____/_/
/_/         /_/         Camera360 Open Source TM
[2017-08-30 11:19:54] MSF     Version: 3.0.0
[2017-08-30 11:19:54] Swoole  Version: 1.9.15
[2017-08-30 11:19:54] PHP     Version: 7.1.8
[2017-08-30 11:19:54] Application ENV: production
[2017-08-30 11:19:54] Worker   Number: 4
[2017-08-30 11:19:54] Task     Number: 8
[2017-08-30 11:19:54] Listen     Addr: 0.0.0.0
[2017-08-30 11:19:54] Listen     Port: 8000
[2017-08-30 11:19:54] Config  Manager: Enabled
[2017-08-30 11:19:54] Inotify  Reload: Enabled
```

### 监控应用运行日志

```bash
$>tail -f /home/worker/data/www/runtime/php-msf-demo/*.log
2017/08/30 10:09:21 [notice] [demo] [logid:59a61e51c3474d74175f647f] [0(ms)] [1(MB)] [/Bench/RedisPoolSet] [controller=Bench method=actionRedisPoolSet verb=GET status=200] profile[] counting[]
2017/08/30 10:09:22 [notice] [demo] [logid:59a61e52c3474d74175f6480] [0(ms)] [1(MB)] [/Bench/RedisPoolSet] [controller=Bench method=actionRedisPoolSet verb=GET status=200] profile[] counting[]
2017/08/30 10:09:23 [notice] [demo] [logid:59a61e53c3474d74175f6481] [0(ms)] [1(MB)] [/Bench/RedisPoolSet] [controller=Bench method=actionRedisPoolSet verb=GET status=200] profile[] counting[]
2017/08/30 10:09:49 [notice] [demo] [logid:59a61e6dc3474d74175f6482] [0(ms)] [1(MB)] [/Monitor] [controller=Monitor method=actionIndex verb=GET status=200] profile[] counting[]
2017/08/30 10:39:50 [notice] [demo] [logid:59a62576c3474d746001a631] [42(ms)] [1(MB)] [/Bench/HttpCallBack] [controller=Bench method=actionHttpCallBack verb=GET] profile[] counting[]
2017/08/30 10:39:52 [notice] [demo] [logid:59a62578c3474d746001a632] [3(ms)] [1(MB)] [/Bench/HttpCallBack] [controller=Bench method=actionHttpCallBack verb=GET] profile[] counting[]
2017/08/30 10:40:00 [notice] [demo] [logid:59a62580c3474d746001a633] [44(ms)] [1(MB)] [/Bench/HttpCoroutine] [controller=Bench method=actionHttpCoroutine verb=GET] profile[297#dns-127.0.0.1=0.4(ms)/1,955#api-http://127.0.0.1:80/=1.5(ms)/1] counting[]
2017/08/30 10:40:01 [notice] [demo] [logid:59a62581c3474d746001a634] [4(ms)] [1(MB)] [/Bench/HttpCoroutine] [controller=Bench method=actionHttpCoroutine verb=GET] profile[726#dns-127.0.0.1=0.2(ms)/1,587#api-http://127.0.0.1:80/=3.9(ms)/1] counting[]
2017/08/30 10:40:02 [notice] [demo] [logid:59a62582c3474d746001a635] [4(ms)] [1(MB)] [/Bench/HttpCoroutine] [controller=Bench method=actionHttpCoroutine verb=GET] profile[332#dns-127.0.0.1=0.1(ms)/1,584#api-http://127.0.0.1:80/=3.3(ms)/1] counting[]
2017/08/30 10:40:02 [notice] [demo] [logid:59a62582c3474d746001a636] [3(ms)] [1(MB)] [/Bench/HttpCoroutine] [controller=Bench method=actionHttpCoroutine verb=GET] profile[882#dns-127.0.0.1=0.1(ms)/1,493#api-http://127.0.0.1:80/=3.0(ms)/1] counting[]
```

快捷指令

* logr

监控运行日志

* logp

监控PHP日志

* logn

监控nginx日志

# links
  * [目录](../README.md)
  * 上一节: [环境变量](3.1-环境变量.md)
  * 下一节: [docker](3.3-docker.md)