# 3.1 环境变量

系统环境变量，相应的环境配置如下：

```bash
$>vi ~/.bashrc
...
$>export MSF_ENV=...
```

## docker

```
$>export MSF_ENV=docker
```

## dev

```
$>export MSF_ENV=dev
```

## qa

```
$>export MSF_ENV=qa
```

## online

```
$>export MSF_ENV=product_en
```

## 环境变量的应用

```php
#!/home/worker/php/bin/php
<?php
/**
 * swoole server
 *
 * @author camera360_server@camera360.com
 * @copyright Chengdu pinguo Technology Co.,Ltd.
 */

define('ROOT_PATH', __DIR__);
define('APP_DIR', ROOT_PATH . '/app');
define('APPLICATION_ENV', $_ENV['MSF_ENV'] ?? 'docker');
define('SYSTEM_NAME', 'demo');
define("WWW_DIR", realpath(dirname(__FILE__) . '/..'));
define('RUNTIME_DIR', WWW_DIR . '/runtime/' . SYSTEM_NAME);
define('DUMP_TRUNCATED', true);
!is_dir(RUNTIME_DIR) && @mkdir(RUNTIME_DIR, 0755, true);

require_once __DIR__ . '/vendor/autoload.php';

$worker = new \App\AppServer();
PG\MSF\Server::run();
```

[server.php](https://github.com/pinguo/php-msf-demo/blob/master/server.php)

通过`define('APPLICATION_ENV', $_ENV['MSF_ENV'] ?? 'docker');`，定义常量，从而对应加载相应目录的配置，如：`config/docker/`。

# links
  * [目录](../README.md)
  * 上一节: [框架运行环境](3.0-框架运行环境.md)
  * 下一节: [运行代码](3.2-运行代码.md)