# 1 为什么要研发新的PHP框架?

PHP语言从1995年发布,至今已经有20多年的历史,在期间涌现了成千上万的MVC框架,我们大致可以将其分为以下三大类:

- 公司内部自研

有大量的公司会自研MVC框架,会根据自身业务的特性打造适合自身的PHP框架;

- PHP开源框架

现PHP开源社区流行的PHP MVC框架有Yii、Laravel、CodeIgniter、ZendFrameWork、Symfony等;

- C扩展

纯C扩展的PHP MVC框架由于研发难度大,不易修改,学习成本相对较高,故直到近几年才出现,比如Yaf、Phalcon等。

上述三类的PHP MVC运行的环境为LA(N)MP,而且其中的A(N)是不可或缺的,也就是说他们都需要依赖Web Server来承接用户的请求,将请求转发给PHP进程,解析并执行PHP代码,而这样的工作模式是所有PHPer根深蒂固的认知,甚至笔者在前几年听到有人说“我们可以抛弃php-fpm,nginx”,心想简直是无稽之谈。

随着互联网技术的发展,大量公司的后端技术架构都在往微服务架构变迁,微服务架构要求我们尽可能的将我们的业务拆分到独立的部署单元,当然微服务框架的好处是很“诱人”的,但是它会带来大量的成本开销和性能开销,如何在微服务架构实践中节约成本和提升性能是我们不可迈过的沟壑。

## 那在PHP生态中传统的LA(N)MP能满足微服务框架的需求吗?

答案显然是不能的,就目前PHP的fastcgi进程管理器php-fpm和nginx的配合已经运行得足够好,但是由于php-fpm本身是同步阻塞进程模型,在请求结束后释放所有的资源（包括框架初始化创建的一系列对象）,导致PHP进程“空转”（创建<-->销毁<-->创建）消耗大量的CPU资源,从而导致单机的吞吐能力有限。

## 我们是不是应该切换开发语言?

先简单的来看换开发语言,一个公司或者团队切换开发语言的成本是巨大的,它直接面临着放弃已有的技术沉淀,学习新的语言生态和习惯做法,并将现有业务的全面重构,同时整个运维技术栈也要同步更新,需要踩过无数个“坑”,所以我们这里暂不展开去讲切换开发语言来解决我们的核心问题。

## 那我们还有什么解决方案?

我们分析我们的业务不难发现,90%以上的业务都是IO密集性业务,我们只需要提高IO复用的能力就可以提升单机吞吐能力,另外需要将php-fpm同步阻塞模式替换为异步非阻塞模式,当然不一定使用php-fpm,就可以解决我们的核心问题——性能。不幸的是目前PHP生态中还没有一个工程级别的MVC框架能够满足我们的需求。

综上所述,我们需要研发全新的现代化的PHP框架,为微服务架构打下坚实的基础。

# links
  * [目录](../README.md)
  * 上一节: [目录](../README.md)
  * 下一节: [传统php-fpm工作模式的问题](1.1-传统php-fpm工作模式的问题.md)