<h2> PiFi - The Simple Raspberry Pi Router Project</h2>


PiFi is a project with free router firmware, a smartphone app and USB accessory that lets you very quickly turn Raspberry Pi into a powerful wireless router.

- **Easy-to-install**: Setup in minutes with pre-configured firmware and app
- **Every device**: Works with everything including consoles and Smart TVs
- **Up to 8x Faster** - [USB 3.0 AC1300Mbps Accessory](https://www.pifi.org/pifi-kit) for Faster Wireless Performance
- **Wireguard & OpenVPN**: Network-wide VPN with any of your favourite providers
- **AdGuard Home**: Block ads and trackers in apps and browser on all devices
- **Network Storage**: Use your SD card or USB Flash Drives for easy network sharing of files, documents and more
- **OpenWRT Under-the-Hood**: An optimised build of OpenWRT so you still have LuCI/SSH access as well as out-of-the-box support for Wireguard, OpenVPN, AdGuardHome, Network Storage and more
- **Community Support**: Ask questions and share feedback in the [PiFi Community Forum](https://community.pifi.org)
- **Free**: Open-source firmware and free app ([download](https://www.pifi.org/downloads))

---


## Installation Instructions:

You can download the latest firmware image/apps at [pifi.org/downloads](https://www.pifi.org/downloads)

Or download on the [GitHub releases](https://github.com/pifi-org/pifi-openwrt-raspberry-pi/releases) page (be sure to select the correct model and get the app ([here](https://www.pifi.org/app))

Installation is easy (download, flash with Raspberry Pi imager, insert SD card and power on and PiFi should show in WiFi Settings (default password Raspberry314). Then then follow the setup steps in the PiFi app. 

For more detailed download and setup instructions, see the [download and setup guide](https://docs.pifi.org/download-setup)

## Contribute

I welcome *everyone* to contribute through [reporting bugs](https://app.pifi.org/quillforms/report-a-bug/), [suggesting new features](https://app.pifi.org/quillforms/pifi-feedback/), or even building their own builds from source (see top of this page for Pi 4 / Pi 5 Source). 

If you have anything you want to share - from a typo error to a new feature suggestion then please leave feedback here or publicly on the [PiFi forum](https://community.pifi.org)

## PiFi Software is Free

PiFi firmware is based on OpenWRT and released under the same open source licence (source code at top of this page). There are no plans to charge for firmware or app and it’s free to use.

At the moment the project has a single developer - I’m not looking for donations for the project. I plan to continue to work full-time on the project and for it to be sustainable through sales of the [PiFi Kit](https://www.pifi.org/pifi-kit) and may also offer premium app functionality at a later date but the core functionality will remain free.

So currently the main way to support the project is by sharing with friends, providing feedback and if you want better performance then investing in the [PiFi Kit](https://www.pifi.org/pifi-kit) which includes:

- Pre-installed SD Card, USB Adapter & Gigabit Ethernet Cable (Plug & Play)
- Up to **8x Faster Wireless Performance** (vs internal radio on Pi 4)
- Travel Router Mode (AP+STA) - Wireless Pair + Broadcast
- Broadcast 2 networks at the same time (5Ghz + 2.4Ghz)
- Physical Factory Reset (remove USB adapter to reset network)
- PiFi Premium - early access to updates and exclusive in-app features (only available through PiFi Kit)

## Getting in touch
- [PiFi Community Forum](https://community.pifi.org)
- [Feature Request](https://app.pifi.org/quillforms/pifi-feedback/)
- [Report a Bug](https://app.pifi.org/quillforms/report-a-bug/)
- [Hardware Request (i.e Raspberry Pi 3)](https://app.pifi.org/quillforms/request-hardware/)

You can also reach out at [contact@pifi.org](mailto:contact@pifi.org) (please not: this is not a technical support inbox and tech support is only offered through the [PiFi Community Forum](https://community.pifi.org))
