delphi-libraries-list
=====================

List of Delphi Libraries and Frameworks


### Inversion of Control - Dependency injection

- Spring4D 
  - repo: https://bitbucket.org/sglienke/spring4d
  - Nick Hodges Talk: Dependency Injection and the Delphi Spring Framework : http://www.youtube.com/watch?v=8iB_ppvpjxM

- Emballo (not currently maintained)
  - repo: https://code.google.com/p/emballo/

- Good Readings
  - http://blog.synopse.info/post/2012/10/14/Interfaces-in-practice%3A-dependency-injection%2C-stubs-and-mocks
  - http://delphisorcery.blogspot.ch/2013/12/dependency-injection-best-practices.html

### Duck Typing

- simple duck typing to Delphi Objects (easy RTTI) : http://code.google.com/p/duckduckdelphi/



### Object Serialization

- JSON
  - Chimera (XE2)
    - web site: http://arcana.sivv.com/chimera
  - SuperObject
    - web site: http://code.google.com/p/superobject/
    - documentation: http://superobject.googlecode.com/git/readme.html
  - JSON parsing in mORMot : http://blog.synopse.info/post/2011/06/02/Fast-JSON-parsing
- DB <-> Object mapping
  -tiOPF:  http://tiopf.sourceforge.net/index.shtml



### Unit Testing

- DUnitX: https://github.com/VSoftTechnologies/DUnitX
  - Article: http://www.finalbuilder.com/Resources/Blogs/PostId/697/introducing-dunitx.aspx
- Dunit: http://dunit.sourceforge.net/
- DelphiSpec: https://github.com/RomanYankovsky/DelphiSpec

- mORMot Mocks
  - Unit testing - see http://blog.synopse.info/post/2010/07/23/Unit-Testing-light-in-Delphi
  - Stubs and Mocks - see http://blog.synopse.info/post/2012/10/14/Stubs-and-Mocks-for-Delphi-with-mORMot

- Delphi-Mocks 
  - repo: https://github.com/VSoftTechnologies/Delphi-Mocks
  - Delphi-Mocks Article
    - http://delphisorcery.blogspot.fr/2011/09/pimp-your-unit-tests-using-mock-objects.html
    - http://www.finalbuilder.com/Resources/Blogs/PostId/417/introducing-delphi-mocks.aspx
- Code coverage 
  - repo : http://code.google.com/p/delphi-code-coverage/
  - article : http://thundaxsoftware.blogspot.ch/2013/02/using-delphi-code-coverage.html
  - Jenkins / Hudson integration : http://christerblog.wordpress.com/2010/07/02/delphi-code-coverage-in-hudson/
- GUI Testing
  - http://www.gearheadforhire.com/articles/ruby/win32-autogui/using-ruby-to-drive-windows-applications
  - OpenCTF: http://openctf.sourceforge.net/
 

### Build - Continuous integration

- Jenkins / Hudson integration : http://christerblog.wordpress.com/2010/04/25/using-hudson-to-build-delphi-projects/


### Math

- TPMath (scientific library): http://www.unilim.fr/pages_perso/jean.debord/tpmath/tpmath.htm

### Networking

- ZeroMQ Delphi bindings https://github.com/bvarga/delphizmq
- Indy (Internet protocol components): http://www.indyproject.org/index.en.aspx
- mORMot, n-Tier / Client-Server
  - http://blog.synopse.info/post/2012/03/07/Interface-based-services      
  - http://blog.synopse.info/post/2010/07/18/DataSnap-like-Client-Server-JSON-RESTful-Services-in-Delphi-7-2010

### Internet / Web
- Embeddable browser
  - Delphi Chromium Embedded 3: http://code.google.com/p/dcef3/
  - Delphi Chromium Embedded: http://code.google.com/p/delphichromiumembedded/
- Web frameworks
  - Delphi On Rails https://code.google.com/p/delphionrails/
  - delphi MVC framework : https://code.google.com/p/delphimvcframework/
  - xxm: http://xxm.sourceforge.net/
- Http server http://blog.synopse.info/post/2011/03/11/HTTP-server-using-fast-http.sys-kernel-mode-server 

### DB - ORM

- Delphi-ORM: https://code.google.com/p/delphi-orm/
- mORMot:  http://synopse.info/fossil/wiki?name=SQLite3+Framework
- ZeosLib (database components): http://sourceforge.net/projects/zeoslib/
- SQLite wrapper: https://github.com/stijnsanders/TSQLite
- MongoDB connector: https://github.com/stijnsanders/TMongoWire

### Reporting

  - Report from code - see http://blog.synopse.info/post/2010/06/30/Making-report-from-code
  - PDF export - see http://blog.synopse.info/category/Open-Source-Projects/Synopse-PDF-engine


### Threading

- OmniThread Library: http://code.google.com/p/omnithreadlibrary/
 
### Memory-Managers

- SapMM: https://code.google.com/p/sapmm/
- LeakCheck: https://bitbucket.org/shadow_cs/delphi-leakcheck/ multi-platform memory manager with leak checking and DUnit integration.
- FastMM: https://github.com/pleriche/FastMM4

### DataBindings

- ReduxDelphi, predictable state container : https://github.com/pierrejean-coudert/ReduxDelphi
- DSharp 
  - repo: https://bitbucket.org/sglienke/dsharp
  - web site: http://delphisorcery.blogspot.fr/


### Scripting

- DWScript: http://code.google.com/p/dwscript/
- Python-4-Delphi: http://code.google.com/p/python4delphi/
- Delphi Javascript: http://code.google.com/p/delphi-javascript/
- ECMAScript 5 + JIT (SpiderMonkey) / Pascal integration: http://blog.synopse.info/post/2014/04/07/JavaScript-support-in-mORMot-via-SpiderMonkey
- BESEN, ECMAScript 5 in Object Pascal: https://github.com/bero1985/besen
- Lua bindings: https://github.com/cxflag203/delphimvcframework/tree/master/lib/luadelphibinding
- Very Simple Lua https://github.com/Dennis1000/verysimplelua
- RemObjects PascalScript: https://github.com/remobjects/pascalscript
- Behavior3 for Delphi https://github.com/Dennis1000/behavior3delphi


### Data Structure

- http://www.boyet.com/FixedArticles/EZDSL.html
- The Delphi Container Library: http://sourceforge.net/projects/dclx/

### User Interface

- TChromeTabs: http://code.google.com/p/delphi-chrome-tabs/
- SynEdit: http://synedit.sourceforge.net/
- virtual-treeview: https://code.google.com/p/virtual-treeview/
- Task Dialogs: http://blog.synopse.info/post/2011/03/05/Open-Source-SynTaskDialog-unit-for-XP%2CVista%2CSeven
- vcl-styles-utils: Extend the Delphi VCL Styles (XE2+), http://code.google.com/p/vcl-styles-utils/ 
- Free ErrorSoft Vcl Components: https://github.com/errorcalc/FreeEsVCLComponents

### Graphic

- OpenGL, GLScene: http://glscene.sourceforge.net
- Computer Vision: OpenCV bindings :https://github.com/Laex/Delphi-OpenCV
- GDI+ : http://sourceforge.net/projects/delphigdiplus/
- Graphics32: http://graphics32.org/wiki/
- DSPack (Direct Show): http://code.google.com/p/dspack/

### ZIP

- 7Zip bindings: http://code.google.com/p/d7zip/

### Utilities

- Castalia Delphi Parser: https://github.com/jacobthurman/Castalia-Delphi-Parser
- GpDelphiUnits: http://code.google.com/p/gpdelphiunits/
- libgit2: https://github.com/libgit2/libgit2

### Tools
- Profiling
  - Sampling Profiler: http://www.delphitools.info/samplingprofiler/
  - source code instrumenting profiler : http://code.google.com/p/gpprofile2011/
  - Spider - Delphi profiler: https://github.com/yavfast/dbg-spider
- ObjectDebugger : run-time Object Inspector for Delphi VCL applications https://github.com/marcocantu/ObjectDebugger
- Delphi IDE Theme Editor: https://code.google.com/p/delphi-ide-theme-editor/
- Delphi Dev. Shell Tools: http://code.google.com/p/delphi-dev-shell-tools/
- OmniPascal VS Code Editor: http://www.omnipascal.com/
- Delphi Find Unit (Import uses): https://github.com/rfrezino/RFindUnit
