/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is specific model that will return the size of the WPE in bytes
    /// </summary>
    [DataContract(Name = "WorkstreamPatternEngineVisionEventsMetadata")]
    public partial class WorkstreamPatternEngineVisionEventsMetadata : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamPatternEngineVisionEventsMetadata" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected WorkstreamPatternEngineVisionEventsMetadata() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamPatternEngineVisionEventsMetadata" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="bytes">bytes (required).</param>
        /// <param name="total">This is the total number of events. (required).</param>
        /// <param name="oldest">oldest.</param>
        /// <param name="newest">newest.</param>
        public WorkstreamPatternEngineVisionEventsMetadata(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ByteDescriptor bytes = default(ByteDescriptor), int total = default(int), WorkstreamPatternEngineVisionEvent oldest = default(WorkstreamPatternEngineVisionEvent), WorkstreamPatternEngineVisionEvent newest = default(WorkstreamPatternEngineVisionEvent))
        {
            // to ensure "bytes" is required (not null)
            if (bytes == null)
            {
                throw new ArgumentNullException("bytes is a required property for WorkstreamPatternEngineVisionEventsMetadata and cannot be null");
            }
            this.Bytes = bytes;
            this.Total = total;
            this.Schema = schema;
            this.Oldest = oldest;
            this.Newest = newest;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Bytes
        /// </summary>
        [DataMember(Name = "bytes", IsRequired = true, EmitDefaultValue = true)]
        public ByteDescriptor Bytes { get; set; }

        /// <summary>
        /// This is the total number of events.
        /// </summary>
        /// <value>This is the total number of events.</value>
        [DataMember(Name = "total", IsRequired = true, EmitDefaultValue = true)]
        public int Total { get; set; }

        /// <summary>
        /// Gets or Sets Oldest
        /// </summary>
        [DataMember(Name = "oldest", EmitDefaultValue = false)]
        public WorkstreamPatternEngineVisionEvent Oldest { get; set; }

        /// <summary>
        /// Gets or Sets Newest
        /// </summary>
        [DataMember(Name = "newest", EmitDefaultValue = false)]
        public WorkstreamPatternEngineVisionEvent Newest { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class WorkstreamPatternEngineVisionEventsMetadata {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Bytes: ").Append(Bytes).Append("\n");
            sb.Append("  Total: ").Append(Total).Append("\n");
            sb.Append("  Oldest: ").Append(Oldest).Append("\n");
            sb.Append("  Newest: ").Append(Newest).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
