/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This model is used for the dimensions of the copilot/feed/xyz window.  if dimensions/captured are null this means we do not have the dimensions for this given window.  TODO: consider adding 5 markers here for the qr codes(ie location of these as wel) NOTE: will want to add type of calibration for this specific dimension(ie copilot/feed/xyz)
    /// </summary>
    [DataContract(Name = "WorkstreamPatternEngineVisionCalibration")]
    public partial class WorkstreamPatternEngineVisionCalibration : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamPatternEngineVisionCalibration" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected WorkstreamPatternEngineVisionCalibration() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamPatternEngineVisionCalibration" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="foreground">This is the name of the window(foreground window).(this will always be present) (required).</param>
        /// <param name="captured">captured.</param>
        /// <param name="dimensions">dimensions.</param>
        public WorkstreamPatternEngineVisionCalibration(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string foreground = default(string), GroupedTimestamp captured = default(GroupedTimestamp), WindowDimensions dimensions = default(WindowDimensions))
        {
            // to ensure "foreground" is required (not null)
            if (foreground == null)
            {
                throw new ArgumentNullException("foreground is a required property for WorkstreamPatternEngineVisionCalibration and cannot be null");
            }
            this.Foreground = foreground;
            this.Schema = schema;
            this.Captured = captured;
            this.Dimensions = dimensions;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This is the name of the window(foreground window).(this will always be present)
        /// </summary>
        /// <value>This is the name of the window(foreground window).(this will always be present)</value>
        [DataMember(Name = "foreground", IsRequired = true, EmitDefaultValue = true)]
        public string Foreground { get; set; }

        /// <summary>
        /// Gets or Sets Captured
        /// </summary>
        [DataMember(Name = "captured", EmitDefaultValue = false)]
        public GroupedTimestamp Captured { get; set; }

        /// <summary>
        /// Gets or Sets Dimensions
        /// </summary>
        [DataMember(Name = "dimensions", EmitDefaultValue = false)]
        public WindowDimensions Dimensions { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class WorkstreamPatternEngineVisionCalibration {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Foreground: ").Append(Foreground).Append("\n");
            sb.Append("  Captured: ").Append(Captured).Append("\n");
            sb.Append("  Dimensions: ").Append(Dimensions).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
