/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the given context for an IDE.  tabs: this here refers to the tabs w/in the IDE.  Modules here are the given repositories  Name: this is the name of a workspace, but not required.
    /// </summary>
    [DataContract(Name = "WorkstreamEventTriggerContextIDE")]
    public partial class WorkstreamEventTriggerContextIDE : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamEventTriggerContextIDE" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="tabs">tabs.</param>
        /// <param name="modules">modules.</param>
        /// <param name="name">name.</param>
        public WorkstreamEventTriggerContextIDE(EmbeddedModelSchema schema = default(EmbeddedModelSchema), IDETabs tabs = default(IDETabs), ProjectModules modules = default(ProjectModules), string name = default(string))
        {
            this.Schema = schema;
            this.Tabs = tabs;
            this.Modules = modules;
            this.Name = name;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Tabs
        /// </summary>
        [DataMember(Name = "tabs", EmitDefaultValue = false)]
        public IDETabs Tabs { get; set; }

        /// <summary>
        /// Gets or Sets Modules
        /// </summary>
        [DataMember(Name = "modules", EmitDefaultValue = false)]
        public ProjectModules Modules { get; set; }

        /// <summary>
        /// Gets or Sets Name
        /// </summary>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class WorkstreamEventTriggerContextIDE {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Tabs: ").Append(Tabs).Append("\n");
            sb.Append("  Modules: ").Append(Modules).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
