/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the specific event that represent the Shadow Activity ie the copy/paste ...xyz
    /// </summary>
    [DataContract(Name = "WorkstreamEventTrigger")]
    public partial class WorkstreamEventTrigger : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamEventTrigger" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="checkIn">this is a sort of check-in event(ie when ever your application is in the forground on there is an interaction).</param>
        /// <param name="copy">copy.</param>
        /// <param name="paste">paste.</param>
        /// <param name="fileOpen">fileOpen.</param>
        /// <param name="fileClose">fileClose.</param>
        /// <param name="tabSwitch">tabSwitch.</param>
        /// <param name="tabClose">tabClose.</param>
        /// <param name="tabOpen">tabOpen.</param>
        /// <param name="tabEnter">tabEnter.</param>
        /// <param name="tabLeave">tabLeave.</param>
        /// <param name="urlChanged">urlChanged.</param>
        /// <param name="applicationEnter">applicationEnter.</param>
        /// <param name="applicationLeave">applicationLeave.</param>
        /// <param name="applicationSwitch">applicationSwitch.</param>
        public WorkstreamEventTrigger(EmbeddedModelSchema schema = default(EmbeddedModelSchema), bool checkIn = default(bool), bool copy = default(bool), bool paste = default(bool), bool fileOpen = default(bool), bool fileClose = default(bool), bool tabSwitch = default(bool), bool tabClose = default(bool), bool tabOpen = default(bool), bool tabEnter = default(bool), bool tabLeave = default(bool), bool urlChanged = default(bool), bool applicationEnter = default(bool), bool applicationLeave = default(bool), bool applicationSwitch = default(bool))
        {
            this.Schema = schema;
            this.CheckIn = checkIn;
            this.Copy = copy;
            this.Paste = paste;
            this.FileOpen = fileOpen;
            this.FileClose = fileClose;
            this.TabSwitch = tabSwitch;
            this.TabClose = tabClose;
            this.TabOpen = tabOpen;
            this.TabEnter = tabEnter;
            this.TabLeave = tabLeave;
            this.UrlChanged = urlChanged;
            this.ApplicationEnter = applicationEnter;
            this.ApplicationLeave = applicationLeave;
            this.ApplicationSwitch = applicationSwitch;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// this is a sort of check-in event(ie when ever your application is in the forground on there is an interaction)
        /// </summary>
        /// <value>this is a sort of check-in event(ie when ever your application is in the forground on there is an interaction)</value>
        [DataMember(Name = "check_in", EmitDefaultValue = true)]
        public bool CheckIn { get; set; }

        /// <summary>
        /// Gets or Sets Copy
        /// </summary>
        [DataMember(Name = "copy", EmitDefaultValue = true)]
        public bool Copy { get; set; }

        /// <summary>
        /// Gets or Sets Paste
        /// </summary>
        [DataMember(Name = "paste", EmitDefaultValue = true)]
        public bool Paste { get; set; }

        /// <summary>
        /// Gets or Sets FileOpen
        /// </summary>
        [DataMember(Name = "file_open", EmitDefaultValue = true)]
        public bool FileOpen { get; set; }

        /// <summary>
        /// Gets or Sets FileClose
        /// </summary>
        [DataMember(Name = "file_close", EmitDefaultValue = true)]
        public bool FileClose { get; set; }

        /// <summary>
        /// Gets or Sets TabSwitch
        /// </summary>
        [DataMember(Name = "tab_switch", EmitDefaultValue = true)]
        public bool TabSwitch { get; set; }

        /// <summary>
        /// Gets or Sets TabClose
        /// </summary>
        [DataMember(Name = "tab_close", EmitDefaultValue = true)]
        public bool TabClose { get; set; }

        /// <summary>
        /// Gets or Sets TabOpen
        /// </summary>
        [DataMember(Name = "tab_open", EmitDefaultValue = true)]
        public bool TabOpen { get; set; }

        /// <summary>
        /// Gets or Sets TabEnter
        /// </summary>
        [DataMember(Name = "tab_enter", EmitDefaultValue = true)]
        public bool TabEnter { get; set; }

        /// <summary>
        /// Gets or Sets TabLeave
        /// </summary>
        [DataMember(Name = "tab_leave", EmitDefaultValue = true)]
        public bool TabLeave { get; set; }

        /// <summary>
        /// Gets or Sets UrlChanged
        /// </summary>
        [DataMember(Name = "url_changed", EmitDefaultValue = true)]
        public bool UrlChanged { get; set; }

        /// <summary>
        /// Gets or Sets ApplicationEnter
        /// </summary>
        [DataMember(Name = "application_enter", EmitDefaultValue = true)]
        public bool ApplicationEnter { get; set; }

        /// <summary>
        /// Gets or Sets ApplicationLeave
        /// </summary>
        [DataMember(Name = "application_leave", EmitDefaultValue = true)]
        public bool ApplicationLeave { get; set; }

        /// <summary>
        /// Gets or Sets ApplicationSwitch
        /// </summary>
        [DataMember(Name = "application_switch", EmitDefaultValue = true)]
        public bool ApplicationSwitch { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class WorkstreamEventTrigger {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  CheckIn: ").Append(CheckIn).Append("\n");
            sb.Append("  Copy: ").Append(Copy).Append("\n");
            sb.Append("  Paste: ").Append(Paste).Append("\n");
            sb.Append("  FileOpen: ").Append(FileOpen).Append("\n");
            sb.Append("  FileClose: ").Append(FileClose).Append("\n");
            sb.Append("  TabSwitch: ").Append(TabSwitch).Append("\n");
            sb.Append("  TabClose: ").Append(TabClose).Append("\n");
            sb.Append("  TabOpen: ").Append(TabOpen).Append("\n");
            sb.Append("  TabEnter: ").Append(TabEnter).Append("\n");
            sb.Append("  TabLeave: ").Append(TabLeave).Append("\n");
            sb.Append("  UrlChanged: ").Append(UrlChanged).Append("\n");
            sb.Append("  ApplicationEnter: ").Append(ApplicationEnter).Append("\n");
            sb.Append("  ApplicationLeave: ").Append(ApplicationLeave).Append("\n");
            sb.Append("  ApplicationSwitch: ").Append(ApplicationSwitch).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
