/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a free form data object that will enable additional data to be passed into SeededWorkstreamEvent, that corresponds to the event on the WorkstreamEvent.  This is a WIP object.  Need to think if we want to do something like raw:string (that is just a jsonObject) that is stringified, or if we add specific bits of data that we want. and specific fields for each event.
    /// </summary>
    [DataContract(Name = "WorkstreamEventContext")]
    public partial class WorkstreamEventContext : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="WorkstreamEventContext" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="ide">ide.</param>
        /// <param name="browser">browser.</param>
        public WorkstreamEventContext(EmbeddedModelSchema schema = default(EmbeddedModelSchema), WorkstreamEventTriggerContextIDE ide = default(WorkstreamEventTriggerContextIDE), WorkstreamEventTriggerContextBrowser browser = default(WorkstreamEventTriggerContextBrowser))
        {
            this.Schema = schema;
            this.Ide = ide;
            this.Browser = browser;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Ide
        /// </summary>
        [DataMember(Name = "ide", EmitDefaultValue = false)]
        public WorkstreamEventTriggerContextIDE Ide { get; set; }

        /// <summary>
        /// Gets or Sets Browser
        /// </summary>
        [DataMember(Name = "browser", EmitDefaultValue = false)]
        public WorkstreamEventTriggerContextBrowser Browser { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class WorkstreamEventContext {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Ide: ").Append(Ide).Append("\n");
            sb.Append("  Browser: ").Append(Browser).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
