/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// note: this is modeled off of the browsers bounding box DOMRect https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect
    /// </summary>
    [DataContract(Name = "WindowDimensions")]
    public partial class WindowDimensions : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="WindowDimensions" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected WindowDimensions() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="WindowDimensions" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="bottom">bottom (required).</param>
        /// <param name="height">height (required).</param>
        /// <param name="left">left (required).</param>
        /// <param name="right">right (required).</param>
        /// <param name="top">top (required).</param>
        /// <param name="width">width (required).</param>
        /// <param name="x">x (required).</param>
        /// <param name="y">y (required).</param>
        public WindowDimensions(EmbeddedModelSchema schema = default(EmbeddedModelSchema), decimal bottom = default(decimal), decimal height = default(decimal), decimal left = default(decimal), decimal right = default(decimal), decimal top = default(decimal), decimal width = default(decimal), decimal x = default(decimal), decimal y = default(decimal))
        {
            this.Bottom = bottom;
            this.Height = height;
            this.Left = left;
            this.Right = right;
            this.Top = top;
            this.Width = width;
            this.X = x;
            this.Y = y;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Bottom
        /// </summary>
        [DataMember(Name = "bottom", IsRequired = true, EmitDefaultValue = true)]
        public decimal Bottom { get; set; }

        /// <summary>
        /// Gets or Sets Height
        /// </summary>
        [DataMember(Name = "height", IsRequired = true, EmitDefaultValue = true)]
        public decimal Height { get; set; }

        /// <summary>
        /// Gets or Sets Left
        /// </summary>
        [DataMember(Name = "left", IsRequired = true, EmitDefaultValue = true)]
        public decimal Left { get; set; }

        /// <summary>
        /// Gets or Sets Right
        /// </summary>
        [DataMember(Name = "right", IsRequired = true, EmitDefaultValue = true)]
        public decimal Right { get; set; }

        /// <summary>
        /// Gets or Sets Top
        /// </summary>
        [DataMember(Name = "top", IsRequired = true, EmitDefaultValue = true)]
        public decimal Top { get; set; }

        /// <summary>
        /// Gets or Sets Width
        /// </summary>
        [DataMember(Name = "width", IsRequired = true, EmitDefaultValue = true)]
        public decimal Width { get; set; }

        /// <summary>
        /// Gets or Sets X
        /// </summary>
        [DataMember(Name = "x", IsRequired = true, EmitDefaultValue = true)]
        public decimal X { get; set; }

        /// <summary>
        /// Gets or Sets Y
        /// </summary>
        [DataMember(Name = "y", IsRequired = true, EmitDefaultValue = true)]
        public decimal Y { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class WindowDimensions {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Bottom: ").Append(Bottom).Append("\n");
            sb.Append("  Height: ").Append(Height).Append("\n");
            sb.Append("  Left: ").Append(Left).Append("\n");
            sb.Append("  Right: ").Append(Right).Append("\n");
            sb.Append("  Top: ").Append(Top).Append("\n");
            sb.Append("  Width: ").Append(Width).Append("\n");
            sb.Append("  X: ").Append(X).Append("\n");
            sb.Append("  Y: ").Append(Y).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
