/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a specific model for related websites to an asset.
    /// </summary>
    [DataContract(Name = "Website")]
    public partial class Website : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Website" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Website() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Website" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">id (required).</param>
        /// <param name="assets">assets.</param>
        /// <param name="url">this is the actual website url. (required).</param>
        /// <param name="name">This is a name that is customized. (required).</param>
        /// <param name="created">created (required).</param>
        /// <param name="updated">updated (required).</param>
        /// <param name="deleted">deleted.</param>
        /// <param name="mechanisms">This is a Map&lt;String, MechanismEnum&gt; where the the key is an asset id..</param>
        /// <param name="interactions">This is an optional value that will keep track of the number of times this has been interacted with..</param>
        /// <param name="persons">persons.</param>
        /// <param name="conversations">conversations.</param>
        /// <param name="score">score.</param>
        /// <param name="summaries">summaries.</param>
        /// <param name="messages">messages.</param>
        public Website(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), FlattenedAssets assets = default(FlattenedAssets), string url = default(string), string name = default(string), GroupedTimestamp created = default(GroupedTimestamp), GroupedTimestamp updated = default(GroupedTimestamp), GroupedTimestamp deleted = default(GroupedTimestamp), Dictionary<string, MechanismEnum> mechanisms = default(Dictionary<string, MechanismEnum>), int interactions = default(int), FlattenedPersons persons = default(FlattenedPersons), FlattenedConversations conversations = default(FlattenedConversations), Score score = default(Score), FlattenedWorkstreamSummaries summaries = default(FlattenedWorkstreamSummaries), FlattenedConversationMessages messages = default(FlattenedConversationMessages))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for Website and cannot be null");
            }
            this.Id = id;
            // to ensure "url" is required (not null)
            if (url == null)
            {
                throw new ArgumentNullException("url is a required property for Website and cannot be null");
            }
            this.Url = url;
            // to ensure "name" is required (not null)
            if (name == null)
            {
                throw new ArgumentNullException("name is a required property for Website and cannot be null");
            }
            this.Name = name;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for Website and cannot be null");
            }
            this.Created = created;
            // to ensure "updated" is required (not null)
            if (updated == null)
            {
                throw new ArgumentNullException("updated is a required property for Website and cannot be null");
            }
            this.Updated = updated;
            this.Schema = schema;
            this.Assets = assets;
            this.Deleted = deleted;
            this.Mechanisms = mechanisms;
            this.Interactions = interactions;
            this.Persons = persons;
            this.Conversations = conversations;
            this.Score = score;
            this.Summaries = summaries;
            this.Messages = messages;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// Gets or Sets Assets
        /// </summary>
        [DataMember(Name = "assets", EmitDefaultValue = false)]
        public FlattenedAssets Assets { get; set; }

        /// <summary>
        /// this is the actual website url.
        /// </summary>
        /// <value>this is the actual website url.</value>
        [DataMember(Name = "url", IsRequired = true, EmitDefaultValue = true)]
        public string Url { get; set; }

        /// <summary>
        /// This is a name that is customized.
        /// </summary>
        /// <value>This is a name that is customized.</value>
        [DataMember(Name = "name", IsRequired = true, EmitDefaultValue = true)]
        public string Name { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Created { get; set; }

        /// <summary>
        /// Gets or Sets Updated
        /// </summary>
        [DataMember(Name = "updated", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Updated { get; set; }

        /// <summary>
        /// Gets or Sets Deleted
        /// </summary>
        [DataMember(Name = "deleted", EmitDefaultValue = false)]
        public GroupedTimestamp Deleted { get; set; }

        /// <summary>
        /// This is a Map&lt;String, MechanismEnum&gt; where the the key is an asset id.
        /// </summary>
        /// <value>This is a Map&lt;String, MechanismEnum&gt; where the the key is an asset id.</value>
        [DataMember(Name = "mechanisms", EmitDefaultValue = false)]
        public Dictionary<string, MechanismEnum> Mechanisms { get; set; }

        /// <summary>
        /// This is an optional value that will keep track of the number of times this has been interacted with.
        /// </summary>
        /// <value>This is an optional value that will keep track of the number of times this has been interacted with.</value>
        [DataMember(Name = "interactions", EmitDefaultValue = false)]
        public int Interactions { get; set; }

        /// <summary>
        /// Gets or Sets Persons
        /// </summary>
        [DataMember(Name = "persons", EmitDefaultValue = false)]
        public FlattenedPersons Persons { get; set; }

        /// <summary>
        /// Gets or Sets Conversations
        /// </summary>
        [DataMember(Name = "conversations", EmitDefaultValue = false)]
        public FlattenedConversations Conversations { get; set; }

        /// <summary>
        /// Gets or Sets Score
        /// </summary>
        [DataMember(Name = "score", EmitDefaultValue = false)]
        public Score Score { get; set; }

        /// <summary>
        /// Gets or Sets Summaries
        /// </summary>
        [DataMember(Name = "summaries", EmitDefaultValue = false)]
        public FlattenedWorkstreamSummaries Summaries { get; set; }

        /// <summary>
        /// Gets or Sets Messages
        /// </summary>
        [DataMember(Name = "messages", EmitDefaultValue = false)]
        public FlattenedConversationMessages Messages { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Website {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Assets: ").Append(Assets).Append("\n");
            sb.Append("  Url: ").Append(Url).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Updated: ").Append(Updated).Append("\n");
            sb.Append("  Deleted: ").Append(Deleted).Append("\n");
            sb.Append("  Mechanisms: ").Append(Mechanisms).Append("\n");
            sb.Append("  Interactions: ").Append(Interactions).Append("\n");
            sb.Append("  Persons: ").Append(Persons).Append("\n");
            sb.Append("  Conversations: ").Append(Conversations).Append("\n");
            sb.Append("  Score: ").Append(Score).Append("\n");
            sb.Append("  Summaries: ").Append(Summaries).Append("\n");
            sb.Append("  Messages: ").Append(Messages).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
