/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This will return is the given path was verified/ or it was invalid.  and if it is valid if it is a file/folder  note: file/directory are both null.
    /// </summary>
    [DataContract(Name = "VerifiedOSFilesystemPath")]
    public partial class VerifiedOSFilesystemPath : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="VerifiedOSFilesystemPath" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected VerifiedOSFilesystemPath() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="VerifiedOSFilesystemPath" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="path">path (required).</param>
        /// <param name="file">file.</param>
        /// <param name="directory">directory.</param>
        /// <param name="verified">This means if the path(file/folder) exists on the machine. (required).</param>
        /// <param name="denied">This means that attempting to access the file was not aloud(ie no permission).</param>
        /// <param name="bytes">bytes.</param>
        public VerifiedOSFilesystemPath(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string path = default(string), bool file = default(bool), bool directory = default(bool), bool verified = default(bool), bool denied = default(bool), ByteDescriptor bytes = default(ByteDescriptor))
        {
            // to ensure "path" is required (not null)
            if (path == null)
            {
                throw new ArgumentNullException("path is a required property for VerifiedOSFilesystemPath and cannot be null");
            }
            this.Path = path;
            this.Verified = verified;
            this.Schema = schema;
            this.File = file;
            this.Directory = directory;
            this.Denied = denied;
            this.Bytes = bytes;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Path
        /// </summary>
        [DataMember(Name = "path", IsRequired = true, EmitDefaultValue = true)]
        public string Path { get; set; }

        /// <summary>
        /// Gets or Sets File
        /// </summary>
        [DataMember(Name = "file", EmitDefaultValue = true)]
        public bool File { get; set; }

        /// <summary>
        /// Gets or Sets Directory
        /// </summary>
        [DataMember(Name = "directory", EmitDefaultValue = true)]
        public bool Directory { get; set; }

        /// <summary>
        /// This means if the path(file/folder) exists on the machine.
        /// </summary>
        /// <value>This means if the path(file/folder) exists on the machine.</value>
        [DataMember(Name = "verified", IsRequired = true, EmitDefaultValue = true)]
        public bool Verified { get; set; }

        /// <summary>
        /// This means that attempting to access the file was not aloud(ie no permission)
        /// </summary>
        /// <value>This means that attempting to access the file was not aloud(ie no permission)</value>
        [DataMember(Name = "denied", EmitDefaultValue = true)]
        public bool Denied { get; set; }

        /// <summary>
        /// Gets or Sets Bytes
        /// </summary>
        [DataMember(Name = "bytes", EmitDefaultValue = false)]
        public ByteDescriptor Bytes { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class VerifiedOSFilesystemPath {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Path: ").Append(Path).Append("\n");
            sb.Append("  File: ").Append(File).Append("\n");
            sb.Append("  Directory: ").Append(Directory).Append("\n");
            sb.Append("  Verified: ").Append(Verified).Append("\n");
            sb.Append("  Denied: ").Append(Denied).Append("\n");
            sb.Append("  Bytes: ").Append(Bytes).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
