/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the model for a user logged into Pieces.
    /// </summary>
    [DataContract(Name = "UserProfile")]
    public partial class UserProfile : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="UserProfile" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected UserProfile() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="UserProfile" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="picture">mapped from picture.URL pointing to the user&#39;s profile picture.  (default to &quot;https://picsum.photos/200&quot;).</param>
        /// <param name="email">email (default to &quot;user@pieces.app&quot;).</param>
        /// <param name="created">created.</param>
        /// <param name="updated">updated.</param>
        /// <param name="username"> (unique) User&#39;s username.  .</param>
        /// <param name="id">id (required).</param>
        /// <param name="name">This is the name of the User..</param>
        /// <param name="aesthetics">aesthetics (required).</param>
        /// <param name="vanityname">vanityname.</param>
        /// <param name="allocation">allocation.</param>
        /// <param name="providers">providers.</param>
        /// <param name="auth0">auth0.</param>
        public UserProfile(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string picture = @"https://picsum.photos/200", string email = @"user@pieces.app", GroupedTimestamp created = default(GroupedTimestamp), GroupedTimestamp updated = default(GroupedTimestamp), string username = default(string), string id = default(string), string name = default(string), Aesthetics aesthetics = default(Aesthetics), string vanityname = default(string), AllocationCloud allocation = default(AllocationCloud), ExternalProviders providers = default(ExternalProviders), Auth0UserMetadata auth0 = default(Auth0UserMetadata))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for UserProfile and cannot be null");
            }
            this.Id = id;
            // to ensure "aesthetics" is required (not null)
            if (aesthetics == null)
            {
                throw new ArgumentNullException("aesthetics is a required property for UserProfile and cannot be null");
            }
            this.Aesthetics = aesthetics;
            this.Schema = schema;
            // use default value if no "picture" provided
            this.Picture = picture ?? @"https://picsum.photos/200";
            // use default value if no "email" provided
            this.Email = email ?? @"user@pieces.app";
            this.Created = created;
            this.Updated = updated;
            this.Username = username;
            this.Name = name;
            this.Vanityname = vanityname;
            this.Allocation = allocation;
            this.Providers = providers;
            this.Auth0 = auth0;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// mapped from picture.URL pointing to the user&#39;s profile picture. 
        /// </summary>
        /// <value>mapped from picture.URL pointing to the user&#39;s profile picture. </value>
        /*
        <example>https://picsum.photos/200</example>
        */
        [DataMember(Name = "picture", EmitDefaultValue = false)]
        public string Picture { get; set; }

        /// <summary>
        /// Gets or Sets Email
        /// </summary>
        /*
        <example>user@pieces.app</example>
        */
        [DataMember(Name = "email", EmitDefaultValue = false)]
        public string Email { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", EmitDefaultValue = false)]
        public GroupedTimestamp Created { get; set; }

        /// <summary>
        /// Gets or Sets Updated
        /// </summary>
        [DataMember(Name = "updated", EmitDefaultValue = false)]
        public GroupedTimestamp Updated { get; set; }

        /// <summary>
        ///  (unique) User&#39;s username.  
        /// </summary>
        /// <value> (unique) User&#39;s username.  </value>
        [DataMember(Name = "username", EmitDefaultValue = false)]
        public string Username { get; set; }

        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// This is the name of the User.
        /// </summary>
        /// <value>This is the name of the User.</value>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// Gets or Sets Aesthetics
        /// </summary>
        [DataMember(Name = "aesthetics", IsRequired = true, EmitDefaultValue = true)]
        public Aesthetics Aesthetics { get; set; }

        /// <summary>
        /// Gets or Sets Vanityname
        /// </summary>
        [DataMember(Name = "vanityname", EmitDefaultValue = false)]
        public string Vanityname { get; set; }

        /// <summary>
        /// Gets or Sets Allocation
        /// </summary>
        [DataMember(Name = "allocation", EmitDefaultValue = false)]
        public AllocationCloud Allocation { get; set; }

        /// <summary>
        /// Gets or Sets Providers
        /// </summary>
        [DataMember(Name = "providers", EmitDefaultValue = false)]
        public ExternalProviders Providers { get; set; }

        /// <summary>
        /// Gets or Sets Auth0
        /// </summary>
        [DataMember(Name = "auth0", EmitDefaultValue = false)]
        public Auth0UserMetadata Auth0 { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class UserProfile {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Picture: ").Append(Picture).Append("\n");
            sb.Append("  Email: ").Append(Email).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Updated: ").Append(Updated).Append("\n");
            sb.Append("  Username: ").Append(Username).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Aesthetics: ").Append(Aesthetics).Append("\n");
            sb.Append("  Vanityname: ").Append(Vanityname).Append("\n");
            sb.Append("  Allocation: ").Append(Allocation).Append("\n");
            sb.Append("  Providers: ").Append(Providers).Append("\n");
            sb.Append("  Auth0: ").Append(Auth0).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
