/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is used to either grant or remove a specific provider betastatus
    /// </summary>
    [DataContract(Name = "UserBetaStatus")]
    public partial class UserBetaStatus : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="UserBetaStatus" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected UserBetaStatus() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="UserBetaStatus" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="auth0">auth0.</param>
        /// <param name="user">user (required).</param>
        public UserBetaStatus(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Auth0UserBetaStatus auth0 = default(Auth0UserBetaStatus), string user = default(string))
        {
            // to ensure "user" is required (not null)
            if (user == null)
            {
                throw new ArgumentNullException("user is a required property for UserBetaStatus and cannot be null");
            }
            this.User = user;
            this.Schema = schema;
            this.Auth0 = auth0;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Auth0
        /// </summary>
        [DataMember(Name = "auth0", EmitDefaultValue = false)]
        public Auth0UserBetaStatus Auth0 { get; set; }

        /// <summary>
        /// Gets or Sets User
        /// </summary>
        [DataMember(Name = "user", IsRequired = true, EmitDefaultValue = true)]
        public string User { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class UserBetaStatus {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Auth0: ").Append(Auth0).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
