/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// A user that will be passed along with each analytics event
    /// </summary>
    [DataContract(Name = "TrackedUserProfile")]
    public partial class TrackedUserProfile : IValidatableObject
    {
        /// <summary>
        /// At what level is this user being tracked.
        /// </summary>
        /// <value>At what level is this user being tracked.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum GranularityEnum
        {
            /// <summary>
            /// Enum DEVICE for value: DEVICE
            /// </summary>
            [EnumMember(Value = "DEVICE")]
            DEVICE = 1,

            /// <summary>
            /// Enum ACCOUNT for value: ACCOUNT
            /// </summary>
            [EnumMember(Value = "ACCOUNT")]
            ACCOUNT = 2,

            /// <summary>
            /// Enum ANONYMOUS for value: ANONYMOUS
            /// </summary>
            [EnumMember(Value = "ANONYMOUS")]
            ANONYMOUS = 3
        }


        /// <summary>
        /// At what level is this user being tracked.
        /// </summary>
        /// <value>At what level is this user being tracked.</value>
        [DataMember(Name = "granularity", IsRequired = true, EmitDefaultValue = true)]
        public GranularityEnum Granularity { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedUserProfile" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TrackedUserProfile() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedUserProfile" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">The ID of the user that you are tracking. (required).</param>
        /// <param name="username">This is a username that is attempted to be assigned but is \&quot;Anonymous User\&quot; by default (required) (default to &quot;unknown&quot;).</param>
        /// <param name="email">The user&#39;s email if we have it..</param>
        /// <param name="granularity">At what level is this user being tracked. (required) (default to GranularityEnum.ANONYMOUS).</param>
        public TrackedUserProfile(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Guid id = default(Guid), string username = @"unknown", string email = default(string), GranularityEnum granularity = GranularityEnum.ANONYMOUS)
        {
            this.Id = id;
            // to ensure "username" is required (not null)
            if (username == null)
            {
                throw new ArgumentNullException("username is a required property for TrackedUserProfile and cannot be null");
            }
            this.Username = username;
            this.Granularity = granularity;
            this.Schema = schema;
            this.Email = email;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// The ID of the user that you are tracking.
        /// </summary>
        /// <value>The ID of the user that you are tracking.</value>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public Guid Id { get; set; }

        /// <summary>
        /// This is a username that is attempted to be assigned but is \&quot;Anonymous User\&quot; by default
        /// </summary>
        /// <value>This is a username that is attempted to be assigned but is \&quot;Anonymous User\&quot; by default</value>
        [DataMember(Name = "username", IsRequired = true, EmitDefaultValue = true)]
        public string Username { get; set; }

        /// <summary>
        /// The user&#39;s email if we have it.
        /// </summary>
        /// <value>The user&#39;s email if we have it.</value>
        [DataMember(Name = "email", EmitDefaultValue = false)]
        public string Email { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedUserProfile {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Username: ").Append(Username).Append("\n");
            sb.Append("  Email: ").Append(Email).Append("\n");
            sb.Append("  Granularity: ").Append(Granularity).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
