/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the counts of things that users can add.
    /// </summary>
    [DataContract(Name = "TrackedSummaryTotals")]
    public partial class TrackedSummaryTotals : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedSummaryTotals" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TrackedSummaryTotals() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedSummaryTotals" /> class.
        /// </summary>
        /// <param name="assets">assets (required).</param>
        /// <param name="tags">tags (required).</param>
        /// <param name="websites">websites (required).</param>
        /// <param name="persons">persons (required).</param>
        /// <param name="sensitives">sensitives (required).</param>
        /// <param name="shares">shares (required).</param>
        /// <param name="copilotSends">copilotSends (required).</param>
        /// <param name="copilotReceives">copilotReceives (required).</param>
        /// <param name="copilotSessions">copilotSessions (required).</param>
        /// <param name="copilotConversations">copilotConversations (required).</param>
        /// <param name="productivityScore">productivityScore (required).</param>
        /// <param name="searches">searches (required).</param>
        /// <param name="references">references (required).</param>
        /// <param name="reuses">reuses (required).</param>
        /// <param name="anchorFiles">anchorFiles (required).</param>
        /// <param name="anchorFolders">anchorFolders (required).</param>
        /// <param name="isrReports">isrReports (required).</param>
        /// <param name="requests">requests.</param>
        public TrackedSummaryTotals(int assets = default(int), int tags = default(int), int websites = default(int), int persons = default(int), int sensitives = default(int), int shares = default(int), int copilotSends = default(int), int copilotReceives = default(int), int copilotSessions = default(int), int copilotConversations = default(int), int productivityScore = default(int), int searches = default(int), int references = default(int), int reuses = default(int), int anchorFiles = default(int), int anchorFolders = default(int), int isrReports = default(int), int? requests = default(int?))
        {
            this.Assets = assets;
            this.Tags = tags;
            this.Websites = websites;
            this.Persons = persons;
            this.Sensitives = sensitives;
            this.Shares = shares;
            this.CopilotSends = copilotSends;
            this.CopilotReceives = copilotReceives;
            this.CopilotSessions = copilotSessions;
            this.CopilotConversations = copilotConversations;
            this.ProductivityScore = productivityScore;
            this.Searches = searches;
            this.References = references;
            this.Reuses = reuses;
            this.AnchorFiles = anchorFiles;
            this.AnchorFolders = anchorFolders;
            this.IsrReports = isrReports;
            this.Requests = requests;
        }

        /// <summary>
        /// Gets or Sets Assets
        /// </summary>
        [DataMember(Name = "assets", IsRequired = true, EmitDefaultValue = true)]
        public int Assets { get; set; }

        /// <summary>
        /// Gets or Sets Tags
        /// </summary>
        [DataMember(Name = "tags", IsRequired = true, EmitDefaultValue = true)]
        public int Tags { get; set; }

        /// <summary>
        /// Gets or Sets Websites
        /// </summary>
        [DataMember(Name = "websites", IsRequired = true, EmitDefaultValue = true)]
        public int Websites { get; set; }

        /// <summary>
        /// Gets or Sets Persons
        /// </summary>
        [DataMember(Name = "persons", IsRequired = true, EmitDefaultValue = true)]
        public int Persons { get; set; }

        /// <summary>
        /// Gets or Sets Sensitives
        /// </summary>
        [DataMember(Name = "sensitives", IsRequired = true, EmitDefaultValue = true)]
        public int Sensitives { get; set; }

        /// <summary>
        /// Gets or Sets Shares
        /// </summary>
        [DataMember(Name = "shares", IsRequired = true, EmitDefaultValue = true)]
        public int Shares { get; set; }

        /// <summary>
        /// Gets or Sets CopilotSends
        /// </summary>
        [DataMember(Name = "copilot_sends", IsRequired = true, EmitDefaultValue = true)]
        public int CopilotSends { get; set; }

        /// <summary>
        /// Gets or Sets CopilotReceives
        /// </summary>
        [DataMember(Name = "copilot_receives", IsRequired = true, EmitDefaultValue = true)]
        public int CopilotReceives { get; set; }

        /// <summary>
        /// Gets or Sets CopilotSessions
        /// </summary>
        [DataMember(Name = "copilot_sessions", IsRequired = true, EmitDefaultValue = true)]
        public int CopilotSessions { get; set; }

        /// <summary>
        /// Gets or Sets CopilotConversations
        /// </summary>
        [DataMember(Name = "copilot_conversations", IsRequired = true, EmitDefaultValue = true)]
        public int CopilotConversations { get; set; }

        /// <summary>
        /// Gets or Sets ProductivityScore
        /// </summary>
        [DataMember(Name = "productivity_score", IsRequired = true, EmitDefaultValue = true)]
        public int ProductivityScore { get; set; }

        /// <summary>
        /// Gets or Sets Searches
        /// </summary>
        [DataMember(Name = "searches", IsRequired = true, EmitDefaultValue = true)]
        public int Searches { get; set; }

        /// <summary>
        /// Gets or Sets References
        /// </summary>
        [DataMember(Name = "references", IsRequired = true, EmitDefaultValue = true)]
        public int References { get; set; }

        /// <summary>
        /// Gets or Sets Reuses
        /// </summary>
        [DataMember(Name = "reuses", IsRequired = true, EmitDefaultValue = true)]
        public int Reuses { get; set; }

        /// <summary>
        /// Gets or Sets AnchorFiles
        /// </summary>
        [DataMember(Name = "anchor_files", IsRequired = true, EmitDefaultValue = true)]
        public int AnchorFiles { get; set; }

        /// <summary>
        /// Gets or Sets AnchorFolders
        /// </summary>
        [DataMember(Name = "anchor_folders", IsRequired = true, EmitDefaultValue = true)]
        public int AnchorFolders { get; set; }

        /// <summary>
        /// Gets or Sets IsrReports
        /// </summary>
        [DataMember(Name = "isr_reports", IsRequired = true, EmitDefaultValue = true)]
        public int IsrReports { get; set; }

        /// <summary>
        /// Gets or Sets Requests
        /// </summary>
        [DataMember(Name = "requests", EmitDefaultValue = true)]
        public int? Requests { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedSummaryTotals {\n");
            sb.Append("  Assets: ").Append(Assets).Append("\n");
            sb.Append("  Tags: ").Append(Tags).Append("\n");
            sb.Append("  Websites: ").Append(Websites).Append("\n");
            sb.Append("  Persons: ").Append(Persons).Append("\n");
            sb.Append("  Sensitives: ").Append(Sensitives).Append("\n");
            sb.Append("  Shares: ").Append(Shares).Append("\n");
            sb.Append("  CopilotSends: ").Append(CopilotSends).Append("\n");
            sb.Append("  CopilotReceives: ").Append(CopilotReceives).Append("\n");
            sb.Append("  CopilotSessions: ").Append(CopilotSessions).Append("\n");
            sb.Append("  CopilotConversations: ").Append(CopilotConversations).Append("\n");
            sb.Append("  ProductivityScore: ").Append(ProductivityScore).Append("\n");
            sb.Append("  Searches: ").Append(Searches).Append("\n");
            sb.Append("  References: ").Append(References).Append("\n");
            sb.Append("  Reuses: ").Append(Reuses).Append("\n");
            sb.Append("  AnchorFiles: ").Append(AnchorFiles).Append("\n");
            sb.Append("  AnchorFolders: ").Append(AnchorFolders).Append("\n");
            sb.Append("  IsrReports: ").Append(IsrReports).Append("\n");
            sb.Append("  Requests: ").Append(Requests).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
