/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a model that allows us to send send over super specific format related events such as copied, deleted, downloaded, etc
    /// </summary>
    [DataContract(Name = "TrackedFormatEventIdentifierDescriptionPairs")]
    public partial class TrackedFormatEventIdentifierDescriptionPairs : IValidatableObject
    {
        /// <summary>
        /// The key value pair for an asset being created.
        /// </summary>
        /// <value>The key value pair for an asset being created.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatCreatedEnum
        {
            /// <summary>
            /// Enum AFormatWasCreated for value: a_format_was_created
            /// </summary>
            [EnumMember(Value = "a_format_was_created")]
            AFormatWasCreated = 1
        }


        /// <summary>
        /// The key value pair for an asset being created.
        /// </summary>
        /// <value>The key value pair for an asset being created.</value>
        [DataMember(Name = "format_created", EmitDefaultValue = false)]
        public FormatCreatedEnum? FormatCreated { get; set; }
        /// <summary>
        /// If a format was copied entirely
        /// </summary>
        /// <value>If a format was copied entirely</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatCopiedEnum
        {
            /// <summary>
            /// Enum IfAFormatWasEntirelyCopied for value: if_a_format_was_entirely_copied
            /// </summary>
            [EnumMember(Value = "if_a_format_was_entirely_copied")]
            IfAFormatWasEntirelyCopied = 1
        }


        /// <summary>
        /// If a format was copied entirely
        /// </summary>
        /// <value>If a format was copied entirely</value>
        [DataMember(Name = "format_copied", EmitDefaultValue = false)]
        public FormatCopiedEnum? FormatCopied { get; set; }
        /// <summary>
        /// If a format was copied partially
        /// </summary>
        /// <value>If a format was copied partially</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatPartiallyCopiedEnum
        {
            /// <summary>
            /// Enum IfAFormatWasPartiallyCopied for value: if_a_format_was_partially_copied
            /// </summary>
            [EnumMember(Value = "if_a_format_was_partially_copied")]
            IfAFormatWasPartiallyCopied = 1
        }


        /// <summary>
        /// If a format was copied partially
        /// </summary>
        /// <value>If a format was copied partially</value>
        [DataMember(Name = "format_partially_copied", EmitDefaultValue = false)]
        public FormatPartiallyCopiedEnum? FormatPartiallyCopied { get; set; }
        /// <summary>
        /// If a format was downloaded
        /// </summary>
        /// <value>If a format was downloaded</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatDownloadedEnum
        {
            /// <summary>
            /// Enum IfAFormatWasDownloaded for value: if_a_format_was_downloaded
            /// </summary>
            [EnumMember(Value = "if_a_format_was_downloaded")]
            IfAFormatWasDownloaded = 1
        }


        /// <summary>
        /// If a format was downloaded
        /// </summary>
        /// <value>If a format was downloaded</value>
        [DataMember(Name = "format_downloaded", EmitDefaultValue = false)]
        public FormatDownloadedEnum? FormatDownloaded { get; set; }
        /// <summary>
        /// If an format was deleted
        /// </summary>
        /// <value>If an format was deleted</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatDeletedEnum
        {
            /// <summary>
            /// Enum IfAFormatWasDeleted for value: if_a_format_was_deleted
            /// </summary>
            [EnumMember(Value = "if_a_format_was_deleted")]
            IfAFormatWasDeleted = 1
        }


        /// <summary>
        /// If an format was deleted
        /// </summary>
        /// <value>If an format was deleted</value>
        [DataMember(Name = "format_deleted", EmitDefaultValue = false)]
        public FormatDeletedEnum? FormatDeleted { get; set; }
        /// <summary>
        /// If a generic classification was changed on a format
        /// </summary>
        /// <value>If a generic classification was changed on a format</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatGenericClassificationUpdatedEnum
        {
            /// <summary>
            /// Enum IfAGenericClassificationWasChangedOnAFormat for value: if_a_generic_classification_was_changed_on_a_format
            /// </summary>
            [EnumMember(Value = "if_a_generic_classification_was_changed_on_a_format")]
            IfAGenericClassificationWasChangedOnAFormat = 1
        }


        /// <summary>
        /// If a generic classification was changed on a format
        /// </summary>
        /// <value>If a generic classification was changed on a format</value>
        [DataMember(Name = "format_generic_classification_updated", EmitDefaultValue = false)]
        public FormatGenericClassificationUpdatedEnum? FormatGenericClassificationUpdated { get; set; }
        /// <summary>
        /// If a specific classification was changed on a format
        /// </summary>
        /// <value>If a specific classification was changed on a format</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatSpecificClassificationUpdatedEnum
        {
            /// <summary>
            /// Enum IfASpecificClassificationWasChangedOnAFormat for value: if_a_specific_classification_was_changed_on_a_format
            /// </summary>
            [EnumMember(Value = "if_a_specific_classification_was_changed_on_a_format")]
            IfASpecificClassificationWasChangedOnAFormat = 1
        }


        /// <summary>
        /// If a specific classification was changed on a format
        /// </summary>
        /// <value>If a specific classification was changed on a format</value>
        [DataMember(Name = "format_specific_classification_updated", EmitDefaultValue = false)]
        public FormatSpecificClassificationUpdatedEnum? FormatSpecificClassificationUpdated { get; set; }
        /// <summary>
        /// a format was updated, generic update.
        /// </summary>
        /// <value>a format was updated, generic update.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatUpdatedEnum
        {
            /// <summary>
            /// Enum AFormatWasUpdated for value: a_format_was_updated
            /// </summary>
            [EnumMember(Value = "a_format_was_updated")]
            AFormatWasUpdated = 1
        }


        /// <summary>
        /// a format was updated, generic update.
        /// </summary>
        /// <value>a format was updated, generic update.</value>
        [DataMember(Name = "format_updated", EmitDefaultValue = false)]
        public FormatUpdatedEnum? FormatUpdated { get; set; }
        /// <summary>
        /// a format was inserted
        /// </summary>
        /// <value>a format was inserted</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatInsertedEnum
        {
            /// <summary>
            /// Enum AFormatWasInserted for value: a_format_was_inserted
            /// </summary>
            [EnumMember(Value = "a_format_was_inserted")]
            AFormatWasInserted = 1
        }


        /// <summary>
        /// a format was inserted
        /// </summary>
        /// <value>a format was inserted</value>
        [DataMember(Name = "format_inserted", EmitDefaultValue = false)]
        public FormatInsertedEnum? FormatInserted { get; set; }
        /// <summary>
        /// a format&#39;s value was update ie, the text, etc...
        /// </summary>
        /// <value>a format&#39;s value was update ie, the text, etc...</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum FormatValueEditedEnum
        {
            /// <summary>
            /// Enum AFormatValueWasEdited for value: a_format_value_was_edited
            /// </summary>
            [EnumMember(Value = "a_format_value_was_edited")]
            AFormatValueWasEdited = 1
        }


        /// <summary>
        /// a format&#39;s value was update ie, the text, etc...
        /// </summary>
        /// <value>a format&#39;s value was update ie, the text, etc...</value>
        [DataMember(Name = "format_value_edited", EmitDefaultValue = false)]
        public FormatValueEditedEnum? FormatValueEdited { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedFormatEventIdentifierDescriptionPairs" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="formatCreated">The key value pair for an asset being created..</param>
        /// <param name="formatCopied">If a format was copied entirely.</param>
        /// <param name="formatPartiallyCopied">If a format was copied partially.</param>
        /// <param name="formatDownloaded">If a format was downloaded.</param>
        /// <param name="formatDeleted">If an format was deleted.</param>
        /// <param name="formatGenericClassificationUpdated">If a generic classification was changed on a format.</param>
        /// <param name="formatSpecificClassificationUpdated">If a specific classification was changed on a format.</param>
        /// <param name="formatUpdated">a format was updated, generic update..</param>
        /// <param name="formatInserted">a format was inserted.</param>
        /// <param name="formatValueEdited">a format&#39;s value was update ie, the text, etc....</param>
        public TrackedFormatEventIdentifierDescriptionPairs(EmbeddedModelSchema schema = default(EmbeddedModelSchema), FormatCreatedEnum? formatCreated = default(FormatCreatedEnum?), FormatCopiedEnum? formatCopied = default(FormatCopiedEnum?), FormatPartiallyCopiedEnum? formatPartiallyCopied = default(FormatPartiallyCopiedEnum?), FormatDownloadedEnum? formatDownloaded = default(FormatDownloadedEnum?), FormatDeletedEnum? formatDeleted = default(FormatDeletedEnum?), FormatGenericClassificationUpdatedEnum? formatGenericClassificationUpdated = default(FormatGenericClassificationUpdatedEnum?), FormatSpecificClassificationUpdatedEnum? formatSpecificClassificationUpdated = default(FormatSpecificClassificationUpdatedEnum?), FormatUpdatedEnum? formatUpdated = default(FormatUpdatedEnum?), FormatInsertedEnum? formatInserted = default(FormatInsertedEnum?), FormatValueEditedEnum? formatValueEdited = default(FormatValueEditedEnum?))
        {
            this.Schema = schema;
            this.FormatCreated = formatCreated;
            this.FormatCopied = formatCopied;
            this.FormatPartiallyCopied = formatPartiallyCopied;
            this.FormatDownloaded = formatDownloaded;
            this.FormatDeleted = formatDeleted;
            this.FormatGenericClassificationUpdated = formatGenericClassificationUpdated;
            this.FormatSpecificClassificationUpdated = formatSpecificClassificationUpdated;
            this.FormatUpdated = formatUpdated;
            this.FormatInserted = formatInserted;
            this.FormatValueEdited = formatValueEdited;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedFormatEventIdentifierDescriptionPairs {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  FormatCreated: ").Append(FormatCreated).Append("\n");
            sb.Append("  FormatCopied: ").Append(FormatCopied).Append("\n");
            sb.Append("  FormatPartiallyCopied: ").Append(FormatPartiallyCopied).Append("\n");
            sb.Append("  FormatDownloaded: ").Append(FormatDownloaded).Append("\n");
            sb.Append("  FormatDeleted: ").Append(FormatDeleted).Append("\n");
            sb.Append("  FormatGenericClassificationUpdated: ").Append(FormatGenericClassificationUpdated).Append("\n");
            sb.Append("  FormatSpecificClassificationUpdated: ").Append(FormatSpecificClassificationUpdated).Append("\n");
            sb.Append("  FormatUpdated: ").Append(FormatUpdated).Append("\n");
            sb.Append("  FormatInserted: ").Append(FormatInserted).Append("\n");
            sb.Append("  FormatValueEdited: ").Append(FormatValueEdited).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
