/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a model that represents a generic event that we may want to track in relation to a format, for example beamed, copied, downloaded, and view. ** Note: This is the model that will get returned by our api, and is. Representative of a full TrackedFormat event. **
    /// </summary>
    [DataContract(Name = "TrackedFormatEvent")]
    public partial class TrackedFormatEvent : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedFormatEvent" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TrackedFormatEvent() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedFormatEvent" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="format">format (required).</param>
        /// <param name="identifierDescriptionPair">identifierDescriptionPair (required).</param>
        /// <param name="metadata">metadata.</param>
        public TrackedFormatEvent(EmbeddedModelSchema schema = default(EmbeddedModelSchema), TrackedFormat format = default(TrackedFormat), TrackedFormatEventIdentifierDescriptionPairs identifierDescriptionPair = default(TrackedFormatEventIdentifierDescriptionPairs), TrackedFormatEventMetadata metadata = default(TrackedFormatEventMetadata))
        {
            // to ensure "format" is required (not null)
            if (format == null)
            {
                throw new ArgumentNullException("format is a required property for TrackedFormatEvent and cannot be null");
            }
            this.Format = format;
            // to ensure "identifierDescriptionPair" is required (not null)
            if (identifierDescriptionPair == null)
            {
                throw new ArgumentNullException("identifierDescriptionPair is a required property for TrackedFormatEvent and cannot be null");
            }
            this.IdentifierDescriptionPair = identifierDescriptionPair;
            this.Schema = schema;
            this.Metadata = metadata;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Format
        /// </summary>
        [DataMember(Name = " format", IsRequired = true, EmitDefaultValue = true)]
        public TrackedFormat Format { get; set; }

        /// <summary>
        /// Gets or Sets IdentifierDescriptionPair
        /// </summary>
        [DataMember(Name = "identifier_description_pair", IsRequired = true, EmitDefaultValue = true)]
        public TrackedFormatEventIdentifierDescriptionPairs IdentifierDescriptionPair { get; set; }

        /// <summary>
        /// Gets or Sets Metadata
        /// </summary>
        [DataMember(Name = "metadata", EmitDefaultValue = false)]
        public TrackedFormatEventMetadata Metadata { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedFormatEvent {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Format: ").Append(Format).Append("\n");
            sb.Append("  IdentifierDescriptionPair: ").Append(IdentifierDescriptionPair).Append("\n");
            sb.Append("  Metadata: ").Append(Metadata).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
