/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// A minimal format to send to Mixpanel
    /// </summary>
    [DataContract(Name = "TrackedFormat")]
    public partial class TrackedFormat : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Role
        /// </summary>
        [DataMember(Name = "role", IsRequired = true, EmitDefaultValue = true)]
        public Role Role { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedFormat" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TrackedFormat() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedFormat" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">The UUID of the format (required).</param>
        /// <param name="classification">classification (required).</param>
        /// <param name="role">role (required).</param>
        /// <param name="asset">The UUID of the asset associated (required).</param>
        /// <param name="fragment">fragment (required).</param>
        /// <param name="file">file (required).</param>
        public TrackedFormat(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), Classification classification = default(Classification), Role role = default(Role), string asset = default(string), bool fragment = default(bool), bool file = default(bool))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for TrackedFormat and cannot be null");
            }
            this.Id = id;
            // to ensure "classification" is required (not null)
            if (classification == null)
            {
                throw new ArgumentNullException("classification is a required property for TrackedFormat and cannot be null");
            }
            this.Classification = classification;
            this.Role = role;
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for TrackedFormat and cannot be null");
            }
            this.Asset = asset;
            this.Fragment = fragment;
            this.File = file;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// The UUID of the format
        /// </summary>
        /// <value>The UUID of the format</value>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// Gets or Sets Classification
        /// </summary>
        [DataMember(Name = "classification", IsRequired = true, EmitDefaultValue = true)]
        public Classification Classification { get; set; }

        /// <summary>
        /// The UUID of the asset associated
        /// </summary>
        /// <value>The UUID of the asset associated</value>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public string Asset { get; set; }

        /// <summary>
        /// Gets or Sets Fragment
        /// </summary>
        [DataMember(Name = "fragment", IsRequired = true, EmitDefaultValue = true)]
        public bool Fragment { get; set; }

        /// <summary>
        /// Gets or Sets File
        /// </summary>
        [DataMember(Name = "file", IsRequired = true, EmitDefaultValue = true)]
        public bool File { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedFormat {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Classification: ").Append(Classification).Append("\n");
            sb.Append("  Role: ").Append(Role).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Fragment: ").Append(Fragment).Append("\n");
            sb.Append("  File: ").Append(File).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
