/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// These are all of the available event types that are permitted in an object pair notation.
    /// </summary>
    [DataContract(Name = "TrackedConversationEventIdentifierDescriptionPairs")]
    public partial class TrackedConversationEventIdentifierDescriptionPairs : IValidatableObject
    {
        /// <summary>
        /// The key value pair for an conversation being created.
        /// </summary>
        /// <value>The key value pair for an conversation being created.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ConversationCreatedEnum
        {
            /// <summary>
            /// Enum AConversationWasCreated for value: a_conversation_was_created
            /// </summary>
            [EnumMember(Value = "a_conversation_was_created")]
            AConversationWasCreated = 1
        }


        /// <summary>
        /// The key value pair for an conversation being created.
        /// </summary>
        /// <value>The key value pair for an conversation being created.</value>
        [DataMember(Name = "conversation_created", EmitDefaultValue = false)]
        public ConversationCreatedEnum? ConversationCreated { get; set; }
        /// <summary>
        /// This means that an conversation was view/used while the user was looking at the default view.
        /// </summary>
        /// <value>This means that an conversation was view/used while the user was looking at the default view.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ConversationReferencedEnum
        {
            /// <summary>
            /// Enum AConversationWasReferencedByTheUser for value: a_conversation_was_referenced_by_the_user
            /// </summary>
            [EnumMember(Value = "a_conversation_was_referenced_by_the_user")]
            AConversationWasReferencedByTheUser = 1
        }


        /// <summary>
        /// This means that an conversation was view/used while the user was looking at the default view.
        /// </summary>
        /// <value>This means that an conversation was view/used while the user was looking at the default view.</value>
        [DataMember(Name = "conversation_referenced", EmitDefaultValue = false)]
        public ConversationReferencedEnum? ConversationReferenced { get; set; }
        /// <summary>
        /// A conversation was deleted
        /// </summary>
        /// <value>A conversation was deleted</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ConversationDeletedEnum
        {
            /// <summary>
            /// Enum AConversationWasDeleted for value: a_conversation_was_deleted
            /// </summary>
            [EnumMember(Value = "a_conversation_was_deleted")]
            AConversationWasDeleted = 1
        }


        /// <summary>
        /// A conversation was deleted
        /// </summary>
        /// <value>A conversation was deleted</value>
        [DataMember(Name = "conversation_deleted", EmitDefaultValue = false)]
        public ConversationDeletedEnum? ConversationDeleted { get; set; }
        /// <summary>
        /// A conversation summary was generated by the user
        /// </summary>
        /// <value>A conversation summary was generated by the user</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ConversationSummaryAnnotationGeneratedByTheUserEnum
        {
            /// <summary>
            /// Enum AConversationSummaryAnnotationWasGeneratedByTheUser for value: a_conversation_summary_annotation_was_generated_by_the_user
            /// </summary>
            [EnumMember(Value = "a_conversation_summary_annotation_was_generated_by_the_user")]
            AConversationSummaryAnnotationWasGeneratedByTheUser = 1
        }


        /// <summary>
        /// A conversation summary was generated by the user
        /// </summary>
        /// <value>A conversation summary was generated by the user</value>
        [DataMember(Name = "conversation_summary_annotation_generated_by_the_user", EmitDefaultValue = false)]
        public ConversationSummaryAnnotationGeneratedByTheUserEnum? ConversationSummaryAnnotationGeneratedByTheUser { get; set; }
        /// <summary>
        /// A conversation was renamed by the system
        /// </summary>
        /// <value>A conversation was renamed by the system</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ConversationNameUpdatedByTheSystemEnum
        {
            /// <summary>
            /// Enum AConversationWasRenamedByTheSystem for value: a_conversation_was_renamed_by_the_system
            /// </summary>
            [EnumMember(Value = "a_conversation_was_renamed_by_the_system")]
            AConversationWasRenamedByTheSystem = 1
        }


        /// <summary>
        /// A conversation was renamed by the system
        /// </summary>
        /// <value>A conversation was renamed by the system</value>
        [DataMember(Name = "conversation_name_updated_by_the_system", EmitDefaultValue = false)]
        public ConversationNameUpdatedByTheSystemEnum? ConversationNameUpdatedByTheSystem { get; set; }
        /// <summary>
        /// A conversation was renamed by the user
        /// </summary>
        /// <value>A conversation was renamed by the user</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ConversationNameUpdatedByTheUserEnum
        {
            /// <summary>
            /// Enum AConversationWasRenamedByTheUser for value: a_conversation_was_renamed_by_the_user
            /// </summary>
            [EnumMember(Value = "a_conversation_was_renamed_by_the_user")]
            AConversationWasRenamedByTheUser = 1
        }


        /// <summary>
        /// A conversation was renamed by the user
        /// </summary>
        /// <value>A conversation was renamed by the user</value>
        [DataMember(Name = "conversation_name_updated_by_the_user", EmitDefaultValue = false)]
        public ConversationNameUpdatedByTheUserEnum? ConversationNameUpdatedByTheUser { get; set; }
        /// <summary>
        /// A conversation summary was generated
        /// </summary>
        /// <value>A conversation summary was generated</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ConversationSummaryAnnotationGeneratedByTheSystemEnum
        {
            /// <summary>
            /// Enum AConversationSummaryAnnotationWasGeneratedByTheSystem for value: a_conversation_summary_annotation_was_generated_by_the_system
            /// </summary>
            [EnumMember(Value = "a_conversation_summary_annotation_was_generated_by_the_system")]
            AConversationSummaryAnnotationWasGeneratedByTheSystem = 1
        }


        /// <summary>
        /// A conversation summary was generated
        /// </summary>
        /// <value>A conversation summary was generated</value>
        [DataMember(Name = "conversation_summary_annotation_generated_by_the_system", EmitDefaultValue = false)]
        public ConversationSummaryAnnotationGeneratedByTheSystemEnum? ConversationSummaryAnnotationGeneratedByTheSystem { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedConversationEventIdentifierDescriptionPairs" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="conversationCreated">The key value pair for an conversation being created..</param>
        /// <param name="conversationReferenced">This means that an conversation was view/used while the user was looking at the default view..</param>
        /// <param name="conversationDeleted">A conversation was deleted.</param>
        /// <param name="conversationSummaryAnnotationGeneratedByTheUser">A conversation summary was generated by the user.</param>
        /// <param name="conversationNameUpdatedByTheSystem">A conversation was renamed by the system.</param>
        /// <param name="conversationNameUpdatedByTheUser">A conversation was renamed by the user.</param>
        /// <param name="conversationSummaryAnnotationGeneratedByTheSystem">A conversation summary was generated.</param>
        public TrackedConversationEventIdentifierDescriptionPairs(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ConversationCreatedEnum? conversationCreated = default(ConversationCreatedEnum?), ConversationReferencedEnum? conversationReferenced = default(ConversationReferencedEnum?), ConversationDeletedEnum? conversationDeleted = default(ConversationDeletedEnum?), ConversationSummaryAnnotationGeneratedByTheUserEnum? conversationSummaryAnnotationGeneratedByTheUser = default(ConversationSummaryAnnotationGeneratedByTheUserEnum?), ConversationNameUpdatedByTheSystemEnum? conversationNameUpdatedByTheSystem = default(ConversationNameUpdatedByTheSystemEnum?), ConversationNameUpdatedByTheUserEnum? conversationNameUpdatedByTheUser = default(ConversationNameUpdatedByTheUserEnum?), ConversationSummaryAnnotationGeneratedByTheSystemEnum? conversationSummaryAnnotationGeneratedByTheSystem = default(ConversationSummaryAnnotationGeneratedByTheSystemEnum?))
        {
            this.Schema = schema;
            this.ConversationCreated = conversationCreated;
            this.ConversationReferenced = conversationReferenced;
            this.ConversationDeleted = conversationDeleted;
            this.ConversationSummaryAnnotationGeneratedByTheUser = conversationSummaryAnnotationGeneratedByTheUser;
            this.ConversationNameUpdatedByTheSystem = conversationNameUpdatedByTheSystem;
            this.ConversationNameUpdatedByTheUser = conversationNameUpdatedByTheUser;
            this.ConversationSummaryAnnotationGeneratedByTheSystem = conversationSummaryAnnotationGeneratedByTheSystem;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedConversationEventIdentifierDescriptionPairs {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  ConversationCreated: ").Append(ConversationCreated).Append("\n");
            sb.Append("  ConversationReferenced: ").Append(ConversationReferenced).Append("\n");
            sb.Append("  ConversationDeleted: ").Append(ConversationDeleted).Append("\n");
            sb.Append("  ConversationSummaryAnnotationGeneratedByTheUser: ").Append(ConversationSummaryAnnotationGeneratedByTheUser).Append("\n");
            sb.Append("  ConversationNameUpdatedByTheSystem: ").Append(ConversationNameUpdatedByTheSystem).Append("\n");
            sb.Append("  ConversationNameUpdatedByTheUser: ").Append(ConversationNameUpdatedByTheUser).Append("\n");
            sb.Append("  ConversationSummaryAnnotationGeneratedByTheSystem: ").Append(ConversationSummaryAnnotationGeneratedByTheSystem).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
