/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Numbers related to search results
    /// </summary>
    [DataContract(Name = "TrackedAssetsEventSearchMetadataResults")]
    public partial class TrackedAssetsEventSearchMetadataResults : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedAssetsEventSearchMetadataResults" /> class.
        /// </summary>
        /// <param name="fuzzy">Total number of fuzzy results.</param>
        /// <param name="exact">Total number of exact results.</param>
        /// <param name="assets">assets.</param>
        /// <param name="space">space.</param>
        public TrackedAssetsEventSearchMetadataResults(decimal fuzzy = default(decimal), decimal exact = default(decimal), FlattenedAssets assets = default(FlattenedAssets), Space space = default(Space))
        {
            this.Fuzzy = fuzzy;
            this.Exact = exact;
            this.Assets = assets;
            this.Space = space;
        }

        /// <summary>
        /// Total number of fuzzy results
        /// </summary>
        /// <value>Total number of fuzzy results</value>
        [DataMember(Name = "fuzzy", EmitDefaultValue = false)]
        public decimal Fuzzy { get; set; }

        /// <summary>
        /// Total number of exact results
        /// </summary>
        /// <value>Total number of exact results</value>
        [DataMember(Name = "exact", EmitDefaultValue = false)]
        public decimal Exact { get; set; }

        /// <summary>
        /// Gets or Sets Assets
        /// </summary>
        [DataMember(Name = "assets", EmitDefaultValue = false)]
        public FlattenedAssets Assets { get; set; }

        /// <summary>
        /// Gets or Sets Space
        /// </summary>
        [DataMember(Name = "space", EmitDefaultValue = false)]
        public Space Space { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedAssetsEventSearchMetadataResults {\n");
            sb.Append("  Fuzzy: ").Append(Fuzzy).Append("\n");
            sb.Append("  Exact: ").Append(Exact).Append("\n");
            sb.Append("  Assets: ").Append(Assets).Append("\n");
            sb.Append("  Space: ").Append(Space).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
