/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Metadata attached to a search event on an Asset
    /// </summary>
    [DataContract(Name = "TrackedAssetsEventSearchMetadata")]
    public partial class TrackedAssetsEventSearchMetadata : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedAssetsEventSearchMetadata" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="query">The search query itself.</param>
        /// <param name="results">results.</param>
        public TrackedAssetsEventSearchMetadata(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string query = default(string), TrackedAssetsEventSearchMetadataResults results = default(TrackedAssetsEventSearchMetadataResults))
        {
            this.Schema = schema;
            this.Query = query;
            this.Results = results;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// The search query itself
        /// </summary>
        /// <value>The search query itself</value>
        [DataMember(Name = "query", EmitDefaultValue = false)]
        public string Query { get; set; }

        /// <summary>
        /// Gets or Sets Results
        /// </summary>
        [DataMember(Name = "results", EmitDefaultValue = false)]
        public TrackedAssetsEventSearchMetadataResults Results { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedAssetsEventSearchMetadata {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Query: ").Append(Query).Append("\n");
            sb.Append("  Results: ").Append(Results).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
