/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// These are all of the available event types that are permitted in an object pair notation.
    /// </summary>
    [DataContract(Name = "TrackedAssetsEventIdentifierDescriptionPairs")]
    public partial class TrackedAssetsEventIdentifierDescriptionPairs : IValidatableObject
    {
        /// <summary>
        /// A If the assets were searched
        /// </summary>
        /// <value>A If the assets were searched</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetsSearchedEnum
        {
            /// <summary>
            /// Enum AssetsWereSearched for value: assets_were_searched
            /// </summary>
            [EnumMember(Value = "assets_were_searched")]
            AssetsWereSearched = 1
        }


        /// <summary>
        /// A If the assets were searched
        /// </summary>
        /// <value>A If the assets were searched</value>
        [DataMember(Name = "assets_searched", EmitDefaultValue = false)]
        public AssetsSearchedEnum? AssetsSearched { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedAssetsEventIdentifierDescriptionPairs" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="assetsSearched">A If the assets were searched.</param>
        public TrackedAssetsEventIdentifierDescriptionPairs(EmbeddedModelSchema schema = default(EmbeddedModelSchema), AssetsSearchedEnum? assetsSearched = default(AssetsSearchedEnum?))
        {
            this.Schema = schema;
            this.AssetsSearched = assetsSearched;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedAssetsEventIdentifierDescriptionPairs {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  AssetsSearched: ").Append(AssetsSearched).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
