/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// These are all of the available event types that are permitted in an object pair notation.
    /// </summary>
    [DataContract(Name = "TrackedAssetEventIdentifierDescriptionPairs")]
    public partial class TrackedAssetEventIdentifierDescriptionPairs : IValidatableObject
    {
        /// <summary>
        /// The key value pair for an asset being created.
        /// </summary>
        /// <value>The key value pair for an asset being created.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetCreatedEnum
        {
            /// <summary>
            /// Enum AnAssetWasCreated for value: an_asset_was_created
            /// </summary>
            [EnumMember(Value = "an_asset_was_created")]
            AnAssetWasCreated = 1
        }


        /// <summary>
        /// The key value pair for an asset being created.
        /// </summary>
        /// <value>The key value pair for an asset being created.</value>
        [DataMember(Name = "asset_created", EmitDefaultValue = false)]
        public AssetCreatedEnum? AssetCreated { get; set; }
        /// <summary>
        /// An asset was viewed
        /// </summary>
        /// <value>An asset was viewed</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetViewedEnum
        {
            /// <summary>
            /// Enum AnAssetWasViewed for value: an_asset_was_viewed
            /// </summary>
            [EnumMember(Value = "an_asset_was_viewed")]
            AnAssetWasViewed = 1
        }


        /// <summary>
        /// An asset was viewed
        /// </summary>
        /// <value>An asset was viewed</value>
        [DataMember(Name = "asset_viewed", EmitDefaultValue = false)]
        public AssetViewedEnum? AssetViewed { get; set; }
        /// <summary>
        /// An asset&#39;s format was copied
        /// </summary>
        /// <value>An asset&#39;s format was copied</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetFormatCopiedEnum
        {
            /// <summary>
            /// Enum AnAssetPreviewFormatWasCopied for value: an_asset_preview_format_was_copied
            /// </summary>
            [EnumMember(Value = "an_asset_preview_format_was_copied")]
            AnAssetPreviewFormatWasCopied = 1
        }


        /// <summary>
        /// An asset&#39;s format was copied
        /// </summary>
        /// <value>An asset&#39;s format was copied</value>
        [DataMember(Name = "asset_format_copied", EmitDefaultValue = false)]
        public AssetFormatCopiedEnum? AssetFormatCopied { get; set; }
        /// <summary>
        /// An asset&#39;s format was downloaded
        /// </summary>
        /// <value>An asset&#39;s format was downloaded</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetFormatDownloadedEnum
        {
            /// <summary>
            /// Enum AnAssetFormatWasDownloaded for value: an_asset_format_was_downloaded
            /// </summary>
            [EnumMember(Value = "an_asset_format_was_downloaded")]
            AnAssetFormatWasDownloaded = 1
        }


        /// <summary>
        /// An asset&#39;s format was downloaded
        /// </summary>
        /// <value>An asset&#39;s format was downloaded</value>
        [DataMember(Name = "asset_format_downloaded", EmitDefaultValue = false)]
        public AssetFormatDownloadedEnum? AssetFormatDownloaded { get; set; }
        /// <summary>
        /// An asset was deleted or not
        /// </summary>
        /// <value>An asset was deleted or not</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetDeletedEnum
        {
            /// <summary>
            /// Enum AnAssetWasDeleted for value: an_asset_was_deleted
            /// </summary>
            [EnumMember(Value = "an_asset_was_deleted")]
            AnAssetWasDeleted = 1
        }


        /// <summary>
        /// An asset was deleted or not
        /// </summary>
        /// <value>An asset was deleted or not</value>
        [DataMember(Name = "asset_deleted", EmitDefaultValue = false)]
        public AssetDeletedEnum? AssetDeleted { get; set; }
        /// <summary>
        /// An asset was redescribed by the user
        /// </summary>
        /// <value>An asset was redescribed by the user</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetDescriptionUpdatedEnum
        {
            /// <summary>
            /// Enum AnAssetWasRedescribedByTheUser for value: an_asset_was_redescribed_by_the_user
            /// </summary>
            [EnumMember(Value = "an_asset_was_redescribed_by_the_user")]
            AnAssetWasRedescribedByTheUser = 1
        }


        /// <summary>
        /// An asset was redescribed by the user
        /// </summary>
        /// <value>An asset was redescribed by the user</value>
        [DataMember(Name = "asset_description_updated", EmitDefaultValue = false)]
        public AssetDescriptionUpdatedEnum? AssetDescriptionUpdated { get; set; }
        /// <summary>
        /// An asset was renamed by the user
        /// </summary>
        /// <value>An asset was renamed by the user</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetNameUpdatedEnum
        {
            /// <summary>
            /// Enum AnAssetWasRenamedByTheUser for value: an_asset_was_renamed_by_the_user
            /// </summary>
            [EnumMember(Value = "an_asset_was_renamed_by_the_user")]
            AnAssetWasRenamedByTheUser = 1
        }


        /// <summary>
        /// An asset was renamed by the user
        /// </summary>
        /// <value>An asset was renamed by the user</value>
        [DataMember(Name = "asset_name_updated", EmitDefaultValue = false)]
        public AssetNameUpdatedEnum? AssetNameUpdated { get; set; }
        /// <summary>
        /// A generic classification was changed on a format within an asset
        /// </summary>
        /// <value>A generic classification was changed on a format within an asset</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetFormatGenericClassificationUpdatedEnum
        {
            /// <summary>
            /// Enum AGenericClassificationWasChangedOnAFormatWithinAnAsset for value: a_generic_classification_was_changed_on_a_format_within_an_asset
            /// </summary>
            [EnumMember(Value = "a_generic_classification_was_changed_on_a_format_within_an_asset")]
            AGenericClassificationWasChangedOnAFormatWithinAnAsset = 1
        }


        /// <summary>
        /// A generic classification was changed on a format within an asset
        /// </summary>
        /// <value>A generic classification was changed on a format within an asset</value>
        [DataMember(Name = "asset_format_generic_classification_updated", EmitDefaultValue = false)]
        public AssetFormatGenericClassificationUpdatedEnum? AssetFormatGenericClassificationUpdated { get; set; }
        /// <summary>
        /// A specific classification was changed on a format within an asset
        /// </summary>
        /// <value>A specific classification was changed on a format within an asset</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetFormatSpecificClassificationUpdatedEnum
        {
            /// <summary>
            /// Enum ASpecificClassificationWasChangedOnAFormatWithinAnAsset for value: a_specific_classification_was_changed_on_a_format_within_an_asset
            /// </summary>
            [EnumMember(Value = "a_specific_classification_was_changed_on_a_format_within_an_asset")]
            ASpecificClassificationWasChangedOnAFormatWithinAnAsset = 1
        }


        /// <summary>
        /// A specific classification was changed on a format within an asset
        /// </summary>
        /// <value>A specific classification was changed on a format within an asset</value>
        [DataMember(Name = "asset_format_specific_classification_updated", EmitDefaultValue = false)]
        public AssetFormatSpecificClassificationUpdatedEnum? AssetFormatSpecificClassificationUpdated { get; set; }
        /// <summary>
        /// Defines AssetCreationFailed
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetCreationFailedEnum
        {
            /// <summary>
            /// Enum AnAssetFailedToBeCreated for value: an_asset_failed_to_be_created
            /// </summary>
            [EnumMember(Value = "an_asset_failed_to_be_created")]
            AnAssetFailedToBeCreated = 1
        }


        /// <summary>
        /// Gets or Sets AssetCreationFailed
        /// </summary>
        [DataMember(Name = "asset_creation_failed", EmitDefaultValue = false)]
        public AssetCreationFailedEnum? AssetCreationFailed { get; set; }
        /// <summary>
        /// Defines AssetTagAdded
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetTagAddedEnum
        {
            /// <summary>
            /// Enum ATagWasAddedByTheUser for value: a_tag_was_added_by_the_user
            /// </summary>
            [EnumMember(Value = "a_tag_was_added_by_the_user")]
            ATagWasAddedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetTagAdded
        /// </summary>
        [DataMember(Name = "asset_tag_added", EmitDefaultValue = false)]
        public AssetTagAddedEnum? AssetTagAdded { get; set; }
        /// <summary>
        /// Defines AssetLinkAdded
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetLinkAddedEnum
        {
            /// <summary>
            /// Enum ALinkWasAddedByTheUser for value: a_link_was_added_by_the_user
            /// </summary>
            [EnumMember(Value = "a_link_was_added_by_the_user")]
            ALinkWasAddedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetLinkAdded
        /// </summary>
        [DataMember(Name = "asset_link_added", EmitDefaultValue = false)]
        public AssetLinkAddedEnum? AssetLinkAdded { get; set; }
        /// <summary>
        /// user generated a link for the asset
        /// </summary>
        /// <value>user generated a link for the asset</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetLinkGeneratedEnum
        {
            /// <summary>
            /// Enum AnAssetLinkWasGenerated for value: an_asset_link_was_generated
            /// </summary>
            [EnumMember(Value = "an_asset_link_was_generated")]
            AnAssetLinkWasGenerated = 1
        }


        /// <summary>
        /// user generated a link for the asset
        /// </summary>
        /// <value>user generated a link for the asset</value>
        [DataMember(Name = "asset_link_generated", EmitDefaultValue = false)]
        public AssetLinkGeneratedEnum? AssetLinkGenerated { get; set; }
        /// <summary>
        /// Defines AssetLinkDeleted
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetLinkDeletedEnum
        {
            /// <summary>
            /// Enum ALinkWasDeletedByTheUser for value: a_link_was_deleted_by_the_user
            /// </summary>
            [EnumMember(Value = "a_link_was_deleted_by_the_user")]
            ALinkWasDeletedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetLinkDeleted
        /// </summary>
        [DataMember(Name = "asset_link_deleted", EmitDefaultValue = false)]
        public AssetLinkDeletedEnum? AssetLinkDeleted { get; set; }
        /// <summary>
        /// Defines AssetTagDeleted
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetTagDeletedEnum
        {
            /// <summary>
            /// Enum ATagWasDeletedByTheUser for value: a_tag_was_deleted_by_the_user
            /// </summary>
            [EnumMember(Value = "a_tag_was_deleted_by_the_user")]
            ATagWasDeletedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetTagDeleted
        /// </summary>
        [DataMember(Name = "asset_tag_deleted", EmitDefaultValue = false)]
        public AssetTagDeletedEnum? AssetTagDeleted { get; set; }
        /// <summary>
        /// This is just a generic string for an asset was updated.
        /// </summary>
        /// <value>This is just a generic string for an asset was updated.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetUpdatedEnum
        {
            /// <summary>
            /// Enum AnAssetWasUpdated for value: an_asset_was_updated
            /// </summary>
            [EnumMember(Value = "an_asset_was_updated")]
            AnAssetWasUpdated = 1
        }


        /// <summary>
        /// This is just a generic string for an asset was updated.
        /// </summary>
        /// <value>This is just a generic string for an asset was updated.</value>
        [DataMember(Name = "asset_updated", EmitDefaultValue = false)]
        public AssetUpdatedEnum? AssetUpdated { get; set; }
        /// <summary>
        /// This is a side effect event for a format value getting edited that exists on an asset.
        /// </summary>
        /// <value>This is a side effect event for a format value getting edited that exists on an asset.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetFormatValueEditedEnum
        {
            /// <summary>
            /// Enum ASpecificFormatValueWasEditedOnAnAsset for value: a_specific_format_value_was_edited_on_an_asset
            /// </summary>
            [EnumMember(Value = "a_specific_format_value_was_edited_on_an_asset")]
            ASpecificFormatValueWasEditedOnAnAsset = 1
        }


        /// <summary>
        /// This is a side effect event for a format value getting edited that exists on an asset.
        /// </summary>
        /// <value>This is a side effect event for a format value getting edited that exists on an asset.</value>
        [DataMember(Name = "asset_format_value_edited", EmitDefaultValue = false)]
        public AssetFormatValueEditedEnum? AssetFormatValueEdited { get; set; }
        /// <summary>
        /// This is a generic activity event for an asset getting updated because our format was updated for some reason.
        /// </summary>
        /// <value>This is a generic activity event for an asset getting updated because our format was updated for some reason.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetFormatUpdatedEnum
        {
            /// <summary>
            /// Enum ASpecificFormatWasUpdatedOnAnAsset for value: a_specific_format_was_updated_on_an_asset
            /// </summary>
            [EnumMember(Value = "a_specific_format_was_updated_on_an_asset")]
            ASpecificFormatWasUpdatedOnAnAsset = 1
        }


        /// <summary>
        /// This is a generic activity event for an asset getting updated because our format was updated for some reason.
        /// </summary>
        /// <value>This is a generic activity event for an asset getting updated because our format was updated for some reason.</value>
        [DataMember(Name = "asset_format_updated", EmitDefaultValue = false)]
        public AssetFormatUpdatedEnum? AssetFormatUpdated { get; set; }
        /// <summary>
        /// This means that a shareable link was revoked.
        /// </summary>
        /// <value>This means that a shareable link was revoked.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetLinkRevokedEnum
        {
            /// <summary>
            /// Enum AnAssetLinkWasRevoked for value: an_asset_link_was_revoked
            /// </summary>
            [EnumMember(Value = "an_asset_link_was_revoked")]
            AnAssetLinkWasRevoked = 1
        }


        /// <summary>
        /// This means that a shareable link was revoked.
        /// </summary>
        /// <value>This means that a shareable link was revoked.</value>
        [DataMember(Name = "asset_link_revoked", EmitDefaultValue = false)]
        public AssetLinkRevokedEnum? AssetLinkRevoked { get; set; }
        /// <summary>
        /// This just means that a person was added via the user.
        /// </summary>
        /// <value>This just means that a person was added via the user.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetPersonAddedEnum
        {
            /// <summary>
            /// Enum APersonWasAddedByTheUser for value: a_person_was_added_by_the_user
            /// </summary>
            [EnumMember(Value = "a_person_was_added_by_the_user")]
            APersonWasAddedByTheUser = 1
        }


        /// <summary>
        /// This just means that a person was added via the user.
        /// </summary>
        /// <value>This just means that a person was added via the user.</value>
        [DataMember(Name = "asset_person_added", EmitDefaultValue = false)]
        public AssetPersonAddedEnum? AssetPersonAdded { get; set; }
        /// <summary>
        /// This just means that a person was deleted via the user.
        /// </summary>
        /// <value>This just means that a person was deleted via the user.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetPersonDeletedEnum
        {
            /// <summary>
            /// Enum APersonWasDeletedByTheUser for value: a_person_was_deleted_by_the_user
            /// </summary>
            [EnumMember(Value = "a_person_was_deleted_by_the_user")]
            APersonWasDeletedByTheUser = 1
        }


        /// <summary>
        /// This just means that a person was deleted via the user.
        /// </summary>
        /// <value>This just means that a person was deleted via the user.</value>
        [DataMember(Name = "asset_person_deleted", EmitDefaultValue = false)]
        public AssetPersonDeletedEnum? AssetPersonDeleted { get; set; }
        /// <summary>
        /// This just means that a sensitive was added via the user.
        /// </summary>
        /// <value>This just means that a sensitive was added via the user.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetSensitiveAddedEnum
        {
            /// <summary>
            /// Enum ASensitiveWasAddedByTheUser for value: a_sensitive_was_added_by_the_user
            /// </summary>
            [EnumMember(Value = "a_sensitive_was_added_by_the_user")]
            ASensitiveWasAddedByTheUser = 1
        }


        /// <summary>
        /// This just means that a sensitive was added via the user.
        /// </summary>
        /// <value>This just means that a sensitive was added via the user.</value>
        [DataMember(Name = "asset_sensitive_added", EmitDefaultValue = false)]
        public AssetSensitiveAddedEnum? AssetSensitiveAdded { get; set; }
        /// <summary>
        /// This just means that a sensitive was deleted via the user.
        /// </summary>
        /// <value>This just means that a sensitive was deleted via the user.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetSensitiveDeletedEnum
        {
            /// <summary>
            /// Enum ASensitiveWasDeletedByTheUser for value: a_sensitive_was_deleted_by_the_user
            /// </summary>
            [EnumMember(Value = "a_sensitive_was_deleted_by_the_user")]
            ASensitiveWasDeletedByTheUser = 1
        }


        /// <summary>
        /// This just means that a sensitive was deleted via the user.
        /// </summary>
        /// <value>This just means that a sensitive was deleted via the user.</value>
        [DataMember(Name = "asset_sensitive_deleted", EmitDefaultValue = false)]
        public AssetSensitiveDeletedEnum? AssetSensitiveDeleted { get; set; }
        /// <summary>
        /// This means that an asset was view/used while the user was looking at the suggestion view.
        /// </summary>
        /// <value>This means that an asset was view/used while the user was looking at the suggestion view.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum SuggestedAssetReferencedEnum
        {
            /// <summary>
            /// Enum ASuggestedAssetWasReferencedByTheUser for value: a_suggested_asset_was_referenced_by_the_user
            /// </summary>
            [EnumMember(Value = "a_suggested_asset_was_referenced_by_the_user")]
            ASuggestedAssetWasReferencedByTheUser = 1
        }


        /// <summary>
        /// This means that an asset was view/used while the user was looking at the suggestion view.
        /// </summary>
        /// <value>This means that an asset was view/used while the user was looking at the suggestion view.</value>
        [DataMember(Name = "suggested_asset_referenced", EmitDefaultValue = false)]
        public SuggestedAssetReferencedEnum? SuggestedAssetReferenced { get; set; }
        /// <summary>
        /// This means that an asset was view/used while the user was looking at the searching view.
        /// </summary>
        /// <value>This means that an asset was view/used while the user was looking at the searching view.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum SearchedAssetReferencedEnum
        {
            /// <summary>
            /// Enum ASearchedAssetWasReferencedByTheUser for value: a_searched_asset_was_referenced_by_the_user
            /// </summary>
            [EnumMember(Value = "a_searched_asset_was_referenced_by_the_user")]
            ASearchedAssetWasReferencedByTheUser = 1
        }


        /// <summary>
        /// This means that an asset was view/used while the user was looking at the searching view.
        /// </summary>
        /// <value>This means that an asset was view/used while the user was looking at the searching view.</value>
        [DataMember(Name = "searched_asset_referenced", EmitDefaultValue = false)]
        public SearchedAssetReferencedEnum? SearchedAssetReferenced { get; set; }
        /// <summary>
        /// This means that an asset was view/used while the user was looking at the default view.
        /// </summary>
        /// <value>This means that an asset was view/used while the user was looking at the default view.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetReferencedEnum
        {
            /// <summary>
            /// Enum AnAssetWasReferencedByTheUser for value: an_asset_was_referenced_by_the_user
            /// </summary>
            [EnumMember(Value = "an_asset_was_referenced_by_the_user")]
            AnAssetWasReferencedByTheUser = 1
        }


        /// <summary>
        /// This means that an asset was view/used while the user was looking at the default view.
        /// </summary>
        /// <value>This means that an asset was view/used while the user was looking at the default view.</value>
        [DataMember(Name = "asset_referenced", EmitDefaultValue = false)]
        public AssetReferencedEnum? AssetReferenced { get; set; }
        /// <summary>
        /// This means that a user referenced an asset by first clicking on an asset within an activity event.(ie from the activity view)
        /// </summary>
        /// <value>This means that a user referenced an asset by first clicking on an asset within an activity event.(ie from the activity view)</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ActivityAssetReferencedEnum
        {
            /// <summary>
            /// Enum AnActivityAssetWasReferencedByTheUser for value: an_activity_asset_was_referenced_by_the_user
            /// </summary>
            [EnumMember(Value = "an_activity_asset_was_referenced_by_the_user")]
            AnActivityAssetWasReferencedByTheUser = 1
        }


        /// <summary>
        /// This means that a user referenced an asset by first clicking on an asset within an activity event.(ie from the activity view)
        /// </summary>
        /// <value>This means that a user referenced an asset by first clicking on an asset within an activity event.(ie from the activity view)</value>
        [DataMember(Name = "activity_asset_referenced", EmitDefaultValue = false)]
        public ActivityAssetReferencedEnum? ActivityAssetReferenced { get; set; }
        /// <summary>
        /// Defines AssetAnnotationAdded
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetAnnotationAddedEnum
        {
            /// <summary>
            /// Enum AnAnnotationWasAddedByTheUser for value: an_annotation_was_added_by_the_user
            /// </summary>
            [EnumMember(Value = "an_annotation_was_added_by_the_user")]
            AnAnnotationWasAddedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetAnnotationAdded
        /// </summary>
        [DataMember(Name = "asset_annotation_added", EmitDefaultValue = false)]
        public AssetAnnotationAddedEnum? AssetAnnotationAdded { get; set; }
        /// <summary>
        /// Defines AssetAnnotationDeleted
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetAnnotationDeletedEnum
        {
            /// <summary>
            /// Enum AnAnnotationWasDeletedByTheUser for value: an_annotation_was_deleted_by_the_user
            /// </summary>
            [EnumMember(Value = "an_annotation_was_deleted_by_the_user")]
            AnAnnotationWasDeletedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetAnnotationDeleted
        /// </summary>
        [DataMember(Name = "asset_annotation_deleted", EmitDefaultValue = false)]
        public AssetAnnotationDeletedEnum? AssetAnnotationDeleted { get; set; }
        /// <summary>
        /// Defines AssetAnnotationUpdated
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetAnnotationUpdatedEnum
        {
            /// <summary>
            /// Enum AnAnnotationWasUpdatedByTheUser for value: an_annotation_was_updated_by_the_user
            /// </summary>
            [EnumMember(Value = "an_annotation_was_updated_by_the_user")]
            AnAnnotationWasUpdatedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetAnnotationUpdated
        /// </summary>
        [DataMember(Name = "asset_annotation_updated", EmitDefaultValue = false)]
        public AssetAnnotationUpdatedEnum? AssetAnnotationUpdated { get; set; }
        /// <summary>
        /// Defines AssetHintAdded
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetHintAddedEnum
        {
            /// <summary>
            /// Enum AHintWasAddedByTheUser for value: a_hint_was_added_by_the_user
            /// </summary>
            [EnumMember(Value = "a_hint_was_added_by_the_user")]
            AHintWasAddedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetHintAdded
        /// </summary>
        [DataMember(Name = "asset_hint_added", EmitDefaultValue = false)]
        public AssetHintAddedEnum? AssetHintAdded { get; set; }
        /// <summary>
        /// Defines AssetHintDeleted
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetHintDeletedEnum
        {
            /// <summary>
            /// Enum AHintWasDeletedByTheUser for value: a_hint_was_deleted_by_the_user
            /// </summary>
            [EnumMember(Value = "a_hint_was_deleted_by_the_user")]
            AHintWasDeletedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetHintDeleted
        /// </summary>
        [DataMember(Name = "asset_hint_deleted", EmitDefaultValue = false)]
        public AssetHintDeletedEnum? AssetHintDeleted { get; set; }
        /// <summary>
        /// Defines AssetHintUpdated
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetHintUpdatedEnum
        {
            /// <summary>
            /// Enum AHintWasUpdatedByTheUser for value: a_hint_was_updated_by_the_user
            /// </summary>
            [EnumMember(Value = "a_hint_was_updated_by_the_user")]
            AHintWasUpdatedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetHintUpdated
        /// </summary>
        [DataMember(Name = "asset_hint_updated", EmitDefaultValue = false)]
        public AssetHintUpdatedEnum? AssetHintUpdated { get; set; }
        /// <summary>
        /// Defines AssetAnchorAdded
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetAnchorAddedEnum
        {
            /// <summary>
            /// Enum AAnchorWasAddedByTheUser for value: a_anchor_was_added_by_the_user
            /// </summary>
            [EnumMember(Value = "a_anchor_was_added_by_the_user")]
            AAnchorWasAddedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetAnchorAdded
        /// </summary>
        [DataMember(Name = "asset_anchor_added", EmitDefaultValue = false)]
        public AssetAnchorAddedEnum? AssetAnchorAdded { get; set; }
        /// <summary>
        /// Defines AssetAnchorDeleted
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetAnchorDeletedEnum
        {
            /// <summary>
            /// Enum AAnchorWasDeletedByTheUser for value: a_anchor_was_deleted_by_the_user
            /// </summary>
            [EnumMember(Value = "a_anchor_was_deleted_by_the_user")]
            AAnchorWasDeletedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetAnchorDeleted
        /// </summary>
        [DataMember(Name = "asset_anchor_deleted", EmitDefaultValue = false)]
        public AssetAnchorDeletedEnum? AssetAnchorDeleted { get; set; }
        /// <summary>
        /// Defines AssetAnchorUpdated
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AssetAnchorUpdatedEnum
        {
            /// <summary>
            /// Enum AAnchorWasUpdatedByTheUser for value: a_anchor_was_updated_by_the_user
            /// </summary>
            [EnumMember(Value = "a_anchor_was_updated_by_the_user")]
            AAnchorWasUpdatedByTheUser = 1
        }


        /// <summary>
        /// Gets or Sets AssetAnchorUpdated
        /// </summary>
        [DataMember(Name = "asset_anchor_updated", EmitDefaultValue = false)]
        public AssetAnchorUpdatedEnum? AssetAnchorUpdated { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedAssetEventIdentifierDescriptionPairs" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="assetCreated">The key value pair for an asset being created..</param>
        /// <param name="assetViewed">An asset was viewed.</param>
        /// <param name="assetFormatCopied">An asset&#39;s format was copied.</param>
        /// <param name="assetFormatDownloaded">An asset&#39;s format was downloaded.</param>
        /// <param name="assetDeleted">An asset was deleted or not.</param>
        /// <param name="assetDescriptionUpdated">An asset was redescribed by the user.</param>
        /// <param name="assetNameUpdated">An asset was renamed by the user.</param>
        /// <param name="assetFormatGenericClassificationUpdated">A generic classification was changed on a format within an asset.</param>
        /// <param name="assetFormatSpecificClassificationUpdated">A specific classification was changed on a format within an asset.</param>
        /// <param name="assetCreationFailed">assetCreationFailed.</param>
        /// <param name="assetTagAdded">assetTagAdded.</param>
        /// <param name="assetLinkAdded">assetLinkAdded.</param>
        /// <param name="assetLinkGenerated">user generated a link for the asset.</param>
        /// <param name="assetLinkDeleted">assetLinkDeleted.</param>
        /// <param name="assetTagDeleted">assetTagDeleted.</param>
        /// <param name="assetUpdated">This is just a generic string for an asset was updated..</param>
        /// <param name="assetFormatValueEdited">This is a side effect event for a format value getting edited that exists on an asset..</param>
        /// <param name="assetFormatUpdated">This is a generic activity event for an asset getting updated because our format was updated for some reason..</param>
        /// <param name="assetLinkRevoked">This means that a shareable link was revoked..</param>
        /// <param name="assetPersonAdded">This just means that a person was added via the user..</param>
        /// <param name="assetPersonDeleted">This just means that a person was deleted via the user..</param>
        /// <param name="assetSensitiveAdded">This just means that a sensitive was added via the user..</param>
        /// <param name="assetSensitiveDeleted">This just means that a sensitive was deleted via the user..</param>
        /// <param name="suggestedAssetReferenced">This means that an asset was view/used while the user was looking at the suggestion view..</param>
        /// <param name="searchedAssetReferenced">This means that an asset was view/used while the user was looking at the searching view..</param>
        /// <param name="assetReferenced">This means that an asset was view/used while the user was looking at the default view..</param>
        /// <param name="activityAssetReferenced">This means that a user referenced an asset by first clicking on an asset within an activity event.(ie from the activity view).</param>
        /// <param name="assetAnnotationAdded">assetAnnotationAdded.</param>
        /// <param name="assetAnnotationDeleted">assetAnnotationDeleted.</param>
        /// <param name="assetAnnotationUpdated">assetAnnotationUpdated.</param>
        /// <param name="assetHintAdded">assetHintAdded.</param>
        /// <param name="assetHintDeleted">assetHintDeleted.</param>
        /// <param name="assetHintUpdated">assetHintUpdated.</param>
        /// <param name="assetAnchorAdded">assetAnchorAdded.</param>
        /// <param name="assetAnchorDeleted">assetAnchorDeleted.</param>
        /// <param name="assetAnchorUpdated">assetAnchorUpdated.</param>
        public TrackedAssetEventIdentifierDescriptionPairs(EmbeddedModelSchema schema = default(EmbeddedModelSchema), AssetCreatedEnum? assetCreated = default(AssetCreatedEnum?), AssetViewedEnum? assetViewed = default(AssetViewedEnum?), AssetFormatCopiedEnum? assetFormatCopied = default(AssetFormatCopiedEnum?), AssetFormatDownloadedEnum? assetFormatDownloaded = default(AssetFormatDownloadedEnum?), AssetDeletedEnum? assetDeleted = default(AssetDeletedEnum?), AssetDescriptionUpdatedEnum? assetDescriptionUpdated = default(AssetDescriptionUpdatedEnum?), AssetNameUpdatedEnum? assetNameUpdated = default(AssetNameUpdatedEnum?), AssetFormatGenericClassificationUpdatedEnum? assetFormatGenericClassificationUpdated = default(AssetFormatGenericClassificationUpdatedEnum?), AssetFormatSpecificClassificationUpdatedEnum? assetFormatSpecificClassificationUpdated = default(AssetFormatSpecificClassificationUpdatedEnum?), AssetCreationFailedEnum? assetCreationFailed = default(AssetCreationFailedEnum?), AssetTagAddedEnum? assetTagAdded = default(AssetTagAddedEnum?), AssetLinkAddedEnum? assetLinkAdded = default(AssetLinkAddedEnum?), AssetLinkGeneratedEnum? assetLinkGenerated = default(AssetLinkGeneratedEnum?), AssetLinkDeletedEnum? assetLinkDeleted = default(AssetLinkDeletedEnum?), AssetTagDeletedEnum? assetTagDeleted = default(AssetTagDeletedEnum?), AssetUpdatedEnum? assetUpdated = default(AssetUpdatedEnum?), AssetFormatValueEditedEnum? assetFormatValueEdited = default(AssetFormatValueEditedEnum?), AssetFormatUpdatedEnum? assetFormatUpdated = default(AssetFormatUpdatedEnum?), AssetLinkRevokedEnum? assetLinkRevoked = default(AssetLinkRevokedEnum?), AssetPersonAddedEnum? assetPersonAdded = default(AssetPersonAddedEnum?), AssetPersonDeletedEnum? assetPersonDeleted = default(AssetPersonDeletedEnum?), AssetSensitiveAddedEnum? assetSensitiveAdded = default(AssetSensitiveAddedEnum?), AssetSensitiveDeletedEnum? assetSensitiveDeleted = default(AssetSensitiveDeletedEnum?), SuggestedAssetReferencedEnum? suggestedAssetReferenced = default(SuggestedAssetReferencedEnum?), SearchedAssetReferencedEnum? searchedAssetReferenced = default(SearchedAssetReferencedEnum?), AssetReferencedEnum? assetReferenced = default(AssetReferencedEnum?), ActivityAssetReferencedEnum? activityAssetReferenced = default(ActivityAssetReferencedEnum?), AssetAnnotationAddedEnum? assetAnnotationAdded = default(AssetAnnotationAddedEnum?), AssetAnnotationDeletedEnum? assetAnnotationDeleted = default(AssetAnnotationDeletedEnum?), AssetAnnotationUpdatedEnum? assetAnnotationUpdated = default(AssetAnnotationUpdatedEnum?), AssetHintAddedEnum? assetHintAdded = default(AssetHintAddedEnum?), AssetHintDeletedEnum? assetHintDeleted = default(AssetHintDeletedEnum?), AssetHintUpdatedEnum? assetHintUpdated = default(AssetHintUpdatedEnum?), AssetAnchorAddedEnum? assetAnchorAdded = default(AssetAnchorAddedEnum?), AssetAnchorDeletedEnum? assetAnchorDeleted = default(AssetAnchorDeletedEnum?), AssetAnchorUpdatedEnum? assetAnchorUpdated = default(AssetAnchorUpdatedEnum?))
        {
            this.Schema = schema;
            this.AssetCreated = assetCreated;
            this.AssetViewed = assetViewed;
            this.AssetFormatCopied = assetFormatCopied;
            this.AssetFormatDownloaded = assetFormatDownloaded;
            this.AssetDeleted = assetDeleted;
            this.AssetDescriptionUpdated = assetDescriptionUpdated;
            this.AssetNameUpdated = assetNameUpdated;
            this.AssetFormatGenericClassificationUpdated = assetFormatGenericClassificationUpdated;
            this.AssetFormatSpecificClassificationUpdated = assetFormatSpecificClassificationUpdated;
            this.AssetCreationFailed = assetCreationFailed;
            this.AssetTagAdded = assetTagAdded;
            this.AssetLinkAdded = assetLinkAdded;
            this.AssetLinkGenerated = assetLinkGenerated;
            this.AssetLinkDeleted = assetLinkDeleted;
            this.AssetTagDeleted = assetTagDeleted;
            this.AssetUpdated = assetUpdated;
            this.AssetFormatValueEdited = assetFormatValueEdited;
            this.AssetFormatUpdated = assetFormatUpdated;
            this.AssetLinkRevoked = assetLinkRevoked;
            this.AssetPersonAdded = assetPersonAdded;
            this.AssetPersonDeleted = assetPersonDeleted;
            this.AssetSensitiveAdded = assetSensitiveAdded;
            this.AssetSensitiveDeleted = assetSensitiveDeleted;
            this.SuggestedAssetReferenced = suggestedAssetReferenced;
            this.SearchedAssetReferenced = searchedAssetReferenced;
            this.AssetReferenced = assetReferenced;
            this.ActivityAssetReferenced = activityAssetReferenced;
            this.AssetAnnotationAdded = assetAnnotationAdded;
            this.AssetAnnotationDeleted = assetAnnotationDeleted;
            this.AssetAnnotationUpdated = assetAnnotationUpdated;
            this.AssetHintAdded = assetHintAdded;
            this.AssetHintDeleted = assetHintDeleted;
            this.AssetHintUpdated = assetHintUpdated;
            this.AssetAnchorAdded = assetAnchorAdded;
            this.AssetAnchorDeleted = assetAnchorDeleted;
            this.AssetAnchorUpdated = assetAnchorUpdated;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedAssetEventIdentifierDescriptionPairs {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  AssetCreated: ").Append(AssetCreated).Append("\n");
            sb.Append("  AssetViewed: ").Append(AssetViewed).Append("\n");
            sb.Append("  AssetFormatCopied: ").Append(AssetFormatCopied).Append("\n");
            sb.Append("  AssetFormatDownloaded: ").Append(AssetFormatDownloaded).Append("\n");
            sb.Append("  AssetDeleted: ").Append(AssetDeleted).Append("\n");
            sb.Append("  AssetDescriptionUpdated: ").Append(AssetDescriptionUpdated).Append("\n");
            sb.Append("  AssetNameUpdated: ").Append(AssetNameUpdated).Append("\n");
            sb.Append("  AssetFormatGenericClassificationUpdated: ").Append(AssetFormatGenericClassificationUpdated).Append("\n");
            sb.Append("  AssetFormatSpecificClassificationUpdated: ").Append(AssetFormatSpecificClassificationUpdated).Append("\n");
            sb.Append("  AssetCreationFailed: ").Append(AssetCreationFailed).Append("\n");
            sb.Append("  AssetTagAdded: ").Append(AssetTagAdded).Append("\n");
            sb.Append("  AssetLinkAdded: ").Append(AssetLinkAdded).Append("\n");
            sb.Append("  AssetLinkGenerated: ").Append(AssetLinkGenerated).Append("\n");
            sb.Append("  AssetLinkDeleted: ").Append(AssetLinkDeleted).Append("\n");
            sb.Append("  AssetTagDeleted: ").Append(AssetTagDeleted).Append("\n");
            sb.Append("  AssetUpdated: ").Append(AssetUpdated).Append("\n");
            sb.Append("  AssetFormatValueEdited: ").Append(AssetFormatValueEdited).Append("\n");
            sb.Append("  AssetFormatUpdated: ").Append(AssetFormatUpdated).Append("\n");
            sb.Append("  AssetLinkRevoked: ").Append(AssetLinkRevoked).Append("\n");
            sb.Append("  AssetPersonAdded: ").Append(AssetPersonAdded).Append("\n");
            sb.Append("  AssetPersonDeleted: ").Append(AssetPersonDeleted).Append("\n");
            sb.Append("  AssetSensitiveAdded: ").Append(AssetSensitiveAdded).Append("\n");
            sb.Append("  AssetSensitiveDeleted: ").Append(AssetSensitiveDeleted).Append("\n");
            sb.Append("  SuggestedAssetReferenced: ").Append(SuggestedAssetReferenced).Append("\n");
            sb.Append("  SearchedAssetReferenced: ").Append(SearchedAssetReferenced).Append("\n");
            sb.Append("  AssetReferenced: ").Append(AssetReferenced).Append("\n");
            sb.Append("  ActivityAssetReferenced: ").Append(ActivityAssetReferenced).Append("\n");
            sb.Append("  AssetAnnotationAdded: ").Append(AssetAnnotationAdded).Append("\n");
            sb.Append("  AssetAnnotationDeleted: ").Append(AssetAnnotationDeleted).Append("\n");
            sb.Append("  AssetAnnotationUpdated: ").Append(AssetAnnotationUpdated).Append("\n");
            sb.Append("  AssetHintAdded: ").Append(AssetHintAdded).Append("\n");
            sb.Append("  AssetHintDeleted: ").Append(AssetHintDeleted).Append("\n");
            sb.Append("  AssetHintUpdated: ").Append(AssetHintUpdated).Append("\n");
            sb.Append("  AssetAnchorAdded: ").Append(AssetAnchorAdded).Append("\n");
            sb.Append("  AssetAnchorDeleted: ").Append(AssetAnchorDeleted).Append("\n");
            sb.Append("  AssetAnchorUpdated: ").Append(AssetAnchorUpdated).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
