/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// If an asset was created from a file attachment
    /// </summary>
    [DataContract(Name = "TrackedAssetEventCreationMetadataFile")]
    public partial class TrackedAssetEventCreationMetadataFile : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedAssetEventCreationMetadataFile" /> class.
        /// </summary>
        /// <param name="keyboard">Whether the file was pasted via the keyboard.</param>
        /// <param name="dragAndDrop">Whether the file was dropped onto pieces.</param>
        /// <param name="interaction">Whether the file was attached via a button click.</param>
        public TrackedAssetEventCreationMetadataFile(bool keyboard = default(bool), bool dragAndDrop = default(bool), bool interaction = default(bool))
        {
            this.Keyboard = keyboard;
            this.DragAndDrop = dragAndDrop;
            this.Interaction = interaction;
        }

        /// <summary>
        /// Whether the file was pasted via the keyboard
        /// </summary>
        /// <value>Whether the file was pasted via the keyboard</value>
        [DataMember(Name = "keyboard", EmitDefaultValue = true)]
        public bool Keyboard { get; set; }

        /// <summary>
        /// Whether the file was dropped onto pieces
        /// </summary>
        /// <value>Whether the file was dropped onto pieces</value>
        [DataMember(Name = "drag_and_drop", EmitDefaultValue = true)]
        public bool DragAndDrop { get; set; }

        /// <summary>
        /// Whether the file was attached via a button click
        /// </summary>
        /// <value>Whether the file was attached via a button click</value>
        [DataMember(Name = "interaction", EmitDefaultValue = true)]
        public bool Interaction { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedAssetEventCreationMetadataFile {\n");
            sb.Append("  Keyboard: ").Append(Keyboard).Append("\n");
            sb.Append("  DragAndDrop: ").Append(DragAndDrop).Append("\n");
            sb.Append("  Interaction: ").Append(Interaction).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
