/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// If an asset was created from a clipboard event
    /// </summary>
    [DataContract(Name = "TrackedAssetEventCreationMetadataClipboard")]
    public partial class TrackedAssetEventCreationMetadataClipboard : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedAssetEventCreationMetadataClipboard" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="keyboard">Whether the clipboard was utilized via the keyboard.</param>
        /// <param name="interaction">Whether the clipboard was extracted through a button click.</param>
        public TrackedAssetEventCreationMetadataClipboard(EmbeddedModelSchema schema = default(EmbeddedModelSchema), bool keyboard = default(bool), bool interaction = default(bool))
        {
            this.Schema = schema;
            this.Keyboard = keyboard;
            this.Interaction = interaction;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Whether the clipboard was utilized via the keyboard
        /// </summary>
        /// <value>Whether the clipboard was utilized via the keyboard</value>
        [DataMember(Name = "keyboard", EmitDefaultValue = true)]
        public bool Keyboard { get; set; }

        /// <summary>
        /// Whether the clipboard was extracted through a button click
        /// </summary>
        /// <value>Whether the clipboard was extracted through a button click</value>
        [DataMember(Name = "interaction", EmitDefaultValue = true)]
        public bool Interaction { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedAssetEventCreationMetadataClipboard {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Keyboard: ").Append(Keyboard).Append("\n");
            sb.Append("  Interaction: ").Append(Interaction).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
