/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// A Model to describe what application a format/analytics event originated.
    /// </summary>
    [DataContract(Name = "TrackedApplication")]
    public partial class TrackedApplication : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Name
        /// </summary>
        [DataMember(Name = "name", IsRequired = true, EmitDefaultValue = true)]
        public ApplicationNameEnum Name { get; set; }

        /// <summary>
        /// Gets or Sets Platform
        /// </summary>
        [DataMember(Name = "platform", IsRequired = true, EmitDefaultValue = true)]
        public PlatformEnum Platform { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedApplication" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TrackedApplication() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TrackedApplication" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">The ID of the tracked application. (required).</param>
        /// <param name="name">name (required).</param>
        /// <param name="varVersion">This is the specific version number 0.0.0 (required).</param>
        /// <param name="platform">platform (required).</param>
        /// <param name="automaticUnload">This is a proper that will let us know if we will proactivity unload all of your machine learning models.by default this is false..</param>
        public TrackedApplication(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), ApplicationNameEnum name = default(ApplicationNameEnum), string varVersion = default(string), PlatformEnum platform = default(PlatformEnum), bool automaticUnload = default(bool))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for TrackedApplication and cannot be null");
            }
            this.Id = id;
            this.Name = name;
            // to ensure "varVersion" is required (not null)
            if (varVersion == null)
            {
                throw new ArgumentNullException("varVersion is a required property for TrackedApplication and cannot be null");
            }
            this.VarVersion = varVersion;
            this.Platform = platform;
            this.Schema = schema;
            this.AutomaticUnload = automaticUnload;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// The ID of the tracked application.
        /// </summary>
        /// <value>The ID of the tracked application.</value>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// This is the specific version number 0.0.0
        /// </summary>
        /// <value>This is the specific version number 0.0.0</value>
        [DataMember(Name = "version", IsRequired = true, EmitDefaultValue = true)]
        public string VarVersion { get; set; }

        /// <summary>
        /// This is a proper that will let us know if we will proactivity unload all of your machine learning models.by default this is false.
        /// </summary>
        /// <value>This is a proper that will let us know if we will proactivity unload all of your machine learning models.by default this is false.</value>
        [DataMember(Name = "automaticUnload", EmitDefaultValue = true)]
        public bool AutomaticUnload { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TrackedApplication {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  VarVersion: ").Append(VarVersion).Append("\n");
            sb.Append("  Platform: ").Append(Platform).Append("\n");
            sb.Append("  AutomaticUnload: ").Append(AutomaticUnload).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
