/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Thext Match currently used for sensitive for scales for people, and anything related to text matching.  group: is the entire match subgroup is the inner match within the group.(optional)
    /// </summary>
    [DataContract(Name = "TextMatch")]
    public partial class TextMatch : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TextMatch" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TextMatch() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TextMatch" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="group">group (required).</param>
        /// <param name="subgroup">subgroup.</param>
        public TextMatch(EmbeddedModelSchema schema = default(EmbeddedModelSchema), TextLocation group = default(TextLocation), TextLocation subgroup = default(TextLocation))
        {
            // to ensure "group" is required (not null)
            if (group == null)
            {
                throw new ArgumentNullException("group is a required property for TextMatch and cannot be null");
            }
            this.Group = group;
            this.Schema = schema;
            this.Subgroup = subgroup;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Group
        /// </summary>
        [DataMember(Name = "group", IsRequired = true, EmitDefaultValue = true)]
        public TextLocation Group { get; set; }

        /// <summary>
        /// Gets or Sets Subgroup
        /// </summary>
        [DataMember(Name = "subgroup", EmitDefaultValue = false)]
        public TextLocation Subgroup { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TextMatch {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Group: ").Append(Group).Append("\n");
            sb.Append("  Subgroup: ").Append(Subgroup).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
