/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// TLPCodeSnippetAnalytics
    /// </summary>
    [DataContract(Name = "TLPCodeSnippetAnalytics")]
    public partial class TLPCodeSnippetAnalytics : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TLPCodeSnippetAnalytics" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="statistics">statistics.</param>
        /// <param name="classification">classification.</param>
        /// <param name="reclassification">reclassification.</param>
        /// <param name="suggested">suggested.</param>
        /// <param name="tagify">tagify.</param>
        /// <param name="description">description.</param>
        public TLPCodeSnippetAnalytics(EmbeddedModelSchema schema = default(EmbeddedModelSchema), TLPCodeFragmentStatistics statistics = default(TLPCodeFragmentStatistics), TLPCodeFragmentClassification classification = default(TLPCodeFragmentClassification), TLPCodeFragmentReclassification reclassification = default(TLPCodeFragmentReclassification), TLPCodeSnippetSuggestedInteractions suggested = default(TLPCodeSnippetSuggestedInteractions), TLPCodeFragmentTagify tagify = default(TLPCodeFragmentTagify), TLPCodeFragmentDescription description = default(TLPCodeFragmentDescription))
        {
            this.Schema = schema;
            this.Statistics = statistics;
            this.Classification = classification;
            this.Reclassification = reclassification;
            this.Suggested = suggested;
            this.Tagify = tagify;
            this.Description = description;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Statistics
        /// </summary>
        [DataMember(Name = "statistics", EmitDefaultValue = false)]
        public TLPCodeFragmentStatistics Statistics { get; set; }

        /// <summary>
        /// Gets or Sets Classification
        /// </summary>
        [DataMember(Name = "classification", EmitDefaultValue = false)]
        public TLPCodeFragmentClassification Classification { get; set; }

        /// <summary>
        /// Gets or Sets Reclassification
        /// </summary>
        [DataMember(Name = "reclassification", EmitDefaultValue = false)]
        public TLPCodeFragmentReclassification Reclassification { get; set; }

        /// <summary>
        /// Gets or Sets Suggested
        /// </summary>
        [DataMember(Name = "suggested", EmitDefaultValue = false)]
        public TLPCodeSnippetSuggestedInteractions Suggested { get; set; }

        /// <summary>
        /// Gets or Sets Tagify
        /// </summary>
        [DataMember(Name = "tagify", EmitDefaultValue = false)]
        public TLPCodeFragmentTagify Tagify { get; set; }

        /// <summary>
        /// Gets or Sets Description
        /// </summary>
        [DataMember(Name = "description", EmitDefaultValue = false)]
        public TLPCodeFragmentDescription Description { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TLPCodeSnippetAnalytics {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Statistics: ").Append(Statistics).Append("\n");
            sb.Append("  Classification: ").Append(Classification).Append("\n");
            sb.Append("  Reclassification: ").Append(Reclassification).Append("\n");
            sb.Append("  Suggested: ").Append(Suggested).Append("\n");
            sb.Append("  Tagify: ").Append(Tagify).Append("\n");
            sb.Append("  Description: ").Append(Description).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
