/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Model for monitoring and evaluating the suggested save feature
    /// </summary>
    [DataContract(Name = "TLPCodeFragmentSuggestedSave")]
    public partial class TLPCodeFragmentSuggestedSave : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TLPCodeFragmentSuggestedSave" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TLPCodeFragmentSuggestedSave() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TLPCodeFragmentSuggestedSave" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="asset">asset (required).</param>
        /// <param name="user">user (required).</param>
        /// <param name="model">model (required).</param>
        /// <param name="created">created (required).</param>
        /// <param name="os">os (required).</param>
        /// <param name="context">context from where suggestion came from.</param>
        /// <param name="score">maximum similarity score.</param>
        /// <param name="candidates">number of candidates.</param>
        public TLPCodeFragmentSuggestedSave(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string asset = default(string), string user = default(string), string model = default(string), string created = default(string), string os = default(string), string context = default(string), decimal score = default(decimal), int candidates = default(int))
        {
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for TLPCodeFragmentSuggestedSave and cannot be null");
            }
            this.Asset = asset;
            // to ensure "user" is required (not null)
            if (user == null)
            {
                throw new ArgumentNullException("user is a required property for TLPCodeFragmentSuggestedSave and cannot be null");
            }
            this.User = user;
            // to ensure "model" is required (not null)
            if (model == null)
            {
                throw new ArgumentNullException("model is a required property for TLPCodeFragmentSuggestedSave and cannot be null");
            }
            this.Model = model;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for TLPCodeFragmentSuggestedSave and cannot be null");
            }
            this.Created = created;
            // to ensure "os" is required (not null)
            if (os == null)
            {
                throw new ArgumentNullException("os is a required property for TLPCodeFragmentSuggestedSave and cannot be null");
            }
            this.Os = os;
            this.Schema = schema;
            this.Context = context;
            this.Score = score;
            this.Candidates = candidates;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public string Asset { get; set; }

        /// <summary>
        /// Gets or Sets User
        /// </summary>
        [DataMember(Name = "user", IsRequired = true, EmitDefaultValue = true)]
        public string User { get; set; }

        /// <summary>
        /// Gets or Sets Model
        /// </summary>
        [DataMember(Name = "model", IsRequired = true, EmitDefaultValue = true)]
        public string Model { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public string Created { get; set; }

        /// <summary>
        /// Gets or Sets Os
        /// </summary>
        [DataMember(Name = "os", IsRequired = true, EmitDefaultValue = true)]
        public string Os { get; set; }

        /// <summary>
        /// context from where suggestion came from
        /// </summary>
        /// <value>context from where suggestion came from</value>
        [DataMember(Name = "context", EmitDefaultValue = false)]
        public string Context { get; set; }

        /// <summary>
        /// maximum similarity score
        /// </summary>
        /// <value>maximum similarity score</value>
        [DataMember(Name = "score", EmitDefaultValue = false)]
        public decimal Score { get; set; }

        /// <summary>
        /// number of candidates
        /// </summary>
        /// <value>number of candidates</value>
        [DataMember(Name = "candidates", EmitDefaultValue = false)]
        public int Candidates { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TLPCodeFragmentSuggestedSave {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Os: ").Append(Os).Append("\n");
            sb.Append("  Context: ").Append(Context).Append("\n");
            sb.Append("  Score: ").Append(Score).Append("\n");
            sb.Append("  Candidates: ").Append(Candidates).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
