/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Model for ML big query Data collection.
    /// </summary>
    [DataContract(Name = "TLPCodeFragmentDescriptiveStatistics")]
    public partial class TLPCodeFragmentDescriptiveStatistics : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TLPCodeFragmentDescriptiveStatistics" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TLPCodeFragmentDescriptiveStatistics() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TLPCodeFragmentDescriptiveStatistics" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="user">user (required).</param>
        /// <param name="os">os (required).</param>
        /// <param name="language">language (required).</param>
        /// <param name="length">length (required).</param>
        /// <param name="ast">ast (required).</param>
        /// <param name="timestamp">timestamp (required).</param>
        /// <param name="asset">asset (required).</param>
        /// <param name="context">this is the application in which this was created from. (required).</param>
        /// <param name="snippet">this is the value of the snippet (required).</param>
        /// <param name="probability">probability (required).</param>
        public TLPCodeFragmentDescriptiveStatistics(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string user = default(string), string os = default(string), string language = default(string), decimal length = default(decimal), string ast = default(string), string timestamp = default(string), string asset = default(string), string context = default(string), string snippet = default(string), string probability = default(string))
        {
            // to ensure "user" is required (not null)
            if (user == null)
            {
                throw new ArgumentNullException("user is a required property for TLPCodeFragmentDescriptiveStatistics and cannot be null");
            }
            this.User = user;
            // to ensure "os" is required (not null)
            if (os == null)
            {
                throw new ArgumentNullException("os is a required property for TLPCodeFragmentDescriptiveStatistics and cannot be null");
            }
            this.Os = os;
            // to ensure "language" is required (not null)
            if (language == null)
            {
                throw new ArgumentNullException("language is a required property for TLPCodeFragmentDescriptiveStatistics and cannot be null");
            }
            this.Language = language;
            this.Length = length;
            // to ensure "ast" is required (not null)
            if (ast == null)
            {
                throw new ArgumentNullException("ast is a required property for TLPCodeFragmentDescriptiveStatistics and cannot be null");
            }
            this.Ast = ast;
            // to ensure "timestamp" is required (not null)
            if (timestamp == null)
            {
                throw new ArgumentNullException("timestamp is a required property for TLPCodeFragmentDescriptiveStatistics and cannot be null");
            }
            this.Timestamp = timestamp;
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for TLPCodeFragmentDescriptiveStatistics and cannot be null");
            }
            this.Asset = asset;
            // to ensure "context" is required (not null)
            if (context == null)
            {
                throw new ArgumentNullException("context is a required property for TLPCodeFragmentDescriptiveStatistics and cannot be null");
            }
            this.Context = context;
            // to ensure "snippet" is required (not null)
            if (snippet == null)
            {
                throw new ArgumentNullException("snippet is a required property for TLPCodeFragmentDescriptiveStatistics and cannot be null");
            }
            this.Snippet = snippet;
            // to ensure "probability" is required (not null)
            if (probability == null)
            {
                throw new ArgumentNullException("probability is a required property for TLPCodeFragmentDescriptiveStatistics and cannot be null");
            }
            this.Probability = probability;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets User
        /// </summary>
        [DataMember(Name = "user", IsRequired = true, EmitDefaultValue = true)]
        public string User { get; set; }

        /// <summary>
        /// Gets or Sets Os
        /// </summary>
        [DataMember(Name = "os", IsRequired = true, EmitDefaultValue = true)]
        public string Os { get; set; }

        /// <summary>
        /// Gets or Sets Language
        /// </summary>
        [DataMember(Name = "language", IsRequired = true, EmitDefaultValue = true)]
        public string Language { get; set; }

        /// <summary>
        /// Gets or Sets Length
        /// </summary>
        [DataMember(Name = "length", IsRequired = true, EmitDefaultValue = true)]
        public decimal Length { get; set; }

        /// <summary>
        /// Gets or Sets Ast
        /// </summary>
        [DataMember(Name = "ast", IsRequired = true, EmitDefaultValue = true)]
        public string Ast { get; set; }

        /// <summary>
        /// Gets or Sets Timestamp
        /// </summary>
        [DataMember(Name = "timestamp", IsRequired = true, EmitDefaultValue = true)]
        public string Timestamp { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public string Asset { get; set; }

        /// <summary>
        /// this is the application in which this was created from.
        /// </summary>
        /// <value>this is the application in which this was created from.</value>
        [DataMember(Name = "context", IsRequired = true, EmitDefaultValue = true)]
        public string Context { get; set; }

        /// <summary>
        /// this is the value of the snippet
        /// </summary>
        /// <value>this is the value of the snippet</value>
        [DataMember(Name = "snippet", IsRequired = true, EmitDefaultValue = true)]
        public string Snippet { get; set; }

        /// <summary>
        /// Gets or Sets Probability
        /// </summary>
        [DataMember(Name = "probability", IsRequired = true, EmitDefaultValue = true)]
        public string Probability { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TLPCodeFragmentDescriptiveStatistics {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  Os: ").Append(Os).Append("\n");
            sb.Append("  Language: ").Append(Language).Append("\n");
            sb.Append("  Length: ").Append(Length).Append("\n");
            sb.Append("  Ast: ").Append(Ast).Append("\n");
            sb.Append("  Timestamp: ").Append(Timestamp).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Context: ").Append(Context).Append("\n");
            sb.Append("  Snippet: ").Append(Snippet).Append("\n");
            sb.Append("  Probability: ").Append(Probability).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
