/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Model for ML big query Code Description.
    /// </summary>
    [DataContract(Name = "TLPCodeFragmentDescription")]
    public partial class TLPCodeFragmentDescription : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TLPCodeFragmentDescription" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TLPCodeFragmentDescription() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TLPCodeFragmentDescription" /> class.
        /// </summary>
        /// <param name="description">This is the stringified json of a TLPDescription object.</param>
        /// <param name="asset">This is the asset id. (required).</param>
        /// <param name="created">timestamp of creation (required).</param>
        /// <param name="model">this is the model version (required).</param>
        /// <param name="latency">the time it takes to run this model..</param>
        /// <param name="user">the uuid of the user the description was created for. (required).</param>
        /// <param name="context">the application this description was created from..</param>
        /// <param name="os">This is the UUID of the OS that this context is currently connected to..</param>
        public TLPCodeFragmentDescription(string description = default(string), string asset = default(string), string created = default(string), string model = default(string), decimal latency = default(decimal), string user = default(string), string context = default(string), string os = default(string))
        {
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for TLPCodeFragmentDescription and cannot be null");
            }
            this.Asset = asset;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for TLPCodeFragmentDescription and cannot be null");
            }
            this.Created = created;
            // to ensure "model" is required (not null)
            if (model == null)
            {
                throw new ArgumentNullException("model is a required property for TLPCodeFragmentDescription and cannot be null");
            }
            this.Model = model;
            // to ensure "user" is required (not null)
            if (user == null)
            {
                throw new ArgumentNullException("user is a required property for TLPCodeFragmentDescription and cannot be null");
            }
            this.User = user;
            this.Description = description;
            this.Latency = latency;
            this.Context = context;
            this.Os = os;
        }

        /// <summary>
        /// This is the stringified json of a TLPDescription object
        /// </summary>
        /// <value>This is the stringified json of a TLPDescription object</value>
        [DataMember(Name = "description", EmitDefaultValue = false)]
        public string Description { get; set; }

        /// <summary>
        /// This is the asset id.
        /// </summary>
        /// <value>This is the asset id.</value>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public string Asset { get; set; }

        /// <summary>
        /// timestamp of creation
        /// </summary>
        /// <value>timestamp of creation</value>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public string Created { get; set; }

        /// <summary>
        /// this is the model version
        /// </summary>
        /// <value>this is the model version</value>
        [DataMember(Name = "model", IsRequired = true, EmitDefaultValue = true)]
        public string Model { get; set; }

        /// <summary>
        /// the time it takes to run this model.
        /// </summary>
        /// <value>the time it takes to run this model.</value>
        [DataMember(Name = "latency", EmitDefaultValue = false)]
        public decimal Latency { get; set; }

        /// <summary>
        /// the uuid of the user the description was created for.
        /// </summary>
        /// <value>the uuid of the user the description was created for.</value>
        [DataMember(Name = "user", IsRequired = true, EmitDefaultValue = true)]
        public string User { get; set; }

        /// <summary>
        /// the application this description was created from.
        /// </summary>
        /// <value>the application this description was created from.</value>
        [DataMember(Name = "context", EmitDefaultValue = false)]
        public string Context { get; set; }

        /// <summary>
        /// This is the UUID of the OS that this context is currently connected to.
        /// </summary>
        /// <value>This is the UUID of the OS that this context is currently connected to.</value>
        [DataMember(Name = "os", EmitDefaultValue = false)]
        public string Os { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TLPCodeFragmentDescription {\n");
            sb.Append("  Description: ").Append(Description).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Latency: ").Append(Latency).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  Context: ").Append(Context).Append("\n");
            sb.Append("  Os: ").Append(Os).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
