/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Model for ML big query classification.
    /// </summary>
    [DataContract(Name = "TLPCodeFragmentClassification")]
    public partial class TLPCodeFragmentClassification : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TLPCodeFragmentClassification" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected TLPCodeFragmentClassification() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="TLPCodeFragmentClassification" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="asset">asset (required).</param>
        /// <param name="model">model (required).</param>
        /// <param name="created">created (required).</param>
        /// <param name="classification">classification (required).</param>
        /// <param name="probability">probability (required).</param>
        /// <param name="context">context (required).</param>
        /// <param name="distribution">distribution.</param>
        /// <param name="metadata">metadata.</param>
        /// <param name="user">identifier for the user (required).</param>
        /// <param name="latency">this is the time it takes to run this model..</param>
        /// <param name="varSystem">varSystem.</param>
        /// <param name="os">os (required).</param>
        public TLPCodeFragmentClassification(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string asset = default(string), string model = default(string), string created = default(string), string classification = default(string), decimal probability = default(decimal), string context = default(string), string distribution = default(string), TLPCodeFragmentClassificationMetadata metadata = default(TLPCodeFragmentClassificationMetadata), string user = default(string), decimal latency = default(decimal), SystemExecutionInformation varSystem = default(SystemExecutionInformation), string os = default(string))
        {
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for TLPCodeFragmentClassification and cannot be null");
            }
            this.Asset = asset;
            // to ensure "model" is required (not null)
            if (model == null)
            {
                throw new ArgumentNullException("model is a required property for TLPCodeFragmentClassification and cannot be null");
            }
            this.Model = model;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for TLPCodeFragmentClassification and cannot be null");
            }
            this.Created = created;
            // to ensure "classification" is required (not null)
            if (classification == null)
            {
                throw new ArgumentNullException("classification is a required property for TLPCodeFragmentClassification and cannot be null");
            }
            this.Classification = classification;
            this.Probability = probability;
            // to ensure "context" is required (not null)
            if (context == null)
            {
                throw new ArgumentNullException("context is a required property for TLPCodeFragmentClassification and cannot be null");
            }
            this.Context = context;
            // to ensure "user" is required (not null)
            if (user == null)
            {
                throw new ArgumentNullException("user is a required property for TLPCodeFragmentClassification and cannot be null");
            }
            this.User = user;
            // to ensure "os" is required (not null)
            if (os == null)
            {
                throw new ArgumentNullException("os is a required property for TLPCodeFragmentClassification and cannot be null");
            }
            this.Os = os;
            this.Schema = schema;
            this.Distribution = distribution;
            this.Metadata = metadata;
            this.Latency = latency;
            this.System = varSystem;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public string Asset { get; set; }

        /// <summary>
        /// Gets or Sets Model
        /// </summary>
        [DataMember(Name = "model", IsRequired = true, EmitDefaultValue = true)]
        public string Model { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public string Created { get; set; }

        /// <summary>
        /// Gets or Sets Classification
        /// </summary>
        [DataMember(Name = "classification", IsRequired = true, EmitDefaultValue = true)]
        public string Classification { get; set; }

        /// <summary>
        /// Gets or Sets Probability
        /// </summary>
        [DataMember(Name = "probability", IsRequired = true, EmitDefaultValue = true)]
        public decimal Probability { get; set; }

        /// <summary>
        /// Gets or Sets Context
        /// </summary>
        [DataMember(Name = "context", IsRequired = true, EmitDefaultValue = true)]
        public string Context { get; set; }

        /// <summary>
        /// Gets or Sets Distribution
        /// </summary>
        [DataMember(Name = "distribution", EmitDefaultValue = false)]
        public string Distribution { get; set; }

        /// <summary>
        /// Gets or Sets Metadata
        /// </summary>
        [DataMember(Name = "metadata", EmitDefaultValue = false)]
        public TLPCodeFragmentClassificationMetadata Metadata { get; set; }

        /// <summary>
        /// identifier for the user
        /// </summary>
        /// <value>identifier for the user</value>
        [DataMember(Name = "user", IsRequired = true, EmitDefaultValue = true)]
        public string User { get; set; }

        /// <summary>
        /// this is the time it takes to run this model.
        /// </summary>
        /// <value>this is the time it takes to run this model.</value>
        [DataMember(Name = "latency", EmitDefaultValue = false)]
        public decimal Latency { get; set; }

        /// <summary>
        /// Gets or Sets System
        /// </summary>
        [DataMember(Name = "system", EmitDefaultValue = false)]
        public SystemExecutionInformation System { get; set; }

        /// <summary>
        /// Gets or Sets Os
        /// </summary>
        [DataMember(Name = "os", IsRequired = true, EmitDefaultValue = true)]
        public string Os { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class TLPCodeFragmentClassification {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Classification: ").Append(Classification).Append("\n");
            sb.Append("  Probability: ").Append(Probability).Append("\n");
            sb.Append("  Context: ").Append(Context).Append("\n");
            sb.Append("  Distribution: ").Append(Distribution).Append("\n");
            sb.Append("  Metadata: ").Append(Metadata).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  Latency: ").Append(Latency).Append("\n");
            sb.Append("  System: ").Append(System).Append("\n");
            sb.Append("  Os: ").Append(Os).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
