/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is system information that we are able to get from the users machine(rust package TBD). TODO potentially pull this out of TLP.
    /// </summary>
    [DataContract(Name = "SystemExecutionInformation")]
    public partial class SystemExecutionInformation : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SystemExecutionInformation" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SystemExecutionInformation() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SystemExecutionInformation" /> class.
        /// </summary>
        /// <param name="memory">memory (required).</param>
        /// <param name="os">os (required).</param>
        /// <param name="kernel">kernel (required).</param>
        /// <param name="cpu">cpu (required).</param>
        public SystemExecutionInformation(int memory = default(int), string os = default(string), string kernel = default(string), SystemExecutionCpuInformation cpu = default(SystemExecutionCpuInformation))
        {
            this.Memory = memory;
            // to ensure "os" is required (not null)
            if (os == null)
            {
                throw new ArgumentNullException("os is a required property for SystemExecutionInformation and cannot be null");
            }
            this.Os = os;
            // to ensure "kernel" is required (not null)
            if (kernel == null)
            {
                throw new ArgumentNullException("kernel is a required property for SystemExecutionInformation and cannot be null");
            }
            this.Kernel = kernel;
            // to ensure "cpu" is required (not null)
            if (cpu == null)
            {
                throw new ArgumentNullException("cpu is a required property for SystemExecutionInformation and cannot be null");
            }
            this.Cpu = cpu;
        }

        /// <summary>
        /// Gets or Sets Memory
        /// </summary>
        [DataMember(Name = "memory", IsRequired = true, EmitDefaultValue = true)]
        public int Memory { get; set; }

        /// <summary>
        /// Gets or Sets Os
        /// </summary>
        [DataMember(Name = "os", IsRequired = true, EmitDefaultValue = true)]
        public string Os { get; set; }

        /// <summary>
        /// Gets or Sets Kernel
        /// </summary>
        [DataMember(Name = "kernel", IsRequired = true, EmitDefaultValue = true)]
        public string Kernel { get; set; }

        /// <summary>
        /// Gets or Sets Cpu
        /// </summary>
        [DataMember(Name = "cpu", IsRequired = true, EmitDefaultValue = true)]
        public SystemExecutionCpuInformation Cpu { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SystemExecutionInformation {\n");
            sb.Append("  Memory: ").Append(Memory).Append("\n");
            sb.Append("  Os: ").Append(Os).Append("\n");
            sb.Append("  Kernel: ").Append(Kernel).Append("\n");
            sb.Append("  Cpu: ").Append(Cpu).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
