/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// SystemExecutionCpuInformation
    /// </summary>
    [DataContract(Name = "SystemExecutionCpuInformation")]
    public partial class SystemExecutionCpuInformation : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SystemExecutionCpuInformation" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SystemExecutionCpuInformation() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SystemExecutionCpuInformation" /> class.
        /// </summary>
        /// <param name="count">this is the number of cpus (required).</param>
        /// <param name="brand">this is the brand of cpu (required).</param>
        /// <param name="frequency">frequency (required).</param>
        public SystemExecutionCpuInformation(int count = default(int), string brand = default(string), int frequency = default(int))
        {
            this.Count = count;
            // to ensure "brand" is required (not null)
            if (brand == null)
            {
                throw new ArgumentNullException("brand is a required property for SystemExecutionCpuInformation and cannot be null");
            }
            this.Brand = brand;
            this.Frequency = frequency;
        }

        /// <summary>
        /// this is the number of cpus
        /// </summary>
        /// <value>this is the number of cpus</value>
        [DataMember(Name = "count", IsRequired = true, EmitDefaultValue = true)]
        public int Count { get; set; }

        /// <summary>
        /// this is the brand of cpu
        /// </summary>
        /// <value>this is the brand of cpu</value>
        [DataMember(Name = "brand", IsRequired = true, EmitDefaultValue = true)]
        public string Brand { get; set; }

        /// <summary>
        /// Gets or Sets Frequency
        /// </summary>
        [DataMember(Name = "frequency", IsRequired = true, EmitDefaultValue = true)]
        public int Frequency { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SystemExecutionCpuInformation {\n");
            sb.Append("  Count: ").Append(Count).Append("\n");
            sb.Append("  Brand: ").Append(Brand).Append("\n");
            sb.Append("  Frequency: ").Append(Frequency).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
