/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the target that was sent to pieces. This will return the string that represents this coppied || pasted asset. This will also send along the SeededConnectorCreation and will send along the vector that we created based on the seed.
    /// </summary>
    [DataContract(Name = "SuggestionTarget")]
    public partial class SuggestionTarget : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SuggestionTarget" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SuggestionTarget() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SuggestionTarget" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="seed">seed (required).</param>
        /// <param name="vector">This is the vector representation of this target that we generated. (required).</param>
        public SuggestionTarget(EmbeddedModelSchema schema = default(EmbeddedModelSchema), SeededConnectorCreation seed = default(SeededConnectorCreation), int vector = default(int))
        {
            // to ensure "seed" is required (not null)
            if (seed == null)
            {
                throw new ArgumentNullException("seed is a required property for SuggestionTarget and cannot be null");
            }
            this.Seed = seed;
            this.Vector = vector;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Seed
        /// </summary>
        [DataMember(Name = "seed", IsRequired = true, EmitDefaultValue = true)]
        public SeededConnectorCreation Seed { get; set; }

        /// <summary>
        /// This is the vector representation of this target that we generated.
        /// </summary>
        /// <value>This is the vector representation of this target that we generated.</value>
        [DataMember(Name = "vector", IsRequired = true, EmitDefaultValue = true)]
        public int Vector { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SuggestionTarget {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Seed: ").Append(Seed).Append("\n");
            sb.Append("  Vector: ").Append(Vector).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
