/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is currently only used within /assets/steam/identifiers &amp;&amp; /conversations/steam/identifiers &amp;&amp; annotations but can be used with other as well, if we want to expand this class.
    /// </summary>
    [DataContract(Name = "StreamedIdentifier")]
    public partial class StreamedIdentifier : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="StreamedIdentifier" /> class.
        /// </summary>
        /// <param name="asset">asset.</param>
        /// <param name="conversation">conversation.</param>
        /// <param name="annotation">annotation.</param>
        /// <param name="activity">activity.</param>
        /// <param name="anchor">anchor.</param>
        /// <param name="anchorPoint">anchorPoint.</param>
        /// <param name="hint">hint.</param>
        /// <param name="conversationMessage">conversationMessage.</param>
        /// <param name="format">format.</param>
        /// <param name="person">person.</param>
        /// <param name="range">range.</param>
        /// <param name="sensitive">sensitive.</param>
        /// <param name="tag">tag.</param>
        /// <param name="website">website.</param>
        /// <param name="application">application.</param>
        /// <param name="model">model.</param>
        /// <param name="deleted">This is a specific bool that will let us know if we deleted an Identifierfrom the db..</param>
        public StreamedIdentifier(ReferencedAsset asset = default(ReferencedAsset), ReferencedConversation conversation = default(ReferencedConversation), ReferencedAnnotation annotation = default(ReferencedAnnotation), ReferencedActivity activity = default(ReferencedActivity), ReferencedAnchor anchor = default(ReferencedAnchor), ReferencedAnchorPoint anchorPoint = default(ReferencedAnchorPoint), ReferencedHint hint = default(ReferencedHint), ReferencedConversationMessage conversationMessage = default(ReferencedConversationMessage), ReferencedFormat format = default(ReferencedFormat), ReferencedPerson person = default(ReferencedPerson), ReferencedRange range = default(ReferencedRange), ReferencedSensitive sensitive = default(ReferencedSensitive), ReferencedTag tag = default(ReferencedTag), ReferencedWebsite website = default(ReferencedWebsite), ReferencedApplication application = default(ReferencedApplication), ReferencedModel model = default(ReferencedModel), bool deleted = default(bool))
        {
            this.Asset = asset;
            this.Conversation = conversation;
            this.Annotation = annotation;
            this.Activity = activity;
            this.Anchor = anchor;
            this.AnchorPoint = anchorPoint;
            this.Hint = hint;
            this.ConversationMessage = conversationMessage;
            this.Format = format;
            this.Person = person;
            this.Range = range;
            this.Sensitive = sensitive;
            this.Tag = tag;
            this.Website = website;
            this.Application = application;
            this.Model = model;
            this.Deleted = deleted;
        }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public ReferencedAsset Asset { get; set; }

        /// <summary>
        /// Gets or Sets Conversation
        /// </summary>
        [DataMember(Name = "conversation", EmitDefaultValue = false)]
        public ReferencedConversation Conversation { get; set; }

        /// <summary>
        /// Gets or Sets Annotation
        /// </summary>
        [DataMember(Name = "annotation", EmitDefaultValue = false)]
        public ReferencedAnnotation Annotation { get; set; }

        /// <summary>
        /// Gets or Sets Activity
        /// </summary>
        [DataMember(Name = "activity", EmitDefaultValue = false)]
        public ReferencedActivity Activity { get; set; }

        /// <summary>
        /// Gets or Sets Anchor
        /// </summary>
        [DataMember(Name = "anchor", EmitDefaultValue = false)]
        public ReferencedAnchor Anchor { get; set; }

        /// <summary>
        /// Gets or Sets AnchorPoint
        /// </summary>
        [DataMember(Name = "anchorPoint", EmitDefaultValue = false)]
        public ReferencedAnchorPoint AnchorPoint { get; set; }

        /// <summary>
        /// Gets or Sets Hint
        /// </summary>
        [DataMember(Name = "hint", EmitDefaultValue = false)]
        public ReferencedHint Hint { get; set; }

        /// <summary>
        /// Gets or Sets ConversationMessage
        /// </summary>
        [DataMember(Name = "conversationMessage", EmitDefaultValue = false)]
        public ReferencedConversationMessage ConversationMessage { get; set; }

        /// <summary>
        /// Gets or Sets Format
        /// </summary>
        [DataMember(Name = "format", EmitDefaultValue = false)]
        public ReferencedFormat Format { get; set; }

        /// <summary>
        /// Gets or Sets Person
        /// </summary>
        [DataMember(Name = "person", EmitDefaultValue = false)]
        public ReferencedPerson Person { get; set; }

        /// <summary>
        /// Gets or Sets Range
        /// </summary>
        [DataMember(Name = "range", EmitDefaultValue = false)]
        public ReferencedRange Range { get; set; }

        /// <summary>
        /// Gets or Sets Sensitive
        /// </summary>
        [DataMember(Name = "sensitive", EmitDefaultValue = false)]
        public ReferencedSensitive Sensitive { get; set; }

        /// <summary>
        /// Gets or Sets Tag
        /// </summary>
        [DataMember(Name = "tag", EmitDefaultValue = false)]
        public ReferencedTag Tag { get; set; }

        /// <summary>
        /// Gets or Sets Website
        /// </summary>
        [DataMember(Name = "website", EmitDefaultValue = false)]
        public ReferencedWebsite Website { get; set; }

        /// <summary>
        /// Gets or Sets Application
        /// </summary>
        [DataMember(Name = "application", EmitDefaultValue = false)]
        public ReferencedApplication Application { get; set; }

        /// <summary>
        /// Gets or Sets Model
        /// </summary>
        [DataMember(Name = "model", EmitDefaultValue = false)]
        public ReferencedModel Model { get; set; }

        /// <summary>
        /// This is a specific bool that will let us know if we deleted an Identifierfrom the db.
        /// </summary>
        /// <value>This is a specific bool that will let us know if we deleted an Identifierfrom the db.</value>
        [DataMember(Name = "deleted", EmitDefaultValue = true)]
        public bool Deleted { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class StreamedIdentifier {\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("  Annotation: ").Append(Annotation).Append("\n");
            sb.Append("  Activity: ").Append(Activity).Append("\n");
            sb.Append("  Anchor: ").Append(Anchor).Append("\n");
            sb.Append("  AnchorPoint: ").Append(AnchorPoint).Append("\n");
            sb.Append("  Hint: ").Append(Hint).Append("\n");
            sb.Append("  ConversationMessage: ").Append(ConversationMessage).Append("\n");
            sb.Append("  Format: ").Append(Format).Append("\n");
            sb.Append("  Person: ").Append(Person).Append("\n");
            sb.Append("  Range: ").Append(Range).Append("\n");
            sb.Append("  Sensitive: ").Append(Sensitive).Append("\n");
            sb.Append("  Tag: ").Append(Tag).Append("\n");
            sb.Append("  Website: ").Append(Website).Append("\n");
            sb.Append("  Application: ").Append(Application).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Deleted: ").Append(Deleted).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
