/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is optional metatdata attached to a sensitive piece of data.
    /// </summary>
    [DataContract(Name = "SensitiveMetadata")]
    public partial class SensitiveMetadata : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SensitiveMetadata" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="match">match.</param>
        /// <param name="entropy">entropy of the sensitive.</param>
        public SensitiveMetadata(EmbeddedModelSchema schema = default(EmbeddedModelSchema), TextMatch match = default(TextMatch), decimal entropy = default(decimal))
        {
            this.Schema = schema;
            this.Match = match;
            this.Entropy = entropy;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Match
        /// </summary>
        [DataMember(Name = "match", EmitDefaultValue = false)]
        public TextMatch Match { get; set; }

        /// <summary>
        /// entropy of the sensitive
        /// </summary>
        /// <value>entropy of the sensitive</value>
        [DataMember(Name = "entropy", EmitDefaultValue = false)]
        public decimal Entropy { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SensitiveMetadata {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Match: ").Append(Match).Append("\n");
            sb.Append("  Entropy: ").Append(Entropy).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
